/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.item.HangingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapData;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemFrameEntity
extends HangingEntity {
    private static final Logger field_195052_c = LogManager.getLogger();
    private static final DataParameter<ItemStack> field_184525_c = EntityDataManager.func_187226_a(ItemFrameEntity.class, DataSerializers.field_187196_f);
    private static final DataParameter<Integer> field_184526_d = EntityDataManager.func_187226_a(ItemFrameEntity.class, DataSerializers.field_187192_b);
    private float field_82337_e = 1.0f;

    public ItemFrameEntity(EntityType<? extends ItemFrameEntity> entityType, World world) {
        super((EntityType<? extends HangingEntity>)entityType, world);
    }

    public ItemFrameEntity(World world, BlockPos blockPos, Direction direction) {
        super(EntityType.field_200766_F, world, blockPos);
        this.func_174859_a(direction);
    }

    @Override
    protected float func_213316_a(Pose pose, EntitySize entitySize) {
        return 0.0f;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184525_c, ItemStack.field_190927_a);
        this.func_184212_Q().func_187214_a(field_184526_d, 0);
    }

    @Override
    protected void func_174859_a(Direction direction) {
        Validate.notNull((Object)direction);
        this.field_174860_b = direction;
        if (direction.func_176740_k().func_176722_c()) {
            this.field_70125_A = 0.0f;
            this.field_70177_z = this.field_174860_b.func_176736_b() * 90;
        } else {
            this.field_70125_A = -90 * direction.func_176743_c().func_179524_a();
            this.field_70177_z = 0.0f;
        }
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        this.func_174856_o();
    }

    @Override
    protected void func_174856_o() {
        if (this.field_174860_b == null) {
            return;
        }
        double d = 0.46875;
        \u2603 = (double)this.field_174861_a.func_177958_n() + 0.5 - (double)this.field_174860_b.func_82601_c() * 0.46875;
        \u2603 = (double)this.field_174861_a.func_177956_o() + 0.5 - (double)this.field_174860_b.func_96559_d() * 0.46875;
        \u2603 = (double)this.field_174861_a.func_177952_p() + 0.5 - (double)this.field_174860_b.func_82599_e() * 0.46875;
        this.func_226288_n_(\u2603, \u2603, \u2603);
        \u2603 = this.func_82329_d();
        \u2603 = this.func_82330_g();
        \u2603 = this.func_82329_d();
        Direction.Axis \u26032 = this.field_174860_b.func_176740_k();
        switch (\u26032) {
            case X: {
                \u2603 = 1.0;
                break;
            }
            case Y: {
                \u2603 = 1.0;
                break;
            }
            case Z: {
                \u2603 = 1.0;
            }
        }
        this.func_174826_a(new AxisAlignedBB(\u2603 - (\u2603 /= 32.0), \u2603 - (\u2603 /= 32.0), \u2603 - (\u2603 /= 32.0), \u2603 + \u2603, \u2603 + \u2603, \u2603 + \u2603));
    }

    @Override
    public boolean func_70518_d() {
        if (!this.field_70170_p.func_226669_j_(this)) {
            return false;
        }
        BlockState blockState = this.field_70170_p.func_180495_p(this.field_174861_a.func_177972_a(this.field_174860_b.func_176734_d()));
        if (!(blockState.func_185904_a().func_76220_a() || this.field_174860_b.func_176740_k().func_176722_c() && RedstoneDiodeBlock.func_185546_B(blockState))) {
            return false;
        }
        return this.field_70170_p.func_175674_a(this, this.func_174813_aQ(), field_184524_c).isEmpty();
    }

    @Override
    public float func_70111_Y() {
        return 0.0f;
    }

    @Override
    public void func_174812_G() {
        this.func_110131_b(this.func_82335_i());
        super.func_174812_G();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        if (!damageSource.func_94541_c() && !this.func_82335_i().func_190926_b()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_146065_b(damageSource.func_76346_g(), false);
                this.func_184185_a(SoundEvents.field_187629_cO, 1.0f, 1.0f);
            }
            return true;
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    public int func_82329_d() {
        return 12;
    }

    @Override
    public int func_82330_g() {
        return 12;
    }

    @Override
    public boolean func_70112_a(double d) {
        \u2603 = 16.0;
        return d < (\u2603 *= 64.0 * ItemFrameEntity.func_184183_bd()) * \u2603;
    }

    @Override
    public void func_110128_b(@Nullable Entity entity) {
        this.func_184185_a(SoundEvents.field_187623_cM, 1.0f, 1.0f);
        this.func_146065_b(entity, true);
    }

    @Override
    public void func_184523_o() {
        this.func_184185_a(SoundEvents.field_187626_cN, 1.0f, 1.0f);
    }

    private void func_146065_b(@Nullable Entity entity, boolean bl2) {
        boolean bl2;
        if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            if (entity == null) {
                this.func_110131_b(this.func_82335_i());
            }
            return;
        }
        ItemStack itemStack = this.func_82335_i();
        this.func_82334_a(ItemStack.field_190927_a);
        if (entity instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)entity;
            if (playerEntity.field_71075_bZ.field_75098_d) {
                this.func_110131_b(itemStack);
                return;
            }
        }
        if (bl2) {
            this.func_199703_a(Items.field_151160_bD);
        }
        if (!itemStack.func_190926_b()) {
            itemStack = itemStack.func_77946_l();
            this.func_110131_b(itemStack);
            if (this.field_70146_Z.nextFloat() < this.field_82337_e) {
                this.func_199701_a_(itemStack);
            }
        }
    }

    private void func_110131_b(ItemStack itemStack2) {
        ItemStack itemStack2;
        if (itemStack2.func_77973_b() == Items.field_151098_aY) {
            MapData mapData = FilledMapItem.func_195950_a(itemStack2, this.field_70170_p);
            mapData.func_212441_a(this.field_174861_a, this.func_145782_y());
            mapData.func_76186_a(true);
        }
        itemStack2.func_82842_a(null);
    }

    public ItemStack func_82335_i() {
        return this.func_184212_Q().func_187225_a(field_184525_c);
    }

    public void func_82334_a(ItemStack itemStack) {
        this.func_174864_a(itemStack, true);
    }

    public void func_174864_a(ItemStack itemStack2, boolean bl) {
        ItemStack itemStack2;
        if (!itemStack2.func_190926_b()) {
            itemStack2 = itemStack2.func_77946_l();
            itemStack2.func_190920_e(1);
            itemStack2.func_82842_a(this);
        }
        this.func_184212_Q().func_187227_b(field_184525_c, itemStack2);
        if (!itemStack2.func_190926_b()) {
            this.func_184185_a(SoundEvents.field_187620_cL, 1.0f, 1.0f);
        }
        if (bl && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    @Override
    public boolean func_174820_d(int n, ItemStack itemStack) {
        if (n == 0) {
            this.func_82334_a(itemStack);
            return true;
        }
        return false;
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        if (dataParameter.equals(field_184525_c) && !(\u2603 = this.func_82335_i()).func_190926_b() && \u2603.func_82836_z() != this) {
            \u2603.func_82842_a(this);
        }
    }

    public int func_82333_j() {
        return this.func_184212_Q().func_187225_a(field_184526_d);
    }

    public void func_82336_g(int n) {
        this.func_174865_a(n, true);
    }

    private void func_174865_a(int n, boolean bl) {
        this.func_184212_Q().func_187227_b(field_184526_d, n % 8);
        if (bl && this.field_174861_a != null) {
            this.field_70170_p.func_175666_e(this.field_174861_a, Blocks.field_150350_a);
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        if (!this.func_82335_i().func_190926_b()) {
            compoundNBT.func_218657_a("Item", this.func_82335_i().func_77955_b(new CompoundNBT()));
            compoundNBT.func_74774_a("ItemRotation", (byte)this.func_82333_j());
            compoundNBT.func_74776_a("ItemDropChance", this.field_82337_e);
        }
        compoundNBT.func_74774_a("Facing", (byte)this.field_174860_b.func_176745_a());
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT2;
        super.func_70037_a(compoundNBT2);
        \u2603 = compoundNBT2.func_74775_l("Item");
        if (\u2603 != null && !\u2603.isEmpty()) {
            ItemStack itemStack = ItemStack.func_199557_a(\u2603);
            if (itemStack.func_190926_b()) {
                field_195052_c.warn("Unable to load item from: {}", (Object)\u2603);
            }
            if (!(\u2603 = this.func_82335_i()).func_190926_b() && !ItemStack.func_77989_b(itemStack, \u2603)) {
                this.func_110131_b(\u2603);
            }
            this.func_174864_a(itemStack, false);
            this.func_174865_a(compoundNBT2.func_74771_c("ItemRotation"), false);
            if (compoundNBT2.func_150297_b("ItemDropChance", 99)) {
                this.field_82337_e = compoundNBT2.func_74760_g("ItemDropChance");
            }
        }
        this.func_174859_a(Direction.func_82600_a(compoundNBT2.func_74771_c("Facing")));
    }

    @Override
    public boolean func_184230_a(PlayerEntity playerEntity, Hand hand) {
        ItemStack itemStack = playerEntity.func_184586_b(hand);
        boolean \u26032 = !this.func_82335_i().func_190926_b();
        boolean bl = \u2603 = !itemStack.func_190926_b();
        if (this.field_70170_p.field_72995_K) {
            return \u26032 || \u2603;
        }
        if (!\u26032) {
            if (\u2603) {
                this.func_82334_a(itemStack);
                if (!playerEntity.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
        } else {
            this.func_184185_a(SoundEvents.field_187632_cP, 1.0f, 1.0f);
            this.func_82336_g(this.func_82333_j() + 1);
        }
        return true;
    }

    public int func_174866_q() {
        if (this.func_82335_i().func_190926_b()) {
            return 0;
        }
        return this.func_82333_j() % 8 + 1;
    }

    @Override
    public IPacket<?> func_213297_N() {
        return new SSpawnObjectPacket(this, this.func_200600_R(), this.field_174860_b.func_176745_a(), this.func_174857_n());
    }
}

