/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.google.common.collect.Lists;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MoveTowardsRaidGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.AbstractIllagerEntity;
import net.minecraft.entity.monster.PatrollerEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.WolfEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.village.PointOfInterestType;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.raid.Raid;
import net.minecraft.world.raid.RaidManager;
import net.minecraft.world.server.ServerWorld;

public abstract class AbstractRaiderEntity
extends PatrollerEntity {
    protected static final DataParameter<Boolean> field_213666_c = EntityDataManager.func_187226_a(AbstractRaiderEntity.class, DataSerializers.field_187198_h);
    private static final Predicate<ItemEntity> field_213665_b = itemEntity -> !itemEntity.func_174874_s() && itemEntity.func_70089_S() && ItemStack.func_77989_b(itemEntity.func_92059_d(), Raid.func_221312_H());
    @Nullable
    protected Raid field_213667_d;
    private int field_213668_bz;
    private boolean field_213669_bA;
    private int field_213664_bB;

    protected AbstractRaiderEntity(EntityType<? extends AbstractRaiderEntity> entityType, World world) {
        super((EntityType<? extends PatrollerEntity>)entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, new PromoteLeaderGoal(this, this));
        this.field_70714_bg.func_75776_a(3, new MoveTowardsRaidGoal<AbstractRaiderEntity>(this));
        this.field_70714_bg.func_75776_a(4, new InvadeHomeGoal(this, 1.05f, 1));
        this.field_70714_bg.func_75776_a(5, new CelebrateRaidLossGoal(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_213666_c, false);
    }

    public abstract void func_213660_a(int var1, boolean var2);

    public boolean func_213658_ej() {
        return this.field_213669_bA;
    }

    public void func_213644_t(boolean bl) {
        this.field_213669_bA = bl;
    }

    @Override
    public void func_70636_d() {
        if (this.field_70170_p instanceof ServerWorld && this.func_70089_S()) {
            Raid raid = this.func_213663_ek();
            if (this.func_213658_ej()) {
                if (raid == null) {
                    if (this.field_70170_p.func_82737_E() % 20L == 0L && (\u2603 = ((ServerWorld)this.field_70170_p).func_217475_c_(new BlockPos(this))) != null && RaidManager.func_215165_a(this, \u2603)) {
                        \u2603.func_221317_a(\u2603.func_221315_l(), this, null, true);
                    }
                } else {
                    LivingEntity livingEntity = this.func_70638_az();
                    if (livingEntity != null && (livingEntity.func_200600_R() == EntityType.field_200729_aH || livingEntity.func_200600_R() == EntityType.field_200757_aw)) {
                        this.field_70708_bq = 0;
                    }
                }
            }
        }
        super.func_70636_d();
    }

    @Override
    protected void func_213623_ec() {
        this.field_70708_bq += 2;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        if (this.field_70170_p instanceof ServerWorld) {
            Entity entity = damageSource.func_76346_g();
            Raid \u26032 = this.func_213663_ek();
            if (\u26032 != null) {
                if (this.func_213630_eb()) {
                    \u26032.func_221296_c(this.func_213642_em());
                }
                if (entity != null && entity.func_200600_R() == EntityType.field_200729_aH) {
                    \u26032.func_221311_a(entity);
                }
                \u26032.func_221322_a(this, false);
            }
            if (this.func_213630_eb() && \u26032 == null && ((ServerWorld)this.field_70170_p).func_217475_c_(new BlockPos(this)) == null) {
                ItemStack itemStack = this.func_184582_a(EquipmentSlotType.HEAD);
                PlayerEntity \u26033 = null;
                Entity \u26034 = entity;
                if (\u26034 instanceof PlayerEntity) {
                    \u26033 = (PlayerEntity)\u26034;
                } else if (\u26034 instanceof WolfEntity) {
                    Object object = (WolfEntity)\u26034;
                    LivingEntity \u26035 = ((TameableEntity)object).func_70902_q();
                    if (((TameableEntity)object).func_70909_n() && \u26035 instanceof PlayerEntity) {
                        \u26033 = (PlayerEntity)\u26035;
                    }
                }
                if (!itemStack.func_190926_b() && ItemStack.func_77989_b(itemStack, Raid.func_221312_H()) && \u26033 != null) {
                    object = \u26033.func_70660_b(Effects.field_220309_E);
                    int \u26036 = 1;
                    if (object != null) {
                        \u26036 += ((EffectInstance)object).func_76458_c();
                        \u26033.func_184596_c(Effects.field_220309_E);
                    } else {
                        --\u26036;
                    }
                    \u26036 = MathHelper.func_76125_a(\u26036, 0, 5);
                    EffectInstance \u26037 = new EffectInstance(Effects.field_220309_E, 120000, \u26036, false, false, true);
                    if (!this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223621_x)) {
                        \u26033.func_195064_c(\u26037);
                    }
                }
            }
        }
        super.func_70645_a(damageSource);
    }

    @Override
    public boolean func_213634_ed() {
        return !this.func_213657_el();
    }

    public void func_213652_a(@Nullable Raid raid) {
        this.field_213667_d = raid;
    }

    @Nullable
    public Raid func_213663_ek() {
        return this.field_213667_d;
    }

    public boolean func_213657_el() {
        return this.func_213663_ek() != null && this.func_213663_ek().func_221333_v();
    }

    public void func_213651_a(int n) {
        this.field_213668_bz = n;
    }

    public int func_213642_em() {
        return this.field_213668_bz;
    }

    public boolean func_213656_en() {
        return this.field_70180_af.func_187225_a(field_213666_c);
    }

    public void func_213655_u(boolean bl) {
        this.field_70180_af.func_187227_b(field_213666_c, bl);
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
        super.func_213281_b(compoundNBT);
        compoundNBT.func_74768_a("Wave", this.field_213668_bz);
        compoundNBT.func_74757_a("CanJoinRaid", this.field_213669_bA);
        if (this.field_213667_d != null) {
            compoundNBT.func_74768_a("RaidId", this.field_213667_d.func_221325_u());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
        super.func_70037_a(compoundNBT);
        this.field_213668_bz = compoundNBT.func_74762_e("Wave");
        this.field_213669_bA = compoundNBT.func_74767_n("CanJoinRaid");
        if (compoundNBT.func_150297_b("RaidId", 3)) {
            if (this.field_70170_p instanceof ServerWorld) {
                this.field_213667_d = ((ServerWorld)this.field_70170_p).func_217452_C().func_215167_a(compoundNBT.func_74762_e("RaidId"));
            }
            if (this.field_213667_d != null) {
                this.field_213667_d.func_221300_a(this.field_213668_bz, this, false);
                if (this.func_213630_eb()) {
                    this.field_213667_d.func_221324_a(this.field_213668_bz, this);
                }
            }
        }
    }

    @Override
    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemStack = itemEntity.func_92059_d();
        boolean bl = \u2603 = this.func_213657_el() && this.func_213663_ek().func_221332_b(this.func_213642_em()) != null;
        if (this.func_213657_el() && !\u2603 && ItemStack.func_77989_b(itemStack, Raid.func_221312_H())) {
            EquipmentSlotType equipmentSlotType = EquipmentSlotType.HEAD;
            ItemStack \u26032 = this.func_184582_a(equipmentSlotType);
            double \u26033 = this.func_205712_c(equipmentSlotType);
            if (!\u26032.func_190926_b() && (double)Math.max(this.field_70146_Z.nextFloat() - 0.1f, 0.0f) < \u26033) {
                this.func_199701_a_(\u26032);
            }
            this.func_184201_a(equipmentSlotType, itemStack);
            this.func_71001_a(itemEntity, itemStack.func_190916_E());
            itemEntity.func_70106_y();
            this.func_213663_ek().func_221324_a(this.func_213642_em(), this);
            this.func_213635_r(true);
        } else {
            super.func_175445_a(itemEntity);
        }
    }

    @Override
    public boolean func_213397_c(double d) {
        if (this.func_213663_ek() == null) {
            return super.func_213397_c(d);
        }
        return false;
    }

    @Override
    public boolean func_213392_I() {
        return this.func_213663_ek() != null;
    }

    public int func_213661_eo() {
        return this.field_213664_bB;
    }

    public void func_213653_b(int n) {
        this.field_213664_bB = n;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_213657_el()) {
            this.func_213663_ek().func_221320_q();
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld iWorld, DifficultyInstance difficultyInstance, SpawnReason spawnReason, @Nullable ILivingEntityData iLivingEntityData, @Nullable CompoundNBT compoundNBT) {
        this.func_213644_t(this.func_200600_R() != EntityType.field_200759_ay || spawnReason != SpawnReason.NATURAL);
        return super.func_213386_a(iWorld, difficultyInstance, spawnReason, iLivingEntityData, compoundNBT);
    }

    public abstract SoundEvent func_213654_dW();

    static class InvadeHomeGoal
    extends Goal {
        private final AbstractRaiderEntity field_220864_a;
        private final double field_220865_b;
        private BlockPos field_220866_c;
        private final List<BlockPos> field_220867_d = Lists.newArrayList();
        private final int field_220868_e;
        private boolean field_220869_f;

        public InvadeHomeGoal(AbstractRaiderEntity abstractRaiderEntity, double d, int n) {
            this.field_220864_a = abstractRaiderEntity;
            this.field_220865_b = d;
            this.field_220868_e = n;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            this.func_220861_j();
            return this.func_220862_g() && this.func_220863_h() && this.field_220864_a.func_70638_az() == null;
        }

        private boolean func_220862_g() {
            return this.field_220864_a.func_213657_el() && !this.field_220864_a.func_213663_ek().func_221319_a();
        }

        private boolean func_220863_h() {
            ServerWorld serverWorld = (ServerWorld)this.field_220864_a.field_70170_p;
            BlockPos \u26032 = new BlockPos(this.field_220864_a);
            Optional<BlockPos> \u26033 = serverWorld.func_217443_B().func_219163_a(pointOfInterestType -> pointOfInterestType == PointOfInterestType.field_221069_q, this::func_220860_a, PointOfInterestManager.Status.ANY, \u26032, 48, this.field_220864_a.field_70146_Z);
            if (!\u26033.isPresent()) {
                return false;
            }
            this.field_220866_c = \u26033.get().func_185334_h();
            return true;
        }

        @Override
        public boolean func_75253_b() {
            if (this.field_220864_a.func_70661_as().func_75500_f()) {
                return false;
            }
            return this.field_220864_a.func_70638_az() == null && !this.field_220866_c.func_218137_a(this.field_220864_a.func_213303_ch(), this.field_220864_a.func_213311_cf() + (float)this.field_220868_e) && !this.field_220869_f;
        }

        @Override
        public void func_75251_c() {
            if (this.field_220866_c.func_218137_a(this.field_220864_a.func_213303_ch(), this.field_220868_e)) {
                this.field_220867_d.add(this.field_220866_c);
            }
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.field_220864_a.func_213332_m(0);
            this.field_220864_a.func_70661_as().func_75492_a(this.field_220866_c.func_177958_n(), this.field_220866_c.func_177956_o(), this.field_220866_c.func_177952_p(), this.field_220865_b);
            this.field_220869_f = false;
        }

        @Override
        public void func_75246_d() {
            if (this.field_220864_a.func_70661_as().func_75500_f()) {
                Vec3d vec3d = new Vec3d(this.field_220866_c);
                \u2603 = RandomPositionGenerator.func_203155_a(this.field_220864_a, 16, 7, vec3d, 0.3141592741012573);
                if (\u2603 == null) {
                    \u2603 = RandomPositionGenerator.func_75464_a(this.field_220864_a, 8, 7, vec3d);
                }
                if (\u2603 == null) {
                    this.field_220869_f = true;
                    return;
                }
                this.field_220864_a.func_70661_as().func_75492_a(\u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c, this.field_220865_b);
            }
        }

        private boolean func_220860_a(BlockPos blockPos) {
            for (BlockPos blockPos2 : this.field_220867_d) {
                if (!Objects.equals(blockPos, blockPos2)) continue;
                return false;
            }
            return true;
        }

        private void func_220861_j() {
            if (this.field_220867_d.size() > 2) {
                this.field_220867_d.remove(0);
            }
        }
    }

    public class FindTargetGoal
    extends Goal {
        private final AbstractRaiderEntity field_220853_c;
        private final float field_220854_d;
        public final EntityPredicate field_220851_a = new EntityPredicate().func_221013_a(8.0).func_221009_d().func_221008_a().func_221011_b().func_221014_c().func_221010_e();

        public FindTargetGoal(AbstractIllagerEntity abstractIllagerEntity, float f) {
            this.field_220853_c = abstractIllagerEntity;
            this.field_220854_d = f * f;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity livingEntity = this.field_220853_c.func_70643_av();
            return this.field_220853_c.func_213663_ek() == null && this.field_220853_c.func_213633_ef() && this.field_220853_c.func_70638_az() != null && !this.field_220853_c.func_213398_dR() && (livingEntity == null || livingEntity.func_200600_R() != EntityType.field_200729_aH);
        }

        @Override
        public void func_75249_e() {
            super.func_75249_e();
            this.field_220853_c.func_70661_as().func_75499_g();
            List<AbstractRaiderEntity> list = this.field_220853_c.field_70170_p.func_217374_a(AbstractRaiderEntity.class, this.field_220851_a, this.field_220853_c, this.field_220853_c.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
            for (AbstractRaiderEntity abstractRaiderEntity : list) {
                abstractRaiderEntity.func_70624_b(this.field_220853_c.func_70638_az());
            }
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            LivingEntity livingEntity = this.field_220853_c.func_70638_az();
            if (livingEntity != null) {
                List<AbstractRaiderEntity> list = this.field_220853_c.field_70170_p.func_217374_a(AbstractRaiderEntity.class, this.field_220851_a, this.field_220853_c, this.field_220853_c.func_174813_aQ().func_72314_b(8.0, 8.0, 8.0));
                for (AbstractRaiderEntity abstractRaiderEntity : list) {
                    abstractRaiderEntity.func_70624_b(livingEntity);
                    abstractRaiderEntity.func_213395_q(true);
                }
                this.field_220853_c.func_213395_q(true);
            }
        }

        @Override
        public void func_75246_d() {
            LivingEntity livingEntity = this.field_220853_c.func_70638_az();
            if (livingEntity == null) {
                return;
            }
            if (this.field_220853_c.func_70068_e(livingEntity) > (double)this.field_220854_d) {
                this.field_220853_c.func_70671_ap().func_75651_a(livingEntity, 30.0f, 30.0f);
                if (this.field_220853_c.field_70146_Z.nextInt(50) == 0) {
                    this.field_220853_c.func_70642_aH();
                }
            } else {
                this.field_220853_c.func_213395_q(true);
            }
            super.func_75246_d();
        }
    }

    public class CelebrateRaidLossGoal
    extends Goal {
        private final AbstractRaiderEntity field_220858_b;

        CelebrateRaidLossGoal(AbstractRaiderEntity abstractRaiderEntity2) {
            this.field_220858_b = abstractRaiderEntity2;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            Raid raid = this.field_220858_b.func_213663_ek();
            return this.field_220858_b.func_70089_S() && this.field_220858_b.func_70638_az() == null && raid != null && raid.func_221336_f();
        }

        @Override
        public void func_75249_e() {
            this.field_220858_b.func_213655_u(true);
            super.func_75249_e();
        }

        @Override
        public void func_75251_c() {
            this.field_220858_b.func_213655_u(false);
            super.func_75251_c();
        }

        @Override
        public void func_75246_d() {
            if (!this.field_220858_b.func_174814_R() && this.field_220858_b.field_70146_Z.nextInt(100) == 0) {
                AbstractRaiderEntity.this.func_184185_a(AbstractRaiderEntity.this.func_213654_dW(), AbstractRaiderEntity.this.func_70599_aP(), AbstractRaiderEntity.this.func_70647_i());
            }
            if (!this.field_220858_b.func_184218_aH() && this.field_220858_b.field_70146_Z.nextInt(50) == 0) {
                this.field_220858_b.func_70683_ar().func_75660_a();
            }
            super.func_75246_d();
        }
    }

    public static class PromoteLeaderGoal<T extends AbstractRaiderEntity>
    extends Goal {
        private final T field_220856_b;
        final /* synthetic */ AbstractRaiderEntity field_220855_a;

        public PromoteLeaderGoal(T t) {
            this.field_220855_a = \u2603;
            this.field_220856_b = t;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        @Override
        public boolean func_75250_a() {
            Raid raid = ((AbstractRaiderEntity)this.field_220856_b).func_213663_ek();
            if (!((AbstractRaiderEntity)this.field_220856_b).func_213657_el() || ((AbstractRaiderEntity)this.field_220856_b).func_213663_ek().func_221319_a() || !((PatrollerEntity)this.field_220856_b).func_213637_dY() || ItemStack.func_77989_b(((MobEntity)this.field_220856_b).func_184582_a(EquipmentSlotType.HEAD), Raid.func_221312_H())) {
                return false;
            }
            AbstractRaiderEntity \u26032 = raid.func_221332_b(((AbstractRaiderEntity)this.field_220856_b).func_213642_em());
            if (!(\u26032 != null && \u26032.func_70089_S() || (\u2603 = ((AbstractRaiderEntity)this.field_220856_b).field_70170_p.func_175647_a(ItemEntity.class, ((Entity)this.field_220856_b).func_174813_aQ().func_72314_b(16.0, 8.0, 16.0), field_213665_b)).isEmpty())) {
                return ((MobEntity)this.field_220856_b).func_70661_as().func_75497_a(\u2603.get(0), 1.15f);
            }
            return false;
        }

        @Override
        public void func_75246_d() {
            List<ItemEntity> list;
            if (((MobEntity)this.field_220856_b).func_70661_as().func_208485_j().func_218137_a(((Entity)this.field_220856_b).func_213303_ch(), 1.414) && !(list = ((AbstractRaiderEntity)this.field_220856_b).field_70170_p.func_175647_a(ItemEntity.class, ((Entity)this.field_220856_b).func_174813_aQ().func_72314_b(4.0, 4.0, 4.0), field_213665_b)).isEmpty()) {
                ((AbstractRaiderEntity)this.field_220856_b).func_175445_a(list.get(0));
            }
        }
    }
}

