/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.EnumSet;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class GuardianEntity
extends MonsterEntity {
    private static final DataParameter<Boolean> field_190766_bz = EntityDataManager.func_187226_a(GuardianEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184723_b = EntityDataManager.func_187226_a(GuardianEntity.class, DataSerializers.field_187192_b);
    protected float field_175482_b;
    protected float field_175484_c;
    protected float field_175483_bk;
    protected float field_175485_bl;
    protected float field_175486_bm;
    private LivingEntity field_175478_bn;
    private int field_175479_bo;
    private boolean field_175480_bp;
    protected RandomWalkingGoal field_175481_bq;

    public GuardianEntity(EntityType<? extends GuardianEntity> entityType, World world) {
        super((EntityType<? extends MonsterEntity>)entityType, world);
        this.field_70728_aV = 10;
        this.func_184644_a(PathNodeType.WATER, 0.0f);
        this.field_70765_h = new MoveHelperController(this);
        this.field_175484_c = this.field_175482_b = this.field_70146_Z.nextFloat();
    }

    @Override
    protected void func_184651_r() {
        MoveTowardsRestrictionGoal moveTowardsRestrictionGoal = new MoveTowardsRestrictionGoal(this, 1.0);
        this.field_175481_bq = new RandomWalkingGoal(this, 1.0, 80);
        this.field_70714_bg.func_75776_a(4, new AttackGoal(this));
        this.field_70714_bg.func_75776_a(5, moveTowardsRestrictionGoal);
        this.field_70714_bg.func_75776_a(7, this.field_175481_bq);
        this.field_70714_bg.func_75776_a(8, new LookAtGoal(this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, new LookAtGoal(this, GuardianEntity.class, 12.0f, 0.01f));
        this.field_70714_bg.func_75776_a(9, new LookRandomlyGoal(this));
        this.field_175481_bq.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        moveTowardsRestrictionGoal.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.field_70715_bh.func_75776_a(1, new NearestAttackableTargetGoal<LivingEntity>(this, LivingEntity.class, 10, true, false, new TargetPredicate(this)));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(6.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(16.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
    }

    @Override
    protected PathNavigator func_175447_b(World world) {
        return new SwimmerPathNavigator(this, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_190766_bz, false);
        this.field_70180_af.func_187214_a(field_184723_b, 0);
    }

    @Override
    public boolean func_70648_aU() {
        return true;
    }

    @Override
    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_203100_e;
    }

    public boolean func_175472_n() {
        return this.field_70180_af.func_187225_a(field_190766_bz);
    }

    private void func_175476_l(boolean bl) {
        this.field_70180_af.func_187227_b(field_190766_bz, bl);
    }

    public int func_175464_ck() {
        return 80;
    }

    private void func_175463_b(int n) {
        this.field_70180_af.func_187227_b(field_184723_b, n);
    }

    public boolean func_175474_cn() {
        return this.field_70180_af.func_187225_a(field_184723_b) != 0;
    }

    @Nullable
    public LivingEntity func_175466_co() {
        if (!this.func_175474_cn()) {
            return null;
        }
        if (this.field_70170_p.field_72995_K) {
            if (this.field_175478_bn != null) {
                return this.field_175478_bn;
            }
            Entity entity = this.field_70170_p.func_73045_a(this.field_70180_af.func_187225_a(field_184723_b));
            if (entity instanceof LivingEntity) {
                this.field_175478_bn = (LivingEntity)entity;
                return this.field_175478_bn;
            }
            return null;
        }
        return this.func_70638_az();
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter) {
        super.func_184206_a(dataParameter);
        if (field_184723_b.equals(dataParameter)) {
            this.field_175479_bo = 0;
            this.field_175478_bn = null;
        }
    }

    @Override
    public int func_70627_aG() {
        return 160;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return this.func_203005_aq() ? SoundEvents.field_187670_cb : SoundEvents.field_187672_cc;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return this.func_203005_aq() ? SoundEvents.field_187687_ch : SoundEvents.field_187690_ci;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return this.func_203005_aq() ? SoundEvents.field_187678_ce : SoundEvents.field_187681_cf;
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.5f;
    }

    @Override
    public float func_205022_a(BlockPos blockPos, IWorldReader iWorldReader) {
        if (iWorldReader.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a)) {
            return 10.0f + iWorldReader.func_205052_D(blockPos) - 0.5f;
        }
        return super.func_205022_a(blockPos, iWorldReader);
    }

    @Override
    public void func_70636_d() {
        if (this.func_70089_S()) {
            if (this.field_70170_p.field_72995_K) {
                Object object;
                this.field_175484_c = this.field_175482_b;
                if (!this.func_70090_H()) {
                    this.field_175483_bk = 2.0f;
                    object = this.func_213322_ci();
                    if (((Vec3d)object).field_72448_b > 0.0 && this.field_175480_bp && !this.func_174814_R()) {
                        this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.func_190765_dj(), this.func_184176_by(), 1.0f, 1.0f, false);
                    }
                    this.field_175480_bp = ((Vec3d)object).field_72448_b < 0.0 && this.field_70170_p.func_217400_a(new BlockPos(this).func_177977_b(), this);
                } else {
                    this.field_175483_bk = this.func_175472_n() ? (this.field_175483_bk < 0.5f ? 4.0f : (this.field_175483_bk += (0.5f - this.field_175483_bk) * 0.1f)) : (this.field_175483_bk += (0.125f - this.field_175483_bk) * 0.2f);
                }
                this.field_175482_b += this.field_175483_bk;
                this.field_175486_bm = this.field_175485_bl;
                this.field_175485_bl = !this.func_203005_aq() ? this.field_70146_Z.nextFloat() : (this.func_175472_n() ? (this.field_175485_bl += (0.0f - this.field_175485_bl) * 0.25f) : (this.field_175485_bl += (1.0f - this.field_175485_bl) * 0.06f));
                if (this.func_175472_n() && this.func_70090_H()) {
                    object = this.func_70676_i(0.0f);
                    for (int i = 0; i < 2; ++i) {
                        this.field_70170_p.func_195594_a(ParticleTypes.field_197612_e, this.func_226282_d_(0.5) - ((Vec3d)object).field_72450_a * 1.5, this.func_226279_cv_() - ((Vec3d)object).field_72448_b * 1.5, this.func_226287_g_(0.5) - ((Vec3d)object).field_72449_c * 1.5, 0.0, 0.0, 0.0);
                    }
                }
                if (this.func_175474_cn()) {
                    if (this.field_175479_bo < this.func_175464_ck()) {
                        ++this.field_175479_bo;
                    }
                    if ((object = this.func_175466_co()) != null) {
                        this.func_70671_ap().func_75651_a((Entity)object, 90.0f, 90.0f);
                        this.func_70671_ap().func_75649_a();
                        double d = this.func_175477_p(0.0f);
                        \u2603 = ((Entity)object).func_226277_ct_() - this.func_226277_ct_();
                        \u2603 = ((Entity)object).func_226283_e_(0.5) - this.func_226280_cw_();
                        \u2603 = ((Entity)object).func_226281_cx_() - this.func_226281_cx_();
                        \u2603 = Math.sqrt(\u2603 * \u2603 + \u2603 * \u2603 + \u2603 * \u2603);
                        \u2603 /= \u2603;
                        \u2603 /= \u2603;
                        \u2603 /= \u2603;
                        \u2603 = this.field_70146_Z.nextDouble();
                        while (\u2603 < \u2603) {
                            this.field_70170_p.func_195594_a(ParticleTypes.field_197612_e, this.func_226277_ct_() + \u2603 * (\u2603 += 1.8 - d + this.field_70146_Z.nextDouble() * (1.7 - d)), this.func_226280_cw_() + \u2603 * \u2603, this.func_226281_cx_() + \u2603 * \u2603, 0.0, 0.0, 0.0);
                        }
                    }
                }
            }
            if (this.func_203005_aq()) {
                this.func_70050_g(300);
            } else if (this.field_70122_E) {
                this.func_213317_d(this.func_213322_ci().func_72441_c((this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f, 0.5, (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * 0.4f));
                this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
                this.field_70122_E = false;
                this.field_70160_al = true;
            }
            if (this.func_175474_cn()) {
                this.field_70177_z = this.field_70759_as;
            }
        }
        super.func_70636_d();
    }

    protected SoundEvent func_190765_dj() {
        return SoundEvents.field_187684_cg;
    }

    public float func_175471_a(float f) {
        return MathHelper.func_219799_g(f, this.field_175484_c, this.field_175482_b);
    }

    public float func_175469_o(float f) {
        return MathHelper.func_219799_g(f, this.field_175486_bm, this.field_175485_bl);
    }

    public float func_175477_p(float f) {
        return ((float)this.field_175479_bo + f) / (float)this.func_175464_ck();
    }

    @Override
    public boolean func_205019_a(IWorldReader iWorldReader) {
        return iWorldReader.func_226668_i_(this);
    }

    public static boolean func_223329_b(EntityType<? extends GuardianEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return !(random.nextInt(20) != 0 && iWorld.func_175710_j(blockPos) || iWorld.func_175659_aa() == Difficulty.PEACEFUL || spawnReason != SpawnReason.SPAWNER && !iWorld.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a));
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource2, float f) {
        DamageSource damageSource2;
        if (!this.func_175472_n() && !damageSource2.func_82725_o() && damageSource2.func_76364_f() instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)damageSource2.func_76364_f();
            if (!damageSource2.func_94541_c()) {
                livingEntity.func_70097_a(DamageSource.func_92087_a(this), 2.0f);
            }
        }
        if (this.field_175481_bq != null) {
            this.field_175481_bq.func_179480_f();
        }
        return super.func_70097_a(damageSource2, f);
    }

    @Override
    public int func_70646_bf() {
        return 180;
    }

    @Override
    public void func_213352_e(Vec3d vec3d) {
        if (this.func_70613_aW() && this.func_70090_H()) {
            this.func_213309_a(0.1f, vec3d);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
            if (!this.func_175472_n() && this.func_70638_az() == null) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.005, 0.0));
            }
        } else {
            super.func_213352_e(vec3d);
        }
    }

    static class MoveHelperController
    extends MovementController {
        private final GuardianEntity field_179930_g;

        public MoveHelperController(GuardianEntity guardianEntity) {
            super(guardianEntity);
            this.field_179930_g = guardianEntity;
        }

        @Override
        public void func_75641_c() {
            if (this.field_188491_h != MovementController.Action.MOVE_TO || this.field_179930_g.func_70661_as().func_75500_f()) {
                this.field_179930_g.func_70659_e(0.0f);
                this.field_179930_g.func_175476_l(false);
                return;
            }
            Vec3d vec3d = new Vec3d(this.field_75646_b - this.field_179930_g.func_226277_ct_(), this.field_75647_c - this.field_179930_g.func_226278_cu_(), this.field_75644_d - this.field_179930_g.func_226281_cx_());
            double \u26032 = vec3d.func_72433_c();
            double \u26033 = vec3d.field_72450_a / \u26032;
            double \u26034 = vec3d.field_72448_b / \u26032;
            double \u26035 = vec3d.field_72449_c / \u26032;
            float \u26036 = (float)(MathHelper.func_181159_b(vec3d.field_72449_c, vec3d.field_72450_a) * 57.2957763671875) - 90.0f;
            this.field_179930_g.field_70761_aq = this.field_179930_g.field_70177_z = this.func_75639_a(this.field_179930_g.field_70177_z, \u26036, 90.0f);
            float \u26037 = (float)(this.field_75645_e * this.field_179930_g.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            float \u26038 = MathHelper.func_219799_g(0.125f, this.field_179930_g.func_70689_ay(), \u26037);
            this.field_179930_g.func_70659_e(\u26038);
            double \u26039 = Math.sin((double)(this.field_179930_g.field_70173_aa + this.field_179930_g.func_145782_y()) * 0.5) * 0.05;
            double \u260310 = Math.cos(this.field_179930_g.field_70177_z * ((float)Math.PI / 180));
            double \u260311 = Math.sin(this.field_179930_g.field_70177_z * ((float)Math.PI / 180));
            double \u260312 = Math.sin((double)(this.field_179930_g.field_70173_aa + this.field_179930_g.func_145782_y()) * 0.75) * 0.05;
            this.field_179930_g.func_213317_d(this.field_179930_g.func_213322_ci().func_72441_c(\u26039 * \u260310, \u260312 * (\u260311 + \u260310) * 0.25 + (double)\u26038 * \u26034 * 0.1, \u26039 * \u260311));
            LookController \u260313 = this.field_179930_g.func_70671_ap();
            double \u260314 = this.field_179930_g.func_226277_ct_() + \u26033 * 2.0;
            double \u260315 = this.field_179930_g.func_226280_cw_() + \u26034 / \u26032;
            double \u260316 = this.field_179930_g.func_226281_cx_() + \u26035 * 2.0;
            double \u260317 = \u260313.func_180423_e();
            double \u260318 = \u260313.func_180422_f();
            double \u260319 = \u260313.func_180421_g();
            if (!\u260313.func_180424_b()) {
                \u260317 = \u260314;
                \u260318 = \u260315;
                \u260319 = \u260316;
            }
            this.field_179930_g.func_70671_ap().func_75650_a(MathHelper.func_219803_d(0.125, \u260317, \u260314), MathHelper.func_219803_d(0.125, \u260318, \u260315), MathHelper.func_219803_d(0.125, \u260319, \u260316), 10.0f, 40.0f);
            this.field_179930_g.func_175476_l(true);
        }
    }

    static class AttackGoal
    extends Goal {
        private final GuardianEntity field_179456_a;
        private int field_179455_b;
        private final boolean field_190881_c;

        public AttackGoal(GuardianEntity guardianEntity) {
            this.field_179456_a = guardianEntity;
            this.field_190881_c = guardianEntity instanceof ElderGuardianEntity;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity livingEntity = this.field_179456_a.func_70638_az();
            return livingEntity != null && livingEntity.func_70089_S();
        }

        @Override
        public boolean func_75253_b() {
            return super.func_75253_b() && (this.field_190881_c || this.field_179456_a.func_70068_e(this.field_179456_a.func_70638_az()) > 9.0);
        }

        @Override
        public void func_75249_e() {
            this.field_179455_b = -10;
            this.field_179456_a.func_70661_as().func_75499_g();
            this.field_179456_a.func_70671_ap().func_75651_a(this.field_179456_a.func_70638_az(), 90.0f, 90.0f);
            this.field_179456_a.field_70160_al = true;
        }

        @Override
        public void func_75251_c() {
            this.field_179456_a.func_175463_b(0);
            this.field_179456_a.func_70624_b(null);
            this.field_179456_a.field_175481_bq.func_179480_f();
        }

        @Override
        public void func_75246_d() {
            LivingEntity livingEntity = this.field_179456_a.func_70638_az();
            this.field_179456_a.func_70661_as().func_75499_g();
            this.field_179456_a.func_70671_ap().func_75651_a(livingEntity, 90.0f, 90.0f);
            if (!this.field_179456_a.func_70685_l(livingEntity)) {
                this.field_179456_a.func_70624_b(null);
                return;
            }
            ++this.field_179455_b;
            if (this.field_179455_b == 0) {
                this.field_179456_a.func_175463_b(this.field_179456_a.func_70638_az().func_145782_y());
                this.field_179456_a.field_70170_p.func_72960_a(this.field_179456_a, (byte)21);
            } else if (this.field_179455_b >= this.field_179456_a.func_175464_ck()) {
                float f = 1.0f;
                if (this.field_179456_a.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    f += 2.0f;
                }
                if (this.field_190881_c) {
                    f += 2.0f;
                }
                livingEntity.func_70097_a(DamageSource.func_76354_b(this.field_179456_a, this.field_179456_a), f);
                livingEntity.func_70097_a(DamageSource.func_76358_a(this.field_179456_a), (float)this.field_179456_a.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
                this.field_179456_a.func_70624_b(null);
            }
            super.func_75246_d();
        }
    }

    static class TargetPredicate
    implements Predicate<LivingEntity> {
        private final GuardianEntity field_179916_a;

        public TargetPredicate(GuardianEntity guardianEntity) {
            this.field_179916_a = guardianEntity;
        }

        @Override
        public boolean test(@Nullable LivingEntity livingEntity) {
            return (livingEntity instanceof PlayerEntity || livingEntity instanceof SquidEntity) && livingEntity.func_70068_e(this.field_179916_a) > 9.0;
        }

        @Override
        public /* synthetic */ boolean test(@Nullable Object object) {
            return this.test((LivingEntity)object);
        }
    }
}

