/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SquidEntity
extends WaterMobEntity {
    public float field_70861_d;
    public float field_70862_e;
    public float field_70859_f;
    public float field_70860_g;
    public float field_70867_h;
    public float field_70868_i;
    public float field_70866_j;
    public float field_70865_by;
    private float field_70863_bz;
    private float field_70864_bA;
    private float field_70871_bB;
    private float field_70872_bC;
    private float field_70869_bD;
    private float field_70870_bE;

    public SquidEntity(EntityType<? extends SquidEntity> entityType, World world) {
        super((EntityType<? extends WaterMobEntity>)entityType, world);
        this.field_70146_Z.setSeed(this.func_145782_y());
        this.field_70864_bA = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new MoveRandomGoal(this));
        this.field_70714_bg.func_75776_a(1, new FleeGoal());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
    }

    @Override
    protected float func_213348_b(Pose pose, EntitySize entitySize) {
        return entitySize.field_220316_b * 0.5f;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187829_fQ;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187833_fS;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187831_fR;
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        this.field_70862_e = this.field_70861_d;
        this.field_70860_g = this.field_70859_f;
        this.field_70868_i = this.field_70867_h;
        this.field_70865_by = this.field_70866_j;
        this.field_70867_h += this.field_70864_bA;
        if ((double)this.field_70867_h > Math.PI * 2) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70867_h = (float)Math.PI * 2;
            } else {
                this.field_70867_h = (float)((double)this.field_70867_h - Math.PI * 2);
                if (this.field_70146_Z.nextInt(10) == 0) {
                    this.field_70864_bA = 1.0f / (this.field_70146_Z.nextFloat() + 1.0f) * 0.2f;
                }
                this.field_70170_p.func_72960_a(this, (byte)19);
            }
        }
        if (this.func_203005_aq()) {
            if (this.field_70867_h < (float)Math.PI) {
                float f = this.field_70867_h / (float)Math.PI;
                this.field_70866_j = MathHelper.func_76126_a(f * f * (float)Math.PI) * (float)Math.PI * 0.25f;
                if ((double)f > 0.75) {
                    this.field_70863_bz = 1.0f;
                    this.field_70871_bB = 1.0f;
                } else {
                    this.field_70871_bB *= 0.8f;
                }
            } else {
                this.field_70866_j = 0.0f;
                this.field_70863_bz *= 0.9f;
                this.field_70871_bB *= 0.99f;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_213293_j(this.field_70872_bC * this.field_70863_bz, this.field_70869_bD * this.field_70863_bz, this.field_70870_bE * this.field_70863_bz);
            }
            Vec3d vec3d = this.func_213322_ci();
            float \u26032 = MathHelper.func_76133_a(SquidEntity.func_213296_b(vec3d));
            this.field_70761_aq += (-((float)MathHelper.func_181159_b(vec3d.field_72450_a, vec3d.field_72449_c)) * 57.295776f - this.field_70761_aq) * 0.1f;
            this.field_70177_z = this.field_70761_aq;
            this.field_70859_f = (float)((double)this.field_70859_f + Math.PI * (double)this.field_70871_bB * 1.5);
            this.field_70861_d += (-((float)MathHelper.func_181159_b(\u26032, vec3d.field_72448_b)) * 57.295776f - this.field_70861_d) * 0.1f;
        } else {
            this.field_70866_j = MathHelper.func_76135_e(MathHelper.func_76126_a(this.field_70867_h)) * (float)Math.PI * 0.25f;
            if (!this.field_70170_p.field_72995_K) {
                double d = this.func_213322_ci().field_72448_b;
                if (this.func_70644_a(Effects.field_188424_y)) {
                    d = 0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1);
                } else if (!this.func_189652_ae()) {
                    d -= 0.08;
                }
                this.func_213293_j(0.0, d * (double)0.98f, 0.0);
            }
            this.field_70861_d = (float)((double)this.field_70861_d + (double)(-90.0f - this.field_70861_d) * 0.02);
        }
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (super.func_70097_a(damageSource, f) && this.func_70643_av() != null) {
            this.func_203039_dq();
            return true;
        }
        return false;
    }

    private Vec3d func_207400_b(Vec3d vec3d) {
        \u2603 = vec3d.func_178789_a(this.field_70862_e * ((float)Math.PI / 180));
        \u2603 = \u2603.func_178785_b(-this.field_70760_ar * ((float)Math.PI / 180));
        return \u2603;
    }

    private void func_203039_dq() {
        this.func_184185_a(SoundEvents.field_203639_hT, this.func_70599_aP(), this.func_70647_i());
        Vec3d vec3d = this.func_207400_b(new Vec3d(0.0, -1.0, 0.0)).func_72441_c(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        for (int i = 0; i < 30; ++i) {
            Vec3d vec3d2 = this.func_207400_b(new Vec3d((double)this.field_70146_Z.nextFloat() * 0.6 - 0.3, -1.0, (double)this.field_70146_Z.nextFloat() * 0.6 - 0.3));
            \u2603 = vec3d2.func_186678_a(0.3 + (double)(this.field_70146_Z.nextFloat() * 2.0f));
            ((ServerWorld)this.field_70170_p).func_195598_a(ParticleTypes.field_203219_V, vec3d.field_72450_a, vec3d.field_72448_b + 0.5, vec3d.field_72449_c, 0, \u2603.field_72450_a, \u2603.field_72448_b, \u2603.field_72449_c, 0.1f);
        }
    }

    @Override
    public void func_213352_e(Vec3d vec3d) {
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
    }

    public static boolean func_223365_b(EntityType<SquidEntity> entityType, IWorld iWorld, SpawnReason spawnReason, BlockPos blockPos, Random random) {
        return blockPos.func_177956_o() > 45 && blockPos.func_177956_o() < iWorld.func_181545_F();
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 19) {
            this.field_70867_h = 0.0f;
        } else {
            super.func_70103_a(by);
        }
    }

    public void func_175568_b(float f, float f2, float f3) {
        this.field_70872_bC = f;
        this.field_70869_bD = f2;
        this.field_70870_bE = f3;
    }

    public boolean func_175567_n() {
        return this.field_70872_bC != 0.0f || this.field_70869_bD != 0.0f || this.field_70870_bE != 0.0f;
    }

    class FleeGoal
    extends Goal {
        private int field_203125_b;

        private FleeGoal() {
        }

        @Override
        public boolean func_75250_a() {
            LivingEntity livingEntity = SquidEntity.this.func_70643_av();
            if (SquidEntity.this.func_70090_H() && livingEntity != null) {
                return SquidEntity.this.func_70068_e(livingEntity) < 100.0;
            }
            return false;
        }

        @Override
        public void func_75249_e() {
            this.field_203125_b = 0;
        }

        @Override
        public void func_75246_d() {
            ++this.field_203125_b;
            LivingEntity livingEntity = SquidEntity.this.func_70643_av();
            if (livingEntity == null) {
                return;
            }
            Vec3d \u26032 = new Vec3d(SquidEntity.this.func_226277_ct_() - livingEntity.func_226277_ct_(), SquidEntity.this.func_226278_cu_() - livingEntity.func_226278_cu_(), SquidEntity.this.func_226281_cx_() - livingEntity.func_226281_cx_());
            BlockState \u26033 = SquidEntity.this.field_70170_p.func_180495_p(new BlockPos(SquidEntity.this.func_226277_ct_() + \u26032.field_72450_a, SquidEntity.this.func_226278_cu_() + \u26032.field_72448_b, SquidEntity.this.func_226281_cx_() + \u26032.field_72449_c));
            IFluidState \u26034 = SquidEntity.this.field_70170_p.func_204610_c(new BlockPos(SquidEntity.this.func_226277_ct_() + \u26032.field_72450_a, SquidEntity.this.func_226278_cu_() + \u26032.field_72448_b, SquidEntity.this.func_226281_cx_() + \u26032.field_72449_c));
            if (\u26034.func_206884_a(FluidTags.field_206959_a) || \u26033.func_196958_f()) {
                double d = \u26032.func_72433_c();
                if (d > 0.0) {
                    \u26032.func_72432_b();
                    float f = 3.0f;
                    if (d > 5.0) {
                        f = (float)((double)f - (d - 5.0) / 5.0);
                    }
                    if (f > 0.0f) {
                        \u26032 = \u26032.func_186678_a(f);
                    }
                }
                if (\u26033.func_196958_f()) {
                    \u26032 = \u26032.func_178786_a(0.0, \u26032.field_72448_b, 0.0);
                }
                SquidEntity.this.func_175568_b((float)\u26032.field_72450_a / 20.0f, (float)\u26032.field_72448_b / 20.0f, (float)\u26032.field_72449_c / 20.0f);
            }
            if (this.field_203125_b % 10 == 5) {
                SquidEntity.this.field_70170_p.func_195594_a(ParticleTypes.field_197612_e, SquidEntity.this.func_226277_ct_(), SquidEntity.this.func_226278_cu_(), SquidEntity.this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    class MoveRandomGoal
    extends Goal {
        private final SquidEntity field_179476_a;

        public MoveRandomGoal(SquidEntity squidEntity2) {
            this.field_179476_a = squidEntity2;
        }

        @Override
        public boolean func_75250_a() {
            return true;
        }

        @Override
        public void func_75246_d() {
            int n = this.field_179476_a.func_70654_ax();
            if (n > 100) {
                this.field_179476_a.func_175568_b(0.0f, 0.0f, 0.0f);
            } else if (this.field_179476_a.func_70681_au().nextInt(50) == 0 || !this.field_179476_a.field_70171_ac || !this.field_179476_a.func_175567_n()) {
                float f = this.field_179476_a.func_70681_au().nextFloat() * ((float)Math.PI * 2);
                \u2603 = MathHelper.func_76134_b(f) * 0.2f;
                \u2603 = -0.1f + this.field_179476_a.func_70681_au().nextFloat() * 0.2f;
                \u2603 = MathHelper.func_76126_a(f) * 0.2f;
                this.field_179476_a.func_175568_b(\u2603, \u2603, \u2603);
            }
        }
    }
}

