/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SSpawnObjectPacket;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootParameters;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTables;

public class FishingBobberEntity
extends Entity {
    private static final DataParameter<Integer> field_184528_c = EntityDataManager.func_187226_a(FishingBobberEntity.class, DataSerializers.field_187192_b);
    private boolean field_146051_au;
    private int field_146049_av;
    private final PlayerEntity field_146042_b;
    private int field_146047_aw;
    private int field_146045_ax;
    private int field_146040_ay;
    private int field_146038_az;
    private float field_146054_aA;
    public Entity field_146043_c;
    private State field_190627_av = State.FLYING;
    private final int field_191518_aw;
    private final int field_191519_ax;

    private FishingBobberEntity(World world, PlayerEntity playerEntity, int n, int n2) {
        super(EntityType.field_200730_aI, world);
        this.field_70158_ak = true;
        this.field_146042_b = playerEntity;
        this.field_146042_b.field_71104_cf = this;
        this.field_191518_aw = Math.max(0, n);
        this.field_191519_ax = Math.max(0, n2);
    }

    public FishingBobberEntity(World world, PlayerEntity playerEntity, double d, double d2, double d3) {
        this(world, playerEntity, 0, 0);
        this.func_70107_b(d, d2, d3);
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
    }

    public FishingBobberEntity(PlayerEntity playerEntity, World world, int n, int n2) {
        this(world, playerEntity, n, n2);
        float f = this.field_146042_b.field_70125_A;
        \u2603 = this.field_146042_b.field_70177_z;
        \u2603 = MathHelper.func_76134_b(-\u2603 * ((float)Math.PI / 180) - (float)Math.PI);
        \u2603 = MathHelper.func_76126_a(-\u2603 * ((float)Math.PI / 180) - (float)Math.PI);
        \u2603 = -MathHelper.func_76134_b(-f * ((float)Math.PI / 180));
        \u2603 = MathHelper.func_76126_a(-f * ((float)Math.PI / 180));
        double \u26032 = this.field_146042_b.func_226277_ct_() - (double)\u2603 * 0.3;
        double \u26033 = this.field_146042_b.func_226280_cw_();
        double \u26034 = this.field_146042_b.func_226281_cx_() - (double)\u2603 * 0.3;
        this.func_70012_b(\u26032, \u26033, \u26034, \u2603, f);
        Vec3d \u26035 = new Vec3d(-\u2603, MathHelper.func_76131_a(-(\u2603 / \u2603), -5.0f, 5.0f), -\u2603);
        double \u26036 = \u26035.func_72433_c();
        \u26035 = \u26035.func_216372_d(0.6 / \u26036 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / \u26036 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045, 0.6 / \u26036 + 0.5 + this.field_70146_Z.nextGaussian() * 0.0045);
        this.func_213317_d(\u26035);
        this.field_70177_z = (float)(MathHelper.func_181159_b(\u26035.field_72450_a, \u26035.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(\u26035.field_72448_b, MathHelper.func_76133_a(FishingBobberEntity.func_213296_b(\u26035))) * 57.2957763671875);
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184528_c, 0);
    }

    @Override
    public void func_184206_a(DataParameter<?> dataParameter2) {
        DataParameter<?> dataParameter2;
        if (field_184528_c.equals(dataParameter2)) {
            int n = this.func_184212_Q().func_187225_a(field_184528_c);
            this.field_146043_c = n > 0 ? this.field_70170_p.func_73045_a(n - 1) : null;
        }
        super.func_184206_a(dataParameter2);
    }

    @Override
    public boolean func_70112_a(double d) {
        \u2603 = 64.0;
        return d < 4096.0;
    }

    @Override
    public void func_180426_a(double d, double d2, double d3, float f, float f2, int n, boolean bl) {
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_146042_b == null) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.func_190625_o()) {
            return;
        }
        if (this.field_146051_au) {
            ++this.field_146049_av;
            if (this.field_146049_av >= 1200) {
                this.func_70106_y();
                return;
            }
        }
        float f = 0.0f;
        BlockPos \u26032 = new BlockPos(this);
        IFluidState \u26033 = this.field_70170_p.func_204610_c(\u26032);
        if (\u26033.func_206884_a(FluidTags.field_206959_a)) {
            f = \u26033.func_215679_a(this.field_70170_p, \u26032);
        }
        if (this.field_190627_av == State.FLYING) {
            if (this.field_146043_c != null) {
                this.func_213317_d(Vec3d.field_186680_a);
                this.field_190627_av = State.HOOKED_IN_ENTITY;
                return;
            }
            if (f > 0.0f) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.3, 0.2, 0.3));
                this.field_190627_av = State.BOBBING;
                return;
            }
            if (!this.field_70170_p.field_72995_K) {
                this.func_190624_r();
            }
            if (this.field_146051_au || this.field_70122_E || this.field_70123_F) {
                this.field_146047_aw = 0;
                this.func_213317_d(Vec3d.field_186680_a);
            } else {
                ++this.field_146047_aw;
            }
        } else {
            if (this.field_190627_av == State.HOOKED_IN_ENTITY) {
                if (this.field_146043_c != null) {
                    if (this.field_146043_c.field_70128_L) {
                        this.field_146043_c = null;
                        this.field_190627_av = State.FLYING;
                    } else {
                        this.func_70107_b(this.field_146043_c.func_226277_ct_(), this.field_146043_c.func_226283_e_(0.8), this.field_146043_c.func_226281_cx_());
                    }
                }
                return;
            }
            if (this.field_190627_av == State.BOBBING) {
                Vec3d vec3d = this.func_213322_ci();
                double \u26034 = this.func_226278_cu_() + vec3d.field_72448_b - (double)\u26032.func_177956_o() - (double)f;
                if (Math.abs(\u26034) < 0.01) {
                    \u26034 += Math.signum(\u26034) * 0.1;
                }
                this.func_213293_j(vec3d.field_72450_a * 0.9, vec3d.field_72448_b - \u26034 * (double)this.field_70146_Z.nextFloat() * 0.2, vec3d.field_72449_c * 0.9);
                if (!this.field_70170_p.field_72995_K && f > 0.0f) {
                    this.func_190621_a(\u26032);
                }
            }
        }
        if (!\u26033.func_206884_a(FluidTags.field_206959_a)) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        this.func_190623_q();
        double d = 0.92;
        this.func_213317_d(this.func_213322_ci().func_186678_a(0.92));
        this.func_226264_Z_();
    }

    private boolean func_190625_o() {
        ItemStack itemStack = this.field_146042_b.func_184614_ca();
        \u2603 = this.field_146042_b.func_184592_cb();
        boolean \u26032 = itemStack.func_77973_b() == Items.field_151112_aM;
        boolean bl = \u2603 = \u2603.func_77973_b() == Items.field_151112_aM;
        if (this.field_146042_b.field_70128_L || !this.field_146042_b.func_70089_S() || !\u26032 && !\u2603 || this.func_70068_e(this.field_146042_b) > 1024.0) {
            this.func_70106_y();
            return true;
        }
        return false;
    }

    private void func_190623_q() {
        Vec3d vec3d = this.func_213322_ci();
        float \u26032 = MathHelper.func_76133_a(FishingBobberEntity.func_213296_b(vec3d));
        this.field_70177_z = (float)(MathHelper.func_181159_b(vec3d.field_72450_a, vec3d.field_72449_c) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(vec3d.field_72448_b, \u26032) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = MathHelper.func_219799_g(0.2f, this.field_70127_C, this.field_70125_A);
        this.field_70177_z = MathHelper.func_219799_g(0.2f, this.field_70126_B, this.field_70177_z);
    }

    private void func_190624_r() {
        RayTraceResult rayTraceResult = ProjectileHelper.func_221267_a(this, this.func_174813_aQ().func_216361_a(this.func_213322_ci()).func_186662_g(1.0), entity -> !(entity.func_175149_v() || !entity.func_70067_L() && !(entity instanceof ItemEntity) || entity == this.field_146042_b && this.field_146047_aw < 5), RayTraceContext.BlockMode.COLLIDER, true);
        if (rayTraceResult.func_216346_c() != RayTraceResult.Type.MISS) {
            if (rayTraceResult.func_216346_c() == RayTraceResult.Type.ENTITY) {
                this.field_146043_c = ((EntityRayTraceResult)rayTraceResult).func_216348_a();
                this.func_190622_s();
            } else {
                this.field_146051_au = true;
            }
        }
    }

    private void func_190622_s() {
        this.func_184212_Q().func_187227_b(field_184528_c, this.field_146043_c.func_145782_y() + 1);
    }

    private void func_190621_a(BlockPos blockPos) {
        ServerWorld serverWorld = (ServerWorld)this.field_70170_p;
        int \u26032 = 1;
        BlockPos \u26033 = blockPos.func_177984_a();
        if (this.field_70146_Z.nextFloat() < 0.25f && this.field_70170_p.func_175727_C(\u26033)) {
            ++\u26032;
        }
        if (this.field_70146_Z.nextFloat() < 0.5f && !this.field_70170_p.func_226660_f_(\u26033)) {
            --\u26032;
        }
        if (this.field_146045_ax > 0) {
            --this.field_146045_ax;
            if (this.field_146045_ax <= 0) {
                this.field_146040_ay = 0;
                this.field_146038_az = 0;
            } else {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.2 * (double)this.field_70146_Z.nextFloat() * (double)this.field_70146_Z.nextFloat(), 0.0));
            }
        } else if (this.field_146038_az > 0) {
            this.field_146038_az -= \u26032;
            if (this.field_146038_az > 0) {
                this.field_146054_aA = (float)((double)this.field_146054_aA + this.field_70146_Z.nextGaussian() * 4.0);
                float f = this.field_146054_aA * ((float)Math.PI / 180);
                \u2603 = MathHelper.func_76126_a(f);
                \u2603 = MathHelper.func_76134_b(f);
                double \u26034 = this.func_226277_ct_() + (double)(\u2603 * (float)this.field_146038_az * 0.1f);
                Block \u26035 = serverWorld.func_180495_p(new BlockPos(\u26034, (\u2603 = (double)((float)MathHelper.func_76128_c(this.func_226278_cu_()) + 1.0f)) - 1.0, \u2603 = this.func_226281_cx_() + (double)(\u2603 * (float)this.field_146038_az * 0.1f))).func_177230_c();
                if (\u26035 == Blocks.field_150355_j) {
                    if (this.field_70146_Z.nextFloat() < 0.15f) {
                        serverWorld.func_195598_a(ParticleTypes.field_197612_e, \u26034, \u2603 - (double)0.1f, \u2603, 1, \u2603, 0.1, \u2603, 0.0);
                    }
                    \u2603 = \u2603 * 0.04f;
                    \u2603 = \u2603 * 0.04f;
                    serverWorld.func_195598_a(ParticleTypes.field_197630_w, \u26034, \u2603, \u2603, 0, \u2603, 0.01, -\u2603, 1.0);
                    serverWorld.func_195598_a(ParticleTypes.field_197630_w, \u26034, \u2603, \u2603, 0, -\u2603, 0.01, \u2603, 1.0);
                }
            } else {
                Vec3d \u26036 = this.func_213322_ci();
                this.func_213293_j(\u26036.field_72450_a, -0.4f * MathHelper.func_151240_a(this.field_70146_Z, 0.6f, 1.0f), \u26036.field_72449_c);
                this.func_184185_a(SoundEvents.field_187609_F, 0.25f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.4f);
                double \u26037 = this.func_226278_cu_() + 0.5;
                serverWorld.func_195598_a(ParticleTypes.field_197612_e, this.func_226277_ct_(), \u26037, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), this.func_213311_cf(), 0.0, this.func_213311_cf(), 0.2f);
                serverWorld.func_195598_a(ParticleTypes.field_197630_w, this.func_226277_ct_(), \u26037, this.func_226281_cx_(), (int)(1.0f + this.func_213311_cf() * 20.0f), this.func_213311_cf(), 0.0, this.func_213311_cf(), 0.2f);
                this.field_146045_ax = MathHelper.func_76136_a(this.field_70146_Z, 20, 40);
            }
        } else if (this.field_146040_ay > 0) {
            this.field_146040_ay -= \u26032;
            \u2603 = 0.15f;
            if (this.field_146040_ay < 20) {
                \u2603 = (float)((double)\u2603 + (double)(20 - this.field_146040_ay) * 0.05);
            } else if (this.field_146040_ay < 40) {
                \u2603 = (float)((double)\u2603 + (double)(40 - this.field_146040_ay) * 0.02);
            } else if (this.field_146040_ay < 60) {
                \u2603 = (float)((double)\u2603 + (double)(60 - this.field_146040_ay) * 0.01);
            }
            if (this.field_70146_Z.nextFloat() < \u2603) {
                \u2603 = MathHelper.func_151240_a(this.field_70146_Z, 0.0f, 360.0f) * ((float)Math.PI / 180);
                \u2603 = MathHelper.func_151240_a(this.field_70146_Z, 25.0f, 60.0f);
                double \u26038 = this.func_226277_ct_() + (double)(MathHelper.func_76126_a(\u2603) * \u2603 * 0.1f);
                Block \u26039 = serverWorld.func_180495_p(new BlockPos(\u26038, (\u2603 = (double)((float)MathHelper.func_76128_c(this.func_226278_cu_()) + 1.0f)) - 1.0, \u2603 = this.func_226281_cx_() + (double)(MathHelper.func_76134_b(\u2603) * \u2603 * 0.1f))).func_177230_c();
                if (\u26039 == Blocks.field_150355_j) {
                    serverWorld.func_195598_a(ParticleTypes.field_218422_X, \u26038, \u2603, \u2603, 2 + this.field_70146_Z.nextInt(2), 0.1f, 0.0, 0.1f, 0.0);
                }
            }
            if (this.field_146040_ay <= 0) {
                this.field_146054_aA = MathHelper.func_151240_a(this.field_70146_Z, 0.0f, 360.0f);
                this.field_146038_az = MathHelper.func_76136_a(this.field_70146_Z, 20, 80);
            }
        } else {
            this.field_146040_ay = MathHelper.func_76136_a(this.field_70146_Z, 100, 600);
            this.field_146040_ay -= this.field_191519_ax * 20 * 5;
        }
    }

    @Override
    public void func_213281_b(CompoundNBT compoundNBT) {
    }

    @Override
    public void func_70037_a(CompoundNBT compoundNBT) {
    }

    public int func_146034_e(ItemStack itemStack) {
        if (this.field_70170_p.field_72995_K || this.field_146042_b == null) {
            return 0;
        }
        int n = 0;
        if (this.field_146043_c != null) {
            this.func_184527_k();
            CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)this.field_146042_b, itemStack, this, Collections.emptyList());
            this.field_70170_p.func_72960_a(this, (byte)31);
            n = this.field_146043_c instanceof ItemEntity ? 3 : 5;
        } else if (this.field_146045_ax > 0) {
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_70170_p).func_216015_a(LootParameters.field_216286_f, new BlockPos(this)).func_216015_a(LootParameters.field_216289_i, itemStack).func_216023_a(this.field_70146_Z).func_186469_a((float)this.field_191518_aw + this.field_146042_b.func_184817_da());
            LootTable \u26032 = this.field_70170_p.func_73046_m().func_200249_aQ().func_186521_a(LootTables.field_186387_al);
            List<ItemStack> \u26033 = \u26032.func_216113_a(builder.func_216022_a(LootParameterSets.field_216262_c));
            CriteriaTriggers.field_204811_D.func_204820_a((ServerPlayerEntity)this.field_146042_b, itemStack, this, \u26033);
            for (ItemStack itemStack2 : \u26033) {
                ItemEntity itemEntity = new ItemEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), itemStack2);
                double \u26034 = this.field_146042_b.func_226277_ct_() - this.func_226277_ct_();
                double \u26035 = this.field_146042_b.func_226278_cu_() - this.func_226278_cu_();
                double \u26036 = this.field_146042_b.func_226281_cx_() - this.func_226281_cx_();
                double \u26037 = 0.1;
                itemEntity.func_213293_j(\u26034 * 0.1, \u26035 * 0.1 + Math.sqrt(Math.sqrt(\u26034 * \u26034 + \u26035 * \u26035 + \u26036 * \u26036)) * 0.08, \u26036 * 0.1);
                this.field_70170_p.func_217376_c(itemEntity);
                this.field_146042_b.field_70170_p.func_217376_c(new ExperienceOrbEntity(this.field_146042_b.field_70170_p, this.field_146042_b.func_226277_ct_(), this.field_146042_b.func_226278_cu_() + 0.5, this.field_146042_b.func_226281_cx_() + 0.5, this.field_70146_Z.nextInt(6) + 1));
                if (!itemStack2.func_77973_b().func_206844_a(ItemTags.field_206964_G)) continue;
                this.field_146042_b.func_195067_a(Stats.field_188071_E, 1);
            }
            n = 1;
        }
        if (this.field_146051_au) {
            n = 2;
        }
        this.func_70106_y();
        return n;
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 31 && this.field_70170_p.field_72995_K && this.field_146043_c instanceof PlayerEntity && ((PlayerEntity)this.field_146043_c).func_175144_cb()) {
            this.func_184527_k();
        }
        super.func_70103_a(by);
    }

    protected void func_184527_k() {
        if (this.field_146042_b == null) {
            return;
        }
        Vec3d vec3d = new Vec3d(this.field_146042_b.func_226277_ct_() - this.func_226277_ct_(), this.field_146042_b.func_226278_cu_() - this.func_226278_cu_(), this.field_146042_b.func_226281_cx_() - this.func_226281_cx_()).func_186678_a(0.1);
        this.field_146043_c.func_213317_d(this.field_146043_c.func_213322_ci().func_178787_e(vec3d));
    }

    @Override
    protected boolean func_225502_at_() {
        return false;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
        if (this.field_146042_b != null) {
            this.field_146042_b.field_71104_cf = null;
        }
    }

    @Nullable
    public PlayerEntity func_190619_l() {
        return this.field_146042_b;
    }

    @Override
    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public IPacket<?> func_213297_N() {
        PlayerEntity playerEntity = this.func_190619_l();
        return new SSpawnObjectPacket(this, playerEntity == null ? this.func_145782_y() : playerEntity.func_145782_y());
    }

    static enum State {
        FLYING,
        HOOKED_IN_ENTITY,
        BOBBING;

    }
}

