/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.fluid;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.StateContainer;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public abstract class LavaFluid
extends FlowingFluid {
    @Override
    public Fluid func_210197_e() {
        return Fluids.field_207213_d;
    }

    @Override
    public Fluid func_210198_f() {
        return Fluids.field_204547_b;
    }

    @Override
    public Item func_204524_b() {
        return Items.field_151129_at;
    }

    @Override
    public void func_204522_a(World world, BlockPos blockPos, IFluidState iFluidState, Random random2) {
        BlockPos blockPos2 = blockPos.func_177984_a();
        if (world.func_180495_p(blockPos2).func_196958_f() && !world.func_180495_p(blockPos2).func_200015_d(world, blockPos2)) {
            Random random2;
            if (random2.nextInt(100) == 0) {
                double d = (float)blockPos.func_177958_n() + random2.nextFloat();
                \u2603 = blockPos.func_177956_o() + 1;
                \u2603 = (float)blockPos.func_177952_p() + random2.nextFloat();
                world.func_195594_a(ParticleTypes.field_197595_F, d, \u2603, \u2603, 0.0, 0.0, 0.0);
                world.func_184134_a(d, \u2603, \u2603, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + random2.nextFloat() * 0.2f, 0.9f + random2.nextFloat() * 0.15f, false);
            }
            if (random2.nextInt(200) == 0) {
                world.func_184134_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + random2.nextFloat() * 0.2f, 0.9f + random2.nextFloat() * 0.15f, false);
            }
        }
    }

    @Override
    public void func_207186_b(World world, BlockPos blockPos, IFluidState iFluidState, Random random) {
        if (!world.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            return;
        }
        int n = random.nextInt(3);
        if (n > 0) {
            BlockPos blockPos2 = blockPos;
            for (int i = 0; i < n; ++i) {
                if (!world.func_195588_v(blockPos2 = blockPos2.func_177982_a(random.nextInt(3) - 1, 1, random.nextInt(3) - 1))) {
                    return;
                }
                BlockState blockState = world.func_180495_p(blockPos2);
                if (blockState.func_196958_f()) {
                    if (!this.func_176369_e(world, blockPos2)) continue;
                    world.func_175656_a(blockPos2, Blocks.field_150480_ab.func_176223_P());
                    return;
                }
                if (!blockState.func_185904_a().func_76230_c()) continue;
                return;
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos3 = blockPos.func_177982_a(random.nextInt(3) - 1, 0, random.nextInt(3) - 1);
                if (!world.func_195588_v(blockPos3)) {
                    return;
                }
                if (!world.func_175623_d(blockPos3.func_177984_a()) || !this.func_176368_m(world, blockPos3)) continue;
                world.func_175656_a(blockPos3.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
            }
        }
    }

    private boolean func_176369_e(IWorldReader iWorldReader, BlockPos blockPos) {
        for (Direction direction : Direction.values()) {
            if (!this.func_176368_m(iWorldReader, blockPos.func_177972_a(direction))) continue;
            return true;
        }
        return false;
    }

    private boolean func_176368_m(IWorldReader iWorldReader, BlockPos blockPos) {
        if (blockPos.func_177956_o() >= 0 && blockPos.func_177956_o() < 256 && !iWorldReader.func_175667_e(blockPos)) {
            return false;
        }
        return iWorldReader.func_180495_p(blockPos).func_185904_a().func_76217_h();
    }

    @Override
    @Nullable
    public IParticleData func_204521_c() {
        return ParticleTypes.field_197617_j;
    }

    @Override
    protected void func_205580_a(IWorld iWorld, BlockPos blockPos, BlockState blockState) {
        this.func_205581_a(iWorld, blockPos);
    }

    @Override
    public int func_185698_b(IWorldReader iWorldReader) {
        return iWorldReader.func_201675_m().func_177500_n() ? 4 : 2;
    }

    @Override
    public BlockState func_204527_a(IFluidState iFluidState) {
        return (BlockState)Blocks.field_150353_l.func_176223_P().func_206870_a(FlowingFluidBlock.field_176367_b, LavaFluid.func_207205_e(iFluidState));
    }

    @Override
    public boolean func_207187_a(Fluid fluid) {
        return fluid == Fluids.field_204547_b || fluid == Fluids.field_207213_d;
    }

    @Override
    public int func_204528_b(IWorldReader iWorldReader) {
        return iWorldReader.func_201675_m().func_177500_n() ? 1 : 2;
    }

    @Override
    public boolean func_215665_a(IFluidState iFluidState, IBlockReader iBlockReader, BlockPos blockPos, Fluid fluid, Direction direction) {
        return iFluidState.func_215679_a(iBlockReader, blockPos) >= 0.44444445f && fluid.func_207185_a(FluidTags.field_206959_a);
    }

    @Override
    public int func_205569_a(IWorldReader iWorldReader) {
        return iWorldReader.func_201675_m().func_177495_o() ? 10 : 30;
    }

    @Override
    public int func_215667_a(World world, BlockPos blockPos, IFluidState iFluidState, IFluidState iFluidState2) {
        int n = this.func_205569_a(world);
        if (!(iFluidState.func_206888_e() || iFluidState2.func_206888_e() || iFluidState.func_177229_b(field_207209_a).booleanValue() || iFluidState2.func_177229_b(field_207209_a).booleanValue() || !(iFluidState2.func_215679_a(world, blockPos) > iFluidState.func_215679_a(world, blockPos)) || world.func_201674_k().nextInt(4) == 0)) {
            n *= 4;
        }
        return n;
    }

    private void func_205581_a(IWorld iWorld, BlockPos blockPos) {
        iWorld.func_217379_c(1501, blockPos, 0);
    }

    @Override
    protected boolean func_205579_d() {
        return false;
    }

    @Override
    protected void func_205574_a(IWorld iWorld, BlockPos blockPos, BlockState blockState, Direction direction, IFluidState iFluidState) {
        if (direction == Direction.DOWN) {
            \u2603 = iWorld.func_204610_c(blockPos);
            if (this.func_207185_a(FluidTags.field_206960_b) && \u2603.func_206884_a(FluidTags.field_206959_a)) {
                if (blockState.func_177230_c() instanceof FlowingFluidBlock) {
                    iWorld.func_180501_a(blockPos, Blocks.field_150348_b.func_176223_P(), 3);
                }
                this.func_205581_a(iWorld, blockPos);
                return;
            }
        }
        super.func_205574_a(iWorld, blockPos, blockState, direction, iFluidState);
    }

    @Override
    protected boolean func_207196_h() {
        return true;
    }

    @Override
    protected float func_210195_d() {
        return 100.0f;
    }

    public static class Flowing
    extends LavaFluid {
        @Override
        protected void func_207184_a(StateContainer.Builder<Fluid, IFluidState> builder) {
            super.func_207184_a(builder);
            builder.func_206894_a(field_207210_b);
        }

        @Override
        public int func_207192_d(IFluidState iFluidState) {
            return iFluidState.func_177229_b(field_207210_b);
        }

        @Override
        public boolean func_207193_c(IFluidState iFluidState) {
            return false;
        }
    }

    public static class Source
    extends LavaFluid {
        @Override
        public int func_207192_d(IFluidState iFluidState) {
            return 8;
        }

        @Override
        public boolean func_207193_c(IFluidState iFluidState) {
            return true;
        }
    }
}

