/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.FireworkRocketEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FireworkStarItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class FireworkRocketItem
extends Item {
    public FireworkRocketItem(Item.Properties properties) {
        super(properties);
    }

    @Override
    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        World world = itemUseContext.func_195991_k();
        if (!world.field_72995_K) {
            ItemStack itemStack = itemUseContext.func_195996_i();
            Vec3d \u26032 = itemUseContext.func_221532_j();
            Direction \u26033 = itemUseContext.func_196000_l();
            FireworkRocketEntity \u26034 = new FireworkRocketEntity(world, \u26032.field_72450_a + (double)\u26033.func_82601_c() * 0.15, \u26032.field_72448_b + (double)\u26033.func_96559_d() * 0.15, \u26032.field_72449_c + (double)\u26033.func_82599_e() * 0.15, itemStack);
            world.func_217376_c(\u26034);
            itemStack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity2, Hand hand) {
        PlayerEntity playerEntity2;
        if (playerEntity2.func_184613_cA()) {
            ItemStack itemStack = playerEntity2.func_184586_b(hand);
            if (!world.field_72995_K) {
                world.func_217376_c(new FireworkRocketEntity(world, itemStack, playerEntity2));
                if (!playerEntity2.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
            return ActionResult.func_226248_a_(playerEntity2.func_184586_b(hand));
        }
        return ActionResult.func_226250_c_(playerEntity2.func_184586_b(hand));
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list2, ITooltipFlag iTooltipFlag) {
        CompoundNBT compoundNBT = itemStack.func_179543_a("Fireworks");
        if (compoundNBT == null) {
            return;
        }
        if (compoundNBT.func_150297_b("Flight", 99)) {
            list2.add(new TranslationTextComponent("item.minecraft.firework_rocket.flight", new Object[0]).func_150258_a(" ").func_150258_a(String.valueOf(compoundNBT.func_74771_c("Flight"))).func_211708_a(TextFormatting.GRAY));
        }
        if (!(\u2603 = compoundNBT.func_150295_c("Explosions", 10)).isEmpty()) {
            for (int i = 0; i < \u2603.size(); ++i) {
                List<ITextComponent> list2;
                CompoundNBT compoundNBT2 = \u2603.func_150305_b(i);
                ArrayList \u26032 = Lists.newArrayList();
                FireworkStarItem.func_195967_a(compoundNBT2, \u26032);
                if (\u26032.isEmpty()) continue;
                for (int j = 1; j < \u26032.size(); ++j) {
                    \u26032.set(j, new StringTextComponent("  ").func_150257_a((ITextComponent)\u26032.get(j)).func_211708_a(TextFormatting.GRAY));
                }
                list2.addAll(\u26032);
            }
        }
    }

    public static enum Shape {
        SMALL_BALL(0, "small_ball"),
        LARGE_BALL(1, "large_ball"),
        STAR(2, "star"),
        CREEPER(3, "creeper"),
        BURST(4, "burst");

        private static final Shape[] field_196077_f;
        private final int field_196078_g;
        private final String field_196079_h;

        private Shape(int n2, String string2) {
            this.field_196078_g = n2;
            this.field_196079_h = string2;
        }

        public int func_196071_a() {
            return this.field_196078_g;
        }

        public String func_196068_b() {
            return this.field_196079_h;
        }

        public static Shape func_196070_a(int n) {
            if (n < 0 || n >= field_196077_f.length) {
                return SMALL_BALL;
            }
            return field_196077_f[n];
        }

        static {
            field_196077_f = (Shape[])Arrays.stream(Shape.values()).sorted(Comparator.comparingInt(shape -> shape.field_196078_g)).toArray(Shape[]::new);
        }
    }
}

