/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Food;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Items;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class Item
implements IItemProvider {
    public static final Map<Block, Item> field_179220_a = Maps.newHashMap();
    private static final IItemPropertyGetter field_185046_b = (itemStack, world, livingEntity) -> itemStack.func_77951_h() ? 1.0f : 0.0f;
    private static final IItemPropertyGetter field_185047_c = (itemStack, world, livingEntity) -> MathHelper.func_76131_a((float)itemStack.func_77952_i() / (float)itemStack.func_77958_k(), 0.0f, 1.0f);
    private static final IItemPropertyGetter field_185048_d = (itemStack, world, livingEntity) -> livingEntity == null || livingEntity.func_184591_cq() == HandSide.RIGHT ? 0.0f : 1.0f;
    private static final IItemPropertyGetter field_185049_e = (itemStack, world, livingEntity) -> livingEntity instanceof PlayerEntity ? ((PlayerEntity)livingEntity).func_184811_cZ().func_185143_a(itemStack.func_77973_b(), 0.0f) : 0.0f;
    private static final IItemPropertyGetter field_219973_e = (itemStack, world, livingEntity) -> itemStack.func_77942_o() ? (float)itemStack.func_77978_p().func_74762_e("CustomModelData") : 0.0f;
    protected static final UUID field_111210_e = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID field_185050_h = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    protected static final Random field_77697_d = new Random();
    private final Map<ResourceLocation, IItemPropertyGetter> field_185051_m = Maps.newHashMap();
    protected final ItemGroup field_77701_a;
    private final Rarity field_208075_l;
    private final int field_77777_bU;
    private final int field_77699_b;
    private final Item field_77700_c;
    @Nullable
    private String field_77774_bZ;
    @Nullable
    private final Food field_219974_q;

    public static int func_150891_b(Item item) {
        return item == null ? 0 : Registry.field_212630_s.func_148757_b(item);
    }

    public static Item func_150899_d(int n) {
        return Registry.field_212630_s.func_148745_a(n);
    }

    @Deprecated
    public static Item func_150898_a(Block block) {
        return field_179220_a.getOrDefault(block, Items.field_190931_a);
    }

    public Item(Properties properties) {
        this.func_185043_a(new ResourceLocation("lefthanded"), field_185048_d);
        this.func_185043_a(new ResourceLocation("cooldown"), field_185049_e);
        this.func_185043_a(new ResourceLocation("custom_model_data"), field_219973_e);
        this.field_77701_a = properties.field_200923_d;
        this.field_208075_l = properties.field_208104_e;
        this.field_77700_c = properties.field_200922_c;
        this.field_77699_b = properties.field_200921_b;
        this.field_77777_bU = properties.field_200920_a;
        this.field_219974_q = properties.field_221541_f;
        if (this.field_77699_b > 0) {
            this.func_185043_a(new ResourceLocation("damaged"), field_185046_b);
            this.func_185043_a(new ResourceLocation("damage"), field_185047_c);
        }
    }

    public void func_219972_a(World world, LivingEntity livingEntity, ItemStack itemStack, int n) {
    }

    @Nullable
    public IItemPropertyGetter func_185045_a(ResourceLocation resourceLocation) {
        return this.field_185051_m.get(resourceLocation);
    }

    public boolean func_185040_i() {
        return !this.field_185051_m.isEmpty();
    }

    public boolean func_179215_a(CompoundNBT compoundNBT) {
        return false;
    }

    public boolean func_195938_a(BlockState blockState, World world, BlockPos blockPos, PlayerEntity playerEntity) {
        return true;
    }

    @Override
    public Item func_199767_j() {
        return this;
    }

    public final void func_185043_a(ResourceLocation resourceLocation, IItemPropertyGetter iItemPropertyGetter) {
        this.field_185051_m.put(resourceLocation, iItemPropertyGetter);
    }

    public ActionResultType func_195939_a(ItemUseContext itemUseContext) {
        return ActionResultType.PASS;
    }

    public float func_150893_a(ItemStack itemStack, BlockState blockState) {
        return 1.0f;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity playerEntity2, Hand hand) {
        PlayerEntity playerEntity2;
        if (this.func_219971_r()) {
            ItemStack itemStack = playerEntity2.func_184586_b(hand);
            if (playerEntity2.func_71043_e(this.func_219967_s().func_221468_d())) {
                playerEntity2.func_184598_c(hand);
                return ActionResult.func_226249_b_(itemStack);
            }
            return ActionResult.func_226251_d_(itemStack);
        }
        return ActionResult.func_226250_c_(playerEntity2.func_184586_b(hand));
    }

    public ItemStack func_77654_b(ItemStack itemStack, World world, LivingEntity livingEntity) {
        if (this.func_219971_r()) {
            return livingEntity.func_213357_a(world, itemStack);
        }
        return itemStack;
    }

    public final int func_77639_j() {
        return this.field_77777_bU;
    }

    public final int func_77612_l() {
        return this.field_77699_b;
    }

    public boolean func_77645_m() {
        return this.field_77699_b > 0;
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity livingEntity, LivingEntity livingEntity2) {
        return false;
    }

    public boolean func_179218_a(ItemStack itemStack, World world, BlockState blockState, BlockPos blockPos, LivingEntity livingEntity) {
        return false;
    }

    public boolean func_150897_b(BlockState blockState) {
        return false;
    }

    public boolean func_111207_a(ItemStack itemStack, PlayerEntity playerEntity, LivingEntity livingEntity, Hand hand) {
        return false;
    }

    public ITextComponent func_200296_o() {
        return new TranslationTextComponent(this.func_77658_a(), new Object[0]);
    }

    public String toString() {
        return Registry.field_212630_s.func_177774_c(this).func_110623_a();
    }

    protected String func_195935_o() {
        if (this.field_77774_bZ == null) {
            this.field_77774_bZ = Util.func_200697_a("item", Registry.field_212630_s.func_177774_c(this));
        }
        return this.field_77774_bZ;
    }

    public String func_77658_a() {
        return this.func_195935_o();
    }

    public String func_77667_c(ItemStack itemStack) {
        return this.func_77658_a();
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    public final Item func_77668_q() {
        return this.field_77700_c;
    }

    public boolean func_77634_r() {
        return this.field_77700_c != null;
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl) {
    }

    public void func_77622_d(ItemStack itemStack, World world, PlayerEntity playerEntity) {
    }

    public boolean func_77643_m_() {
        return false;
    }

    public UseAction func_77661_b(ItemStack itemStack) {
        return itemStack.func_77973_b().func_219971_r() ? UseAction.EAT : UseAction.NONE;
    }

    public int func_77626_a(ItemStack itemStack) {
        if (itemStack.func_77973_b().func_219971_r()) {
            return this.func_219967_s().func_221465_e() ? 16 : 32;
        }
        return 0;
    }

    public void func_77615_a(ItemStack itemStack, World world, LivingEntity livingEntity, int n) {
    }

    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag iTooltipFlag) {
    }

    public ITextComponent func_200295_i(ItemStack itemStack) {
        return new TranslationTextComponent(this.func_77667_c(itemStack), new Object[0]);
    }

    public boolean func_77636_d(ItemStack itemStack) {
        return itemStack.func_77948_v();
    }

    public Rarity func_77613_e(ItemStack itemStack) {
        if (!itemStack.func_77948_v()) {
            return this.field_208075_l;
        }
        switch (this.field_208075_l) {
            case COMMON: 
            case UNCOMMON: {
                return Rarity.RARE;
            }
            case RARE: {
                return Rarity.EPIC;
            }
        }
        return this.field_208075_l;
    }

    public boolean func_77616_k(ItemStack itemStack) {
        return this.func_77639_j() == 1 && this.func_77645_m();
    }

    protected static RayTraceResult func_219968_a(World world, PlayerEntity playerEntity, RayTraceContext.FluidMode fluidMode) {
        float f = playerEntity.field_70125_A;
        \u2603 = playerEntity.field_70177_z;
        Vec3d \u26032 = playerEntity.func_174824_e(1.0f);
        \u2603 = MathHelper.func_76134_b(-\u2603 * ((float)Math.PI / 180) - (float)Math.PI);
        \u2603 = MathHelper.func_76126_a(-\u2603 * ((float)Math.PI / 180) - (float)Math.PI);
        \u2603 = -MathHelper.func_76134_b(-f * ((float)Math.PI / 180));
        \u2603 = MathHelper.func_76126_a(-f * ((float)Math.PI / 180));
        \u2603 = \u2603 * \u2603;
        \u2603 = \u2603;
        \u2603 = \u2603 * \u2603;
        double \u26033 = 5.0;
        Vec3d \u26034 = \u26032.func_72441_c((double)\u2603 * 5.0, (double)\u2603 * 5.0, (double)\u2603 * 5.0);
        return world.func_217299_a(new RayTraceContext(\u26032, \u26034, RayTraceContext.BlockMode.OUTLINE, fluidMode, playerEntity));
    }

    public int func_77619_b() {
        return 0;
    }

    public void func_150895_a(ItemGroup itemGroup, NonNullList<ItemStack> nonNullList) {
        if (this.func_194125_a(itemGroup)) {
            nonNullList.add(new ItemStack(this));
        }
    }

    protected boolean func_194125_a(ItemGroup itemGroup) {
        \u2603 = this.func_77640_w();
        return \u2603 != null && (itemGroup == ItemGroup.field_78027_g || itemGroup == \u2603);
    }

    @Nullable
    public final ItemGroup func_77640_w() {
        return this.field_77701_a;
    }

    public boolean func_82789_a(ItemStack itemStack, ItemStack itemStack2) {
        return false;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EquipmentSlotType equipmentSlotType) {
        return HashMultimap.create();
    }

    public boolean func_219970_i(ItemStack itemStack) {
        return itemStack.func_77973_b() == Items.field_222114_py;
    }

    public ItemStack func_190903_i() {
        return new ItemStack(this);
    }

    public boolean func_206844_a(Tag<Item> tag) {
        return tag.func_199685_a_(this);
    }

    public boolean func_219971_r() {
        return this.field_219974_q != null;
    }

    @Nullable
    public Food func_219967_s() {
        return this.field_219974_q;
    }

    public SoundEvent func_225520_U__() {
        return SoundEvents.field_187664_bz;
    }

    public SoundEvent func_225519_S__() {
        return SoundEvents.field_187537_bA;
    }

    public static class Properties {
        private int field_200920_a = 64;
        private int field_200921_b;
        private Item field_200922_c;
        private ItemGroup field_200923_d;
        private Rarity field_208104_e = Rarity.COMMON;
        private Food field_221541_f;

        public Properties func_221540_a(Food food) {
            this.field_221541_f = food;
            return this;
        }

        public Properties func_200917_a(int n) {
            if (this.field_200921_b > 0) {
                throw new RuntimeException("Unable to have damage AND stack.");
            }
            this.field_200920_a = n;
            return this;
        }

        public Properties func_200915_b(int n) {
            return this.field_200921_b == 0 ? this.func_200918_c(n) : this;
        }

        public Properties func_200918_c(int n) {
            this.field_200921_b = n;
            this.field_200920_a = 1;
            return this;
        }

        public Properties func_200919_a(Item item) {
            this.field_200922_c = item;
            return this;
        }

        public Properties func_200916_a(ItemGroup itemGroup) {
            this.field_200923_d = itemGroup;
            return this;
        }

        public Properties func_208103_a(Rarity rarity) {
            this.field_208104_e = rarity;
            return this;
        }
    }
}

