/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.network.handshake.ClientHandshakeNetHandler;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.network.LegacyPingHandler;
import net.minecraft.network.NettyPacketDecoder;
import net.minecraft.network.NettyPacketEncoder;
import net.minecraft.network.NettyVarint21FrameDecoder;
import net.minecraft.network.NettyVarint21FrameEncoder;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketDirection;
import net.minecraft.network.handshake.ServerHandshakeNetHandler;
import net.minecraft.network.play.server.SDisconnectPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NetworkSystem {
    private static final Logger field_151275_b = LogManager.getLogger();
    public static final LazyValue<NioEventLoopGroup> field_151276_c = new LazyValue<NioEventLoopGroup>(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Server IO #%d").setDaemon(true).build()));
    public static final LazyValue<EpollEventLoopGroup> field_181141_b = new LazyValue<EpollEventLoopGroup>(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Server IO #%d").setDaemon(true).build()));
    private final MinecraftServer field_151273_d;
    public volatile boolean field_151277_a;
    private final List<ChannelFuture> field_151274_e = Collections.synchronizedList(Lists.newArrayList());
    private final List<NetworkManager> field_151272_f = Collections.synchronizedList(Lists.newArrayList());

    public NetworkSystem(MinecraftServer minecraftServer) {
        this.field_151273_d = minecraftServer;
        this.field_151277_a = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_151265_a(@Nullable InetAddress inetAddress, int n) throws IOException {
        List<ChannelFuture> list = this.field_151274_e;
        synchronized (list) {
            LazyValue<NioEventLoopGroup> \u26032;
            if (Epoll.isAvailable() && this.field_151273_d.func_181035_ah()) {
                Class<NioServerSocketChannel> clazz = EpollServerSocketChannel.class;
                \u26032 = field_181141_b;
                field_151275_b.info("Using epoll channel type");
            } else {
                clazz = NioServerSocketChannel.class;
                \u26032 = field_151276_c;
                field_151275_b.info("Using default channel type");
            }
            this.field_151274_e.add(((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(clazz)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) throws Exception {
                    try {
                        channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                    }
                    catch (ChannelException channelException) {
                        // empty catch block
                    }
                    channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30)).addLast("legacy_query", (ChannelHandler)new LegacyPingHandler(NetworkSystem.this)).addLast("splitter", (ChannelHandler)new NettyVarint21FrameDecoder()).addLast("decoder", (ChannelHandler)new NettyPacketDecoder(PacketDirection.SERVERBOUND)).addLast("prepender", (ChannelHandler)new NettyVarint21FrameEncoder()).addLast("encoder", (ChannelHandler)new NettyPacketEncoder(PacketDirection.CLIENTBOUND));
                    NetworkManager networkManager = new NetworkManager(PacketDirection.SERVERBOUND);
                    NetworkSystem.this.field_151272_f.add(networkManager);
                    channel.pipeline().addLast("packet_handler", (ChannelHandler)networkManager);
                    networkManager.func_150719_a(new ServerHandshakeNetHandler(NetworkSystem.this.field_151273_d, networkManager));
                }
            }).group((EventLoopGroup)\u26032.func_179281_c()).localAddress(inetAddress, n)).bind().syncUninterruptibly());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SocketAddress func_151270_a() {
        ChannelFuture channelFuture;
        List<ChannelFuture> list = this.field_151274_e;
        synchronized (list) {
            channelFuture = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel channel) throws Exception {
                    NetworkManager networkManager = new NetworkManager(PacketDirection.SERVERBOUND);
                    networkManager.func_150719_a(new ClientHandshakeNetHandler(NetworkSystem.this.field_151273_d, networkManager));
                    NetworkSystem.this.field_151272_f.add(networkManager);
                    channel.pipeline().addLast("packet_handler", (ChannelHandler)networkManager);
                }
            }).group((EventLoopGroup)field_151276_c.func_179281_c()).localAddress((SocketAddress)LocalAddress.ANY)).bind().syncUninterruptibly();
            this.field_151274_e.add(channelFuture);
        }
        return channelFuture.channel().localAddress();
    }

    public void func_151268_b() {
        this.field_151277_a = false;
        for (ChannelFuture channelFuture : this.field_151274_e) {
            try {
                channelFuture.channel().close().sync();
            }
            catch (InterruptedException interruptedException) {
                field_151275_b.error("Interrupted whilst closing channel");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_151269_c() {
        List<NetworkManager> list = this.field_151272_f;
        synchronized (list) {
            Iterator<NetworkManager> iterator = this.field_151272_f.iterator();
            while (iterator.hasNext()) {
                NetworkManager networkManager = iterator.next();
                if (networkManager.func_179291_h()) continue;
                if (networkManager.func_150724_d()) {
                    try {
                        networkManager.func_74428_b();
                    }
                    catch (Exception exception) {
                        if (networkManager.func_150731_c()) {
                            Object object = CrashReport.func_85055_a(exception, "Ticking memory connection");
                            CrashReportCategory \u26032 = ((CrashReport)object).func_85058_a("Ticking connection");
                            \u26032.func_189529_a("Connection", () -> networkManager.toString());
                            throw new ReportedException((CrashReport)object);
                        }
                        field_151275_b.warn("Failed to handle packet for {}", (Object)networkManager.func_74430_c(), (Object)exception);
                        object = new StringTextComponent("Internal server error");
                        networkManager.func_201058_a(new SDisconnectPacket((ITextComponent)object), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)arg_0 -> NetworkSystem.func_210474_a(networkManager, (ITextComponent)object, arg_0)));
                        networkManager.func_150721_g();
                    }
                    continue;
                }
                iterator.remove();
                networkManager.func_179293_l();
            }
        }
    }

    public MinecraftServer func_151267_d() {
        return this.field_151273_d;
    }

    private static /* synthetic */ void func_210474_a(NetworkManager networkManager, ITextComponent iTextComponent, Future future) throws Exception {
        networkManager.func_150718_a(iTextComponent);
    }
}

