/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.play.server;

import com.google.common.collect.Maps;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.network.play.IClientPlayNetHandler;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ArgumentTypes;
import net.minecraft.command.arguments.SuggestionProviders;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;

public class SCommandListPacket
implements IPacket<IClientPlayNetHandler> {
    private RootCommandNode<ISuggestionProvider> field_197697_a;

    public SCommandListPacket() {
    }

    public SCommandListPacket(RootCommandNode<ISuggestionProvider> rootCommandNode) {
        this.field_197697_a = rootCommandNode;
    }

    @Override
    public void func_148837_a(PacketBuffer packetBuffer) throws IOException {
        int \u26034;
        Entry[] entryArray = new Entry[packetBuffer.func_150792_a()];
        ArrayDeque<Entry> \u26032 = new ArrayDeque<Entry>(entryArray.length);
        for (\u26034 = 0; \u26034 < entryArray.length; ++\u26034) {
            entryArray[\u26034] = this.func_197692_c(packetBuffer);
            \u26032.add(entryArray[\u26034]);
        }
        while (!\u26032.isEmpty()) {
            \u26034 = 0;
            Iterator \u26033 = \u26032.iterator();
            while (\u26033.hasNext()) {
                Entry entry = (Entry)\u26033.next();
                if (!entry.func_197723_a(entryArray)) continue;
                \u26033.remove();
                \u26034 = 1;
            }
            if (\u26034 != 0) continue;
            throw new IllegalStateException("Server sent an impossible command tree");
        }
        this.field_197697_a = (RootCommandNode)entryArray[packetBuffer.func_150792_a()].field_197730_e;
    }

    @Override
    public void func_148840_b(PacketBuffer packetBuffer) throws IOException {
        HashMap hashMap = Maps.newHashMap();
        ArrayDeque<Object> \u26032 = new ArrayDeque<Object>();
        \u26032.add(this.field_197697_a);
        while (!\u26032.isEmpty()) {
            CommandNode[] commandNodeArray = (CommandNode[])\u26032.pollFirst();
            if (hashMap.containsKey(commandNodeArray)) continue;
            int \u26033 = hashMap.size();
            hashMap.put(commandNodeArray, \u26033);
            \u26032.addAll(commandNodeArray.getChildren());
            if (commandNodeArray.getRedirect() == null) continue;
            \u26032.add(commandNodeArray.getRedirect());
        }
        commandNodeArray = new CommandNode[hashMap.size()];
        for (Map.Entry \u26034 : hashMap.entrySet()) {
            commandNodeArray[((Integer)\u26034.getValue()).intValue()] = (CommandNode)\u26034.getKey();
        }
        packetBuffer.func_150787_b(commandNodeArray.length);
        for (CommandNode \u26035 : commandNodeArray) {
            this.func_197696_a(packetBuffer, (CommandNode<ISuggestionProvider>)\u26035, hashMap);
        }
        packetBuffer.func_150787_b((Integer)hashMap.get(this.field_197697_a));
    }

    private Entry func_197692_c(PacketBuffer packetBuffer) {
        byte by = packetBuffer.readByte();
        int[] \u26032 = packetBuffer.func_186863_b();
        int \u26033 = (by & 8) != 0 ? packetBuffer.func_150792_a() : 0;
        ArgumentBuilder<ISuggestionProvider, ?> \u26034 = this.func_197695_a(packetBuffer, by);
        return new Entry(\u26034, by, \u26033, \u26032);
    }

    @Nullable
    private ArgumentBuilder<ISuggestionProvider, ?> func_197695_a(PacketBuffer packetBuffer, byte by) {
        int n = by & 3;
        if (n == 2) {
            String string = packetBuffer.func_150789_c(Short.MAX_VALUE);
            ArgumentType<?> \u26032 = ArgumentTypes.func_197486_a(packetBuffer);
            if (\u26032 == null) {
                return null;
            }
            RequiredArgumentBuilder \u26033 = RequiredArgumentBuilder.argument((String)string, \u26032);
            if ((by & 0x10) != 0) {
                \u26033.suggests(SuggestionProviders.func_197498_a(packetBuffer.func_192575_l()));
            }
            return \u26033;
        }
        if (n == 1) {
            return LiteralArgumentBuilder.literal((String)packetBuffer.func_150789_c(Short.MAX_VALUE));
        }
        return null;
    }

    private void func_197696_a(PacketBuffer packetBuffer, CommandNode<ISuggestionProvider> commandNode2, Map<CommandNode<ISuggestionProvider>, Integer> map) {
        CommandNode<ISuggestionProvider> commandNode2;
        int n = 0;
        if (commandNode2.getRedirect() != null) {
            n = (byte)(n | 8);
        }
        if (commandNode2.getCommand() != null) {
            n = (byte)(n | 4);
        }
        if (commandNode2 instanceof RootCommandNode) {
            n = (byte)(n | 0);
        } else if (commandNode2 instanceof ArgumentCommandNode) {
            n = (byte)(n | 2);
            if (((ArgumentCommandNode)commandNode2).getCustomSuggestions() != null) {
                n = (byte)(n | 0x10);
            }
        } else if (commandNode2 instanceof LiteralCommandNode) {
            n = (byte)(n | 1);
        } else {
            throw new UnsupportedOperationException("Unknown node type " + commandNode2);
        }
        packetBuffer.writeByte(n);
        packetBuffer.func_150787_b(commandNode2.getChildren().size());
        for (CommandNode commandNode3 : commandNode2.getChildren()) {
            packetBuffer.func_150787_b(map.get(commandNode3));
        }
        if (commandNode2.getRedirect() != null) {
            packetBuffer.func_150787_b(map.get(commandNode2.getRedirect()));
        }
        if (commandNode2 instanceof ArgumentCommandNode) {
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)commandNode2;
            packetBuffer.func_180714_a(argumentCommandNode.getName());
            ArgumentTypes.func_197484_a(packetBuffer, argumentCommandNode.getType());
            if (argumentCommandNode.getCustomSuggestions() != null) {
                packetBuffer.func_192572_a(SuggestionProviders.func_197497_a((SuggestionProvider<ISuggestionProvider>)argumentCommandNode.getCustomSuggestions()));
            }
        } else if (commandNode2 instanceof LiteralCommandNode) {
            packetBuffer.func_180714_a(((LiteralCommandNode)commandNode2).getLiteral());
        }
    }

    @Override
    public void func_148833_a(IClientPlayNetHandler iClientPlayNetHandler) {
        iClientPlayNetHandler.func_195511_a(this);
    }

    public RootCommandNode<ISuggestionProvider> func_197693_a() {
        return this.field_197697_a;
    }

    static class Entry {
        @Nullable
        private final ArgumentBuilder<ISuggestionProvider, ?> field_197726_a;
        private final byte field_197727_b;
        private final int field_197728_c;
        private final int[] field_197729_d;
        private CommandNode<ISuggestionProvider> field_197730_e;

        private Entry(@Nullable ArgumentBuilder<ISuggestionProvider, ?> argumentBuilder, byte by, int n, int[] nArray) {
            this.field_197726_a = argumentBuilder;
            this.field_197727_b = by;
            this.field_197728_c = n;
            this.field_197729_d = nArray;
        }

        public boolean func_197723_a(Entry[] entryArray) {
            if (this.field_197730_e == null) {
                if (this.field_197726_a == null) {
                    this.field_197730_e = new RootCommandNode();
                } else {
                    if ((this.field_197727_b & 8) != 0) {
                        if (entryArray[this.field_197728_c].field_197730_e == null) {
                            return false;
                        }
                        this.field_197726_a.redirect(entryArray[this.field_197728_c].field_197730_e);
                    }
                    if ((this.field_197727_b & 4) != 0) {
                        this.field_197726_a.executes(commandContext -> 0);
                    }
                    this.field_197730_e = this.field_197726_a.build();
                }
            }
            for (int n : this.field_197729_d) {
                if (entryArray[n].field_197730_e != null) continue;
                return false;
            }
            for (int n : this.field_197729_d) {
                CommandNode<ISuggestionProvider> commandNode = entryArray[n].field_197730_e;
                if (commandNode instanceof RootCommandNode) continue;
                this.field_197730_e.addChild(commandNode);
            }
            return true;
        }
    }
}

