/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.MoreExecutors;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.Dynamic;
import it.unimi.dsi.fastutil.Hash;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.crash.ReportedException;
import net.minecraft.state.IProperty;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Bootstrap;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Util {
    private static final AtomicInteger field_215090_b = new AtomicInteger(1);
    private static final ExecutorService field_215091_c = Util.func_215078_k();
    public static LongSupplier field_211180_a = System::nanoTime;
    private static final Logger field_195650_a = LogManager.getLogger();

    public static <K, V> Collector<Map.Entry<? extends K, ? extends V>, ?, Map<K, V>> func_199749_a() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    public static <T extends Comparable<T>> String func_200269_a(IProperty<T> iProperty, Object object) {
        return iProperty.func_177702_a((Comparable)object);
    }

    public static String func_200697_a(String string, @Nullable ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            return string + ".unregistered_sadface";
        }
        return string + '.' + resourceLocation.func_110624_b() + '.' + resourceLocation.func_110623_a().replace('/', '.');
    }

    public static long func_211177_b() {
        return Util.func_211178_c() / 1000000L;
    }

    public static long func_211178_c() {
        return field_211180_a.getAsLong();
    }

    public static long func_211179_d() {
        return Instant.now().toEpochMilli();
    }

    private static ExecutorService func_215078_k() {
        int n = MathHelper.func_76125_a(Runtime.getRuntime().availableProcessors() - 1, 1, 7);
        Object \u26032 = n <= 0 ? MoreExecutors.newDirectExecutorService() : new ForkJoinPool(n, forkJoinPool -> {
            ForkJoinWorkerThread forkJoinWorkerThread = new ForkJoinWorkerThread(forkJoinPool){

                @Override
                protected void onTermination(Throwable throwable) {
                    if (throwable != null) {
                        field_195650_a.warn("{} died", (Object)this.getName(), (Object)throwable);
                    } else {
                        field_195650_a.debug("{} shutdown", (Object)this.getName());
                    }
                    super.onTermination(throwable);
                }
            };
            forkJoinWorkerThread.setName("Server-Worker-" + field_215090_b.getAndIncrement());
            return forkJoinWorkerThread;
        }, (thread, throwable) -> {
            Util.func_229757_c_(throwable);
            if (throwable instanceof CompletionException) {
                throwable = throwable.getCause();
            }
            if (throwable instanceof ReportedException) {
                Bootstrap.func_179870_a(((ReportedException)throwable).func_71575_a().func_71502_e());
                System.exit(-1);
            }
            field_195650_a.error(String.format("Caught exception in thread %s", thread), throwable);
        }, true);
        return \u26032;
    }

    public static Executor func_215072_e() {
        return field_215091_c;
    }

    public static void func_215082_f() {
        boolean bl;
        field_215091_c.shutdown();
        try {
            bl = field_215091_c.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        if (!bl) {
            field_215091_c.shutdownNow();
        }
    }

    public static <T> CompletableFuture<T> func_215087_a(Throwable throwable) {
        CompletableFuture completableFuture = new CompletableFuture();
        completableFuture.completeExceptionally(throwable);
        return completableFuture;
    }

    public static void func_229756_b_(Throwable throwable) {
        throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
    }

    public static OS func_110647_a() {
        String string = System.getProperty("os.name").toLowerCase(Locale.ROOT);
        if (string.contains("win")) {
            return OS.WINDOWS;
        }
        if (string.contains("mac")) {
            return OS.OSX;
        }
        if (string.contains("solaris")) {
            return OS.SOLARIS;
        }
        if (string.contains("sunos")) {
            return OS.SOLARIS;
        }
        if (string.contains("linux")) {
            return OS.LINUX;
        }
        if (string.contains("unix")) {
            return OS.LINUX;
        }
        return OS.UNKNOWN;
    }

    public static Stream<String> func_211565_f() {
        RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        return runtimeMXBean.getInputArguments().stream().filter(string -> string.startsWith("-X"));
    }

    public static <T> T func_223378_a(List<T> list) {
        return list.get(list.size() - 1);
    }

    public static <T> T func_195647_a(Iterable<T> iterable, @Nullable T t) {
        Iterator<T> iterator = iterable.iterator();
        T \u26032 = iterator.next();
        if (t != null) {
            T t2 = \u26032;
            while (true) {
                if (t2 == t) {
                    if (!iterator.hasNext()) break;
                    return iterator.next();
                }
                if (!iterator.hasNext()) continue;
                t2 = iterator.next();
            }
        }
        return \u26032;
    }

    public static <T> T func_195648_b(Iterable<T> iterable, @Nullable T t) {
        Iterator<T> iterator = iterable.iterator();
        T \u26032 = null;
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (t2 == t) {
                if (\u26032 != null) break;
                \u26032 = (T)(iterator.hasNext() ? Iterators.getLast(iterator) : t);
                break;
            }
            \u26032 = t2;
        }
        return \u26032;
    }

    public static <T> T func_199748_a(Supplier<T> supplier) {
        return supplier.get();
    }

    public static <T> T func_200696_a(T t, Consumer<T> consumer) {
        consumer.accept(t);
        return t;
    }

    public static <K> Hash.Strategy<K> func_212443_g() {
        return IdentityStrategy.INSTANCE;
    }

    public static <V> CompletableFuture<List<V>> func_215079_b(List<? extends CompletableFuture<? extends V>> list) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)list.size());
        CompletableFuture[] \u26032 = new CompletableFuture[list.size()];
        CompletableFuture \u26033 = new CompletableFuture();
        list.forEach(completableFuture2 -> {
            int n = arrayList.size();
            arrayList.add(null);
            completableFutureArray[n] = completableFuture2.whenComplete((object, throwable) -> {
                if (throwable != null) {
                    \u26033.completeExceptionally((Throwable)throwable);
                } else {
                    arrayList.set(n, object);
                }
            });
        });
        return CompletableFuture.allOf(\u26032).applyToEither((CompletionStage)\u26033, void_ -> arrayList);
    }

    public static <T> Stream<T> func_215081_a(Optional<? extends T> optional) {
        return (Stream)DataFixUtils.orElseGet(optional.map(Stream::of), Stream::empty);
    }

    public static <T> Optional<T> func_215077_a(Optional<T> optional, Consumer<T> consumer, Runnable runnable) {
        if (optional.isPresent()) {
            consumer.accept(optional.get());
        } else {
            runnable.run();
        }
        return optional;
    }

    public static Runnable func_215075_a(Runnable runnable, Supplier<String> supplier) {
        return runnable;
    }

    public static Optional<UUID> func_215074_a(String string, Dynamic<?> dynamic) {
        return dynamic.get(string + "Most").asNumber().flatMap(number -> dynamic.get(string + "Least").asNumber().map(number2 -> new UUID(number.longValue(), number2.longValue())));
    }

    public static <T> Dynamic<T> func_215084_a(String string, UUID uUID, Dynamic<T> dynamic) {
        return dynamic.set(string + "Most", dynamic.createLong(uUID.getMostSignificantBits())).set(string + "Least", dynamic.createLong(uUID.getLeastSignificantBits()));
    }

    public static <T extends Throwable> T func_229757_c_(T t2) {
        T t2;
        if (SharedConstants.field_206244_b) {
            field_195650_a.error("Trying to throw a fatal exception, pausing in IDE", t2);
            try {
                while (true) {
                    Thread.sleep(1000L);
                    field_195650_a.error("paused");
                }
            }
            catch (InterruptedException interruptedException) {
                return t2;
            }
        }
        return t2;
    }

    public static String func_229758_d_(Throwable throwable) {
        if (throwable.getCause() != null) {
            return Util.func_229758_d_(throwable.getCause());
        }
        if (throwable.getMessage() != null) {
            return throwable.getMessage();
        }
        return throwable.toString();
    }

    static enum IdentityStrategy implements Hash.Strategy<Object>
    {
        INSTANCE;


        public int hashCode(Object object) {
            return System.identityHashCode(object);
        }

        public boolean equals(Object object, Object object2) {
            return object == object2;
        }
    }

    public static enum OS {
        LINUX,
        SOLARIS,
        WINDOWS{

            @Override
            protected String[] func_195643_b(URL uRL) {
                return new String[]{"rundll32", "url.dll,FileProtocolHandler", uRL.toString()};
            }
        }
        ,
        OSX{

            @Override
            protected String[] func_195643_b(URL uRL) {
                return new String[]{"open", uRL.toString()};
            }
        }
        ,
        UNKNOWN;


        public void func_195639_a(URL uRL) {
            try {
                Process process = AccessController.doPrivileged(() -> Runtime.getRuntime().exec(this.func_195643_b(uRL)));
                for (String string : IOUtils.readLines((InputStream)process.getErrorStream())) {
                    field_195650_a.error(string);
                }
                process.getInputStream().close();
                process.getErrorStream().close();
                process.getOutputStream().close();
            }
            catch (IOException | PrivilegedActionException exception) {
                field_195650_a.error("Couldn't open url '{}'", (Object)uRL, (Object)exception);
            }
        }

        public void func_195642_a(URI uRI) {
            try {
                this.func_195639_a(uRI.toURL());
            }
            catch (MalformedURLException malformedURLException) {
                field_195650_a.error("Couldn't open uri '{}'", (Object)uRI, (Object)malformedURLException);
            }
        }

        public void func_195641_a(File file) {
            try {
                this.func_195639_a(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                field_195650_a.error("Couldn't open file '{}'", (Object)file, (Object)malformedURLException);
            }
        }

        protected String[] func_195643_b(URL uRL) {
            String string = uRL.toString();
            if ("file".equals(uRL.getProtocol())) {
                string = string.replace("file:", "file://");
            }
            return new String[]{"xdg-open", string};
        }

        public void func_195640_a(String string) {
            try {
                this.func_195639_a(new URI(string).toURL());
            }
            catch (IllegalArgumentException | MalformedURLException | URISyntaxException exception) {
                field_195650_a.error("Couldn't open uri '{}'", (Object)string, (Object)exception);
            }
        }
    }
}

