/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.palette;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.BitArray;
import net.minecraft.util.ObjectIntIdentityMap;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.IPalette;
import net.minecraft.util.palette.IResizeCallback;
import net.minecraft.util.palette.PaletteArray;
import net.minecraft.util.palette.PaletteHashMap;

public class PalettedContainer<T>
implements IResizeCallback<T> {
    private final IPalette<T> field_205521_b;
    private final IResizeCallback<T> field_205522_c = (n, object) -> 0;
    private final ObjectIntIdentityMap<T> field_205523_d;
    private final Function<CompoundNBT, T> field_205524_e;
    private final Function<T, CompoundNBT> field_205525_f;
    private final T field_205526_g;
    protected BitArray field_186021_b;
    private IPalette<T> field_186022_c;
    private int field_186024_e;
    private final ReentrantLock field_210461_j = new ReentrantLock();

    public void func_210459_b() {
        if (this.field_210461_j.isLocked() && !this.field_210461_j.isHeldByCurrentThread()) {
            String string = Thread.getAllStackTraces().keySet().stream().filter(Objects::nonNull).map(thread -> thread.getName() + ": \n\tat " + Arrays.stream(thread.getStackTrace()).map(Object::toString).collect(Collectors.joining("\n\tat "))).collect(Collectors.joining("\n"));
            CrashReport \u26032 = new CrashReport("Writing into PalettedContainer from multiple threads", new IllegalStateException());
            CrashReportCategory \u26033 = \u26032.func_85058_a("Thread dumps");
            \u26033.func_71507_a("Thread dumps", string);
            throw new ReportedException(\u26032);
        }
        this.field_210461_j.lock();
    }

    public void func_210460_c() {
        this.field_210461_j.unlock();
    }

    public PalettedContainer(IPalette<T> iPalette, ObjectIntIdentityMap<T> objectIntIdentityMap, Function<CompoundNBT, T> function, Function<T, CompoundNBT> function2, T t) {
        this.field_205521_b = iPalette;
        this.field_205523_d = objectIntIdentityMap;
        this.field_205524_e = function;
        this.field_205525_f = function2;
        this.field_205526_g = t;
        this.func_186012_b(4);
    }

    private static int func_186011_b(int n, int n2, int n3) {
        return n2 << 8 | n3 << 4 | n;
    }

    private void func_186012_b(int n) {
        if (n == this.field_186024_e) {
            return;
        }
        this.field_186024_e = n;
        if (this.field_186024_e <= 4) {
            this.field_186024_e = 4;
            this.field_186022_c = new PaletteArray<T>(this.field_205523_d, this.field_186024_e, this, this.field_205524_e);
        } else if (this.field_186024_e < 9) {
            this.field_186022_c = new PaletteHashMap<T>(this.field_205523_d, this.field_186024_e, this, this.field_205524_e, this.field_205525_f);
        } else {
            this.field_186022_c = this.field_205521_b;
            this.field_186024_e = MathHelper.func_151241_e(this.field_205523_d.func_186804_a());
        }
        this.field_186022_c.func_186041_a(this.field_205526_g);
        this.field_186021_b = new BitArray(this.field_186024_e, 4096);
    }

    @Override
    public int onResize(int n, T t2) {
        T t2;
        int \u26033;
        this.func_210459_b();
        BitArray bitArray = this.field_186021_b;
        IPalette<T> \u26032 = this.field_186022_c;
        this.func_186012_b(n);
        for (\u26033 = 0; \u26033 < bitArray.func_188144_b(); ++\u26033) {
            T t3 = \u26032.func_186039_a(bitArray.func_188142_a(\u26033));
            if (t3 == null) continue;
            this.func_186014_b(\u26033, t3);
        }
        \u26033 = this.field_186022_c.func_186041_a(t2);
        this.func_210460_c();
        return \u26033;
    }

    public T func_222641_a(int n, int n2, int n3, T t) {
        this.func_210459_b();
        \u2603 = this.func_222643_a(PalettedContainer.func_186011_b(n, n2, n3), t);
        this.func_210460_c();
        return \u2603;
    }

    public T func_222639_b(int n, int n2, int n3, T t) {
        return this.func_222643_a(PalettedContainer.func_186011_b(n, n2, n3), t);
    }

    protected T func_222643_a(int n, T t) {
        int n2 = this.field_186022_c.func_186041_a(t);
        \u2603 = this.field_186021_b.func_219789_a(n, n2);
        T \u26032 = this.field_186022_c.func_186039_a(\u2603);
        return \u26032 == null ? this.field_205526_g : \u26032;
    }

    protected void func_186014_b(int n, T t) {
        int n2 = this.field_186022_c.func_186041_a(t);
        this.field_186021_b.func_188141_a(n, n2);
    }

    public T func_186016_a(int n, int n2, int n3) {
        return this.func_186015_a(PalettedContainer.func_186011_b(n, n2, n3));
    }

    protected T func_186015_a(int n) {
        T t = this.field_186022_c.func_186039_a(this.field_186021_b.func_188142_a(n));
        return t == null ? this.field_205526_g : t;
    }

    public void func_186010_a(PacketBuffer packetBuffer) {
        this.func_210459_b();
        byte by = packetBuffer.readByte();
        if (this.field_186024_e != by) {
            this.func_186012_b(by);
        }
        this.field_186022_c.func_186038_a(packetBuffer);
        packetBuffer.func_186873_b(this.field_186021_b.func_188143_a());
        this.func_210460_c();
    }

    public void func_186009_b(PacketBuffer packetBuffer) {
        this.func_210459_b();
        packetBuffer.writeByte(this.field_186024_e);
        this.field_186022_c.func_186037_b(packetBuffer);
        packetBuffer.func_186865_a(this.field_186021_b.func_188143_a());
        this.func_210460_c();
    }

    public void func_222642_a(ListNBT listNBT, long[] lArray) {
        int n;
        this.func_210459_b();
        int n2 = Math.max(4, MathHelper.func_151241_e(listNBT.size()));
        if (n2 != this.field_186024_e) {
            this.func_186012_b(n2);
        }
        this.field_186022_c.func_196968_a(listNBT);
        n = lArray.length * 64 / 4096;
        if (this.field_186022_c == this.field_205521_b) {
            PaletteHashMap<T> paletteHashMap = new PaletteHashMap<T>(this.field_205523_d, n2, this.field_205522_c, this.field_205524_e, this.field_205525_f);
            paletteHashMap.func_196968_a(listNBT);
            BitArray \u26032 = new BitArray(n2, 4096, lArray);
            for (int i = 0; i < 4096; ++i) {
                this.field_186021_b.func_188141_a(i, this.field_205521_b.func_186041_a(paletteHashMap.func_186039_a(\u26032.func_188142_a(i))));
            }
        } else if (n == this.field_186024_e) {
            System.arraycopy(lArray, 0, this.field_186021_b.func_188143_a(), 0, lArray.length);
        } else {
            BitArray bitArray = new BitArray(n, 4096, lArray);
            for (int i = 0; i < 4096; ++i) {
                this.field_186021_b.func_188141_a(i, bitArray.func_188142_a(i));
            }
        }
        this.func_210460_c();
    }

    public void func_196963_b(CompoundNBT compoundNBT2, String string, String string2) {
        CompoundNBT compoundNBT2;
        this.func_210459_b();
        PaletteHashMap<T> paletteHashMap = new PaletteHashMap<T>(this.field_205523_d, this.field_186024_e, this.field_205522_c, this.field_205524_e, this.field_205525_f);
        T \u26032 = this.field_205526_g;
        int \u26033 = paletteHashMap.func_186041_a(this.field_205526_g);
        int[] \u26034 = new int[4096];
        for (int i = 0; i < 4096; ++i) {
            T t = this.func_186015_a(i);
            if (t != \u26032) {
                \u26032 = t;
                \u26033 = paletteHashMap.func_186041_a(t);
            }
            \u26034[i] = \u26033;
        }
        ListNBT listNBT = new ListNBT();
        paletteHashMap.func_196969_b(listNBT);
        compoundNBT2.func_218657_a(string, listNBT);
        int \u26035 = Math.max(4, MathHelper.func_151241_e(listNBT.size()));
        BitArray \u26036 = new BitArray(\u26035, 4096);
        for (int i = 0; i < \u26034.length; ++i) {
            \u26036.func_188141_a(i, \u26034[i]);
        }
        compoundNBT2.func_197644_a(string2, \u26036.func_188143_a());
        this.func_210460_c();
    }

    public int func_186018_a() {
        return 1 + this.field_186022_c.func_186040_a() + PacketBuffer.func_150790_a(this.field_186021_b.func_188144_b()) + this.field_186021_b.func_188143_a().length * 8;
    }

    public boolean func_222640_a(T t) {
        return this.field_186022_c.func_222626_b(t);
    }

    public void func_225497_a(ICountConsumer<T> iCountConsumer) {
        Int2IntOpenHashMap int2IntOpenHashMap = new Int2IntOpenHashMap();
        this.field_186021_b.func_225421_a(arg_0 -> PalettedContainer.func_225498_a((Int2IntMap)int2IntOpenHashMap, arg_0));
        int2IntOpenHashMap.int2IntEntrySet().forEach(entry -> iCountConsumer.accept(this.field_186022_c.func_186039_a(entry.getIntKey()), entry.getIntValue()));
    }

    private static /* synthetic */ void func_225498_a(Int2IntMap int2IntMap, int n) {
        int2IntMap.put(n, int2IntMap.get(n) + 1);
    }

    @FunctionalInterface
    public static interface ICountConsumer<T> {
        public void accept(T var1, int var2);
    }
}

