/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world;

import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ICollisionReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.level.ColorResolver;

public interface IWorldReader
extends ILightReader,
ICollisionReader,
BiomeManager.IBiomeReader {
    @Nullable
    public IChunk func_217353_a(int var1, int var2, ChunkStatus var3, boolean var4);

    @Deprecated
    public boolean func_217354_b(int var1, int var2);

    public int func_201676_a(Heightmap.Type var1, int var2, int var3);

    public int func_175657_ab();

    public BiomeManager func_225523_d_();

    default public Biome func_226691_t_(BlockPos blockPos) {
        return this.func_225523_d_().func_226836_a_(blockPos);
    }

    @Override
    default public int func_225525_a_(BlockPos blockPos, ColorResolver colorResolver) {
        return colorResolver.getColor(this.func_226691_t_(blockPos), blockPos.func_177958_n(), blockPos.func_177952_p());
    }

    @Override
    default public Biome func_225526_b_(int n, int n2, int n3) {
        IChunk iChunk = this.func_217353_a(n >> 2, n3 >> 2, ChunkStatus.field_222608_d, false);
        if (iChunk != null && iChunk.func_225549_i_() != null) {
            return iChunk.func_225549_i_().func_225526_b_(n, n2, n3);
        }
        return this.func_225604_a_(n, n2, n3);
    }

    public Biome func_225604_a_(int var1, int var2, int var3);

    public boolean func_201670_d();

    public int func_181545_F();

    public Dimension func_201675_m();

    default public BlockPos func_205770_a(Heightmap.Type type, BlockPos blockPos) {
        return new BlockPos(blockPos.func_177958_n(), this.func_201676_a(type, blockPos.func_177958_n(), blockPos.func_177952_p()), blockPos.func_177952_p());
    }

    default public boolean func_175623_d(BlockPos blockPos) {
        return this.func_180495_p(blockPos).func_196958_f();
    }

    default public boolean func_175710_j(BlockPos blockPos) {
        if (blockPos.func_177956_o() >= this.func_181545_F()) {
            return this.func_226660_f_(blockPos);
        }
        \u26032 = new BlockPos(blockPos.func_177958_n(), this.func_181545_F(), blockPos.func_177952_p());
        if (!this.func_226660_f_(\u26032)) {
            return false;
        }
        \u26032 = \u26032.func_177977_b();
        while (\u26032.func_177956_o() > blockPos.func_177956_o()) {
            BlockState blockState = this.func_180495_p(\u26032);
            if (blockState.func_200016_a(this, \u26032) > 0 && !blockState.func_185904_a().func_76224_d()) {
                return false;
            }
            BlockPos \u26032 = \u26032.func_177977_b();
        }
        return true;
    }

    @Deprecated
    default public float func_205052_D(BlockPos blockPos) {
        return this.func_201675_m().func_227174_a_(this.func_201696_r(blockPos));
    }

    default public int func_175627_a(BlockPos blockPos, Direction direction) {
        return this.func_180495_p(blockPos).func_185893_b(this, blockPos, direction);
    }

    default public IChunk func_217349_x(BlockPos blockPos) {
        return this.func_212866_a_(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    default public IChunk func_212866_a_(int n, int n2) {
        return this.func_217353_a(n, n2, ChunkStatus.field_222617_m, true);
    }

    default public IChunk func_217348_a(int n, int n2, ChunkStatus chunkStatus) {
        return this.func_217353_a(n, n2, chunkStatus, true);
    }

    @Override
    @Nullable
    default public IBlockReader func_225522_c_(int n, int n2) {
        return this.func_217353_a(n, n2, ChunkStatus.field_223226_a_, false);
    }

    default public boolean func_201671_F(BlockPos blockPos) {
        return this.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
    }

    default public boolean func_72953_d(AxisAlignedBB axisAlignedBB) {
        int n = MathHelper.func_76128_c(axisAlignedBB.field_72340_a);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72336_d);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72338_b);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72337_e);
        \u2603 = MathHelper.func_76128_c(axisAlignedBB.field_72339_c);
        \u2603 = MathHelper.func_76143_f(axisAlignedBB.field_72334_f);
        try (BlockPos.PooledMutable \u26032 = BlockPos.PooledMutable.func_185346_s();){
            for (\u2603 = n; \u2603 < \u2603; ++\u2603) {
                for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                    for (\u2603 = \u2603; \u2603 < \u2603; ++\u2603) {
                        BlockState blockState = this.func_180495_p(\u26032.func_181079_c(\u2603, \u2603, \u2603));
                        if (blockState.func_204520_s().func_206888_e()) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
        }
        return false;
    }

    default public int func_201696_r(BlockPos blockPos) {
        return this.func_205049_d(blockPos, this.func_175657_ab());
    }

    default public int func_205049_d(BlockPos blockPos, int n) {
        if (blockPos.func_177958_n() < -30000000 || blockPos.func_177952_p() < -30000000 || blockPos.func_177958_n() >= 30000000 || blockPos.func_177952_p() >= 30000000) {
            return 15;
        }
        return this.func_226659_b_(blockPos, n);
    }

    @Deprecated
    default public boolean func_175667_e(BlockPos blockPos) {
        return this.func_217354_b(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
    }

    @Deprecated
    default public boolean func_175707_a(BlockPos blockPos, BlockPos blockPos2) {
        return this.func_217344_a(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), blockPos2.func_177958_n(), blockPos2.func_177956_o(), blockPos2.func_177952_p());
    }

    @Deprecated
    default public boolean func_217344_a(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n5 < 0 || n2 >= 256) {
            return false;
        }
        n3 >>= 4;
        n4 >>= 4;
        n6 >>= 4;
        for (\u2603 = n >>= 4; \u2603 <= n4; ++\u2603) {
            for (\u2603 = n3; \u2603 <= n6; ++\u2603) {
                if (this.func_217354_b(\u2603, \u2603)) continue;
                return false;
            }
        }
        return true;
    }
}

