/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.chunk;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.boss.dragon.EnderDragonPartEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.palette.UpgradeData;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.EmptyTickList;
import net.minecraft.world.ITickList;
import net.minecraft.world.SerializableTickList;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeContainer;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerTickList;
import net.minecraft.world.chunk.ChunkSection;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.DebugChunkGenerator;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerTickList;
import net.minecraft.world.server.ServerWorld;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Chunk
implements IChunk {
    private static final Logger field_150817_t = LogManager.getLogger();
    public static final ChunkSection field_186036_a = null;
    private final ChunkSection[] field_76652_q = new ChunkSection[16];
    private BiomeContainer field_76651_r;
    private final Map<BlockPos, CompoundNBT> field_201618_i = Maps.newHashMap();
    private boolean field_76636_d;
    private final World field_76637_e;
    private final Map<Heightmap.Type, Heightmap> field_76634_f = Maps.newEnumMap(Heightmap.Type.class);
    private final UpgradeData field_196967_n;
    private final Map<BlockPos, TileEntity> field_150816_i = Maps.newHashMap();
    private final ClassInheritanceMultiMap<Entity>[] field_76645_j;
    private final Map<String, StructureStart> field_201619_q = Maps.newHashMap();
    private final Map<String, LongSet> field_201620_r = Maps.newHashMap();
    private final ShortList[] field_201622_t = new ShortList[16];
    private ITickList<Block> field_201621_s;
    private ITickList<Fluid> field_205325_u;
    private boolean field_76644_m;
    private long field_76641_n;
    private volatile boolean field_76643_l;
    private long field_111204_q;
    @Nullable
    private Supplier<ChunkHolder.LocationType> field_217329_u;
    @Nullable
    private Consumer<Chunk> field_217330_v;
    private final ChunkPos field_212816_F;
    private volatile boolean field_217331_x;

    public Chunk(World world, ChunkPos chunkPos, BiomeContainer biomeContainer) {
        this(world, chunkPos, biomeContainer, UpgradeData.field_196994_a, EmptyTickList.func_205388_a(), EmptyTickList.func_205388_a(), 0L, null, null);
    }

    public Chunk(World world, ChunkPos chunkPos, BiomeContainer biomeContainer2, UpgradeData upgradeData, ITickList<Block> iTickList, ITickList<Fluid> iTickList2, long l, @Nullable ChunkSection[] chunkSectionArray, @Nullable Consumer<Chunk> consumer) {
        BiomeContainer biomeContainer2;
        this.field_76645_j = new ClassInheritanceMultiMap[16];
        this.field_76637_e = world;
        this.field_212816_F = chunkPos;
        this.field_196967_n = upgradeData;
        for (Heightmap.Type type : Heightmap.Type.values()) {
            if (!ChunkStatus.field_222617_m.func_222595_h().contains((Object)type)) continue;
            this.field_76634_f.put(type, new Heightmap(this, type));
        }
        for (int i = 0; i < this.field_76645_j.length; ++i) {
            this.field_76645_j[i] = new ClassInheritanceMultiMap<Entity>(Entity.class);
        }
        this.field_76651_r = biomeContainer2;
        this.field_201621_s = iTickList;
        this.field_205325_u = iTickList2;
        this.field_111204_q = l;
        this.field_217330_v = consumer;
        if (chunkSectionArray != null) {
            if (this.field_76652_q.length == chunkSectionArray.length) {
                System.arraycopy(chunkSectionArray, 0, this.field_76652_q, 0, this.field_76652_q.length);
            } else {
                field_150817_t.warn("Could not set level chunk sections, array length is {} instead of {}", (Object)chunkSectionArray.length, (Object)this.field_76652_q.length);
            }
        }
    }

    public Chunk(World world, ChunkPrimer chunkPrimer2) {
        this(world, chunkPrimer2.func_76632_l(), chunkPrimer2.func_225549_i_(), chunkPrimer2.func_196966_y(), chunkPrimer2.func_205218_i_(), chunkPrimer2.func_212247_j(), chunkPrimer2.func_177416_w(), chunkPrimer2.func_76587_i(), null);
        for (CompoundNBT compoundNBT : chunkPrimer2.func_201652_l()) {
            EntityType.func_220335_a(compoundNBT, world, entity -> {
                this.func_76612_a((Entity)entity);
                return entity;
            });
        }
        for (TileEntity tileEntity : chunkPrimer2.func_201627_k().values()) {
            this.func_150813_a(tileEntity);
        }
        this.field_201618_i.putAll(chunkPrimer2.func_201632_q());
        for (int \u26033 = 0; \u26033 < chunkPrimer2.func_201614_D().length; ++\u26033) {
            this.field_201622_t[\u26033] = chunkPrimer2.func_201614_D()[\u26033];
        }
        this.func_201612_a(chunkPrimer2.func_201609_c());
        this.func_201606_b(chunkPrimer2.func_201604_d());
        for (Map.Entry<Heightmap.Type, Heightmap> entry : chunkPrimer2.func_217311_f()) {
            if (!ChunkStatus.field_222617_m.func_222595_h().contains((Object)entry.getKey())) continue;
            this.func_217303_b(entry.getKey()).func_202268_a(entry.getValue().func_202269_a());
        }
        this.func_217305_b(chunkPrimer2.func_217310_r());
        this.field_76643_l = true;
    }

    @Override
    public Heightmap func_217303_b(Heightmap.Type type2) {
        return this.field_76634_f.computeIfAbsent(type2, type -> new Heightmap(this, (Heightmap.Type)((Object)type)));
    }

    @Override
    public Set<BlockPos> func_203066_o() {
        HashSet hashSet = Sets.newHashSet(this.field_201618_i.keySet());
        hashSet.addAll(this.field_150816_i.keySet());
        return hashSet;
    }

    @Override
    public ChunkSection[] func_76587_i() {
        return this.field_76652_q;
    }

    @Override
    public BlockState func_180495_p(BlockPos blockPos) {
        int n = blockPos.func_177958_n();
        n2 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p();
        if (this.field_76637_e.func_175624_G() == WorldType.field_180272_g) {
            BlockState blockState = null;
            if (n2 == 60) {
                blockState = Blocks.field_180401_cv.func_176223_P();
            }
            if (n2 == 70) {
                blockState = DebugChunkGenerator.func_177461_b(n, \u2603);
            }
            return blockState == null ? Blocks.field_150350_a.func_176223_P() : blockState;
        }
        try {
            int n2;
            if (n2 >= 0 && n2 >> 4 < this.field_76652_q.length && !ChunkSection.func_222628_a(\u2603 = this.field_76652_q[n2 >> 4])) {
                return \u2603.func_177485_a(n & 0xF, n2 & 0xF, \u2603 & 0xF);
            }
            return Blocks.field_150350_a.func_176223_P();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Getting block state");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being got");
            \u26032.func_189529_a("Location", () -> CrashReportCategory.func_184876_a(n, n2, \u2603));
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public IFluidState func_204610_c(BlockPos blockPos) {
        return this.func_205751_b(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p());
    }

    public IFluidState func_205751_b(int n, int n2, int n3) {
        try {
            if (n2 >= 0 && n2 >> 4 < this.field_76652_q.length && !ChunkSection.func_222628_a(\u2603 = this.field_76652_q[n2 >> 4])) {
                return \u2603.func_206914_b(n & 0xF, n2 & 0xF, n3 & 0xF);
            }
            return Fluids.field_204541_a.func_207188_f();
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Getting fluid state");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being got");
            \u26032.func_189529_a("Location", () -> CrashReportCategory.func_184876_a(n, n2, n3));
            throw new ReportedException(crashReport);
        }
    }

    @Override
    @Nullable
    public BlockState func_177436_a(BlockPos blockPos, BlockState blockState, boolean bl) {
        int n = blockPos.func_177958_n() & 0xF;
        \u2603 = blockPos.func_177956_o();
        \u2603 = blockPos.func_177952_p() & 0xF;
        ChunkSection \u26032 = this.field_76652_q[\u2603 >> 4];
        if (\u26032 == field_186036_a) {
            if (blockState.func_196958_f()) {
                return null;
            }
            this.field_76652_q[\u2603 >> 4] = \u26032 = new ChunkSection(\u2603 >> 4 << 4);
        }
        boolean \u26033 = \u26032.func_76663_a();
        BlockState \u26034 = \u26032.func_222629_a(n, \u2603 & 0xF, \u2603, blockState);
        if (\u26034 == blockState) {
            return null;
        }
        Block \u26035 = blockState.func_177230_c();
        Block \u26036 = \u26034.func_177230_c();
        this.field_76634_f.get((Object)Heightmap.Type.MOTION_BLOCKING).func_202270_a(n, \u2603, \u2603, blockState);
        this.field_76634_f.get((Object)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES).func_202270_a(n, \u2603, \u2603, blockState);
        this.field_76634_f.get((Object)Heightmap.Type.OCEAN_FLOOR).func_202270_a(n, \u2603, \u2603, blockState);
        this.field_76634_f.get((Object)Heightmap.Type.WORLD_SURFACE).func_202270_a(n, \u2603, \u2603, blockState);
        boolean \u26037 = \u26032.func_76663_a();
        if (\u26033 != \u26037) {
            this.field_76637_e.func_72863_F().func_212863_j_().func_215567_a(blockPos, \u26037);
        }
        if (!this.field_76637_e.field_72995_K) {
            \u26034.func_196947_b(this.field_76637_e, blockPos, blockState, bl);
        } else if (\u26036 != \u26035 && \u26036 instanceof ITileEntityProvider) {
            this.field_76637_e.func_175713_t(blockPos);
        }
        if (\u26032.func_177485_a(n, \u2603 & 0xF, \u2603).func_177230_c() != \u26035) {
            return null;
        }
        if (\u26036 instanceof ITileEntityProvider && (tileEntity = this.func_177424_a(blockPos, CreateEntityType.CHECK)) != null) {
            tileEntity.func_145836_u();
        }
        if (!this.field_76637_e.field_72995_K) {
            blockState.func_215705_a(this.field_76637_e, blockPos, \u26034, bl);
        }
        if (\u26035 instanceof ITileEntityProvider) {
            TileEntity tileEntity = this.func_177424_a(blockPos, CreateEntityType.CHECK);
            if (tileEntity == null) {
                tileEntity = ((ITileEntityProvider)((Object)\u26035)).func_196283_a_(this.field_76637_e);
                this.field_76637_e.func_175690_a(blockPos, tileEntity);
            } else {
                tileEntity.func_145836_u();
            }
        }
        this.field_76643_l = true;
        return \u26034;
    }

    @Nullable
    public WorldLightManager func_217307_e() {
        return this.field_76637_e.func_72863_F().func_212863_j_();
    }

    @Override
    public void func_76612_a(Entity entity) {
        this.field_76644_m = true;
        int n = MathHelper.func_76128_c(entity.func_226277_ct_() / 16.0);
        \u2603 = MathHelper.func_76128_c(entity.func_226281_cx_() / 16.0);
        if (n != this.field_212816_F.field_77276_a || \u2603 != this.field_212816_F.field_77275_b) {
            field_150817_t.warn("Wrong location! ({}, {}) should be ({}, {}), {}", (Object)n, (Object)\u2603, (Object)this.field_212816_F.field_77276_a, (Object)this.field_212816_F.field_77275_b, (Object)entity);
            entity.field_70128_L = true;
        }
        if ((\u2603 = MathHelper.func_76128_c(entity.func_226278_cu_() / 16.0)) < 0) {
            \u2603 = 0;
        }
        if (\u2603 >= this.field_76645_j.length) {
            \u2603 = this.field_76645_j.length - 1;
        }
        entity.field_70175_ag = true;
        entity.field_70176_ah = this.field_212816_F.field_77276_a;
        entity.field_70162_ai = \u2603;
        entity.field_70164_aj = this.field_212816_F.field_77275_b;
        this.field_76645_j[\u2603].add(entity);
    }

    @Override
    public void func_201607_a(Heightmap.Type type, long[] lArray) {
        this.field_76634_f.get((Object)type).func_202268_a(lArray);
    }

    public void func_76622_b(Entity entity) {
        this.func_76608_a(entity, entity.field_70162_ai);
    }

    public void func_76608_a(Entity entity, int n) {
        if (n < 0) {
            n = 0;
        }
        if (n >= this.field_76645_j.length) {
            n = this.field_76645_j.length - 1;
        }
        this.field_76645_j[n].remove(entity);
    }

    @Override
    public int func_201576_a(Heightmap.Type type, int n, int n2) {
        return this.field_76634_f.get((Object)type).func_202273_a(n & 0xF, n2 & 0xF) - 1;
    }

    @Nullable
    private TileEntity func_177422_i(BlockPos blockPos) {
        BlockState blockState = this.func_180495_p(blockPos);
        Block \u26032 = blockState.func_177230_c();
        if (!\u26032.func_149716_u()) {
            return null;
        }
        return ((ITileEntityProvider)((Object)\u26032)).func_196283_a_(this.field_76637_e);
    }

    @Override
    @Nullable
    public TileEntity func_175625_s(BlockPos blockPos) {
        return this.func_177424_a(blockPos, CreateEntityType.CHECK);
    }

    @Nullable
    public TileEntity func_177424_a(BlockPos blockPos, CreateEntityType createEntityType) {
        TileEntity tileEntity = this.field_150816_i.get(blockPos);
        if (tileEntity == null && (\u2603 = this.field_201618_i.remove(blockPos)) != null && (\u2603 = this.func_212815_a(blockPos, \u2603)) != null) {
            return \u2603;
        }
        if (tileEntity == null) {
            if (createEntityType == CreateEntityType.IMMEDIATE) {
                tileEntity = this.func_177422_i(blockPos);
                this.field_76637_e.func_175690_a(blockPos, tileEntity);
            }
        } else if (tileEntity.func_145837_r()) {
            this.field_150816_i.remove(blockPos);
            return null;
        }
        return tileEntity;
    }

    public void func_150813_a(TileEntity tileEntity) {
        this.func_177426_a(tileEntity.func_174877_v(), tileEntity);
        if (this.field_76636_d || this.field_76637_e.func_201670_d()) {
            this.field_76637_e.func_175690_a(tileEntity.func_174877_v(), tileEntity);
        }
    }

    @Override
    public void func_177426_a(BlockPos blockPos, TileEntity tileEntity) {
        if (!(this.func_180495_p(blockPos).func_177230_c() instanceof ITileEntityProvider)) {
            return;
        }
        tileEntity.func_226984_a_(this.field_76637_e, blockPos);
        tileEntity.func_145829_t();
        \u2603 = this.field_150816_i.put(blockPos.func_185334_h(), tileEntity);
        if (\u2603 != null && \u2603 != tileEntity) {
            \u2603.func_145843_s();
        }
    }

    @Override
    public void func_201591_a(CompoundNBT compoundNBT) {
        this.field_201618_i.put(new BlockPos(compoundNBT.func_74762_e("x"), compoundNBT.func_74762_e("y"), compoundNBT.func_74762_e("z")), compoundNBT);
    }

    @Override
    @Nullable
    public CompoundNBT func_223134_j(BlockPos blockPos2) {
        BlockPos blockPos2;
        TileEntity tileEntity = this.func_175625_s(blockPos2);
        if (tileEntity != null && !tileEntity.func_145837_r()) {
            CompoundNBT compoundNBT = tileEntity.func_189515_b(new CompoundNBT());
            compoundNBT.func_74757_a("keepPacked", false);
            return compoundNBT;
        }
        CompoundNBT \u26032 = this.field_201618_i.get(blockPos2);
        if (\u26032 != null) {
            \u26032 = \u26032.func_74737_b();
            \u26032.func_74757_a("keepPacked", true);
        }
        return \u26032;
    }

    @Override
    public void func_177425_e(BlockPos blockPos) {
        if ((this.field_76636_d || this.field_76637_e.func_201670_d()) && (\u2603 = this.field_150816_i.remove(blockPos)) != null) {
            \u2603.func_145843_s();
        }
    }

    public void func_217318_w() {
        if (this.field_217330_v != null) {
            this.field_217330_v.accept(this);
            this.field_217330_v = null;
        }
    }

    public void func_76630_e() {
        this.field_76643_l = true;
    }

    public void func_177414_a(@Nullable Entity entity, AxisAlignedBB axisAlignedBB, List<Entity> list, @Nullable Predicate<? super Entity> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72338_b - 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72337_e + 2.0) / 16.0);
        n = MathHelper.func_76125_a(n, 0, this.field_76645_j.length - 1);
        \u2603 = MathHelper.func_76125_a(\u2603, 0, this.field_76645_j.length - 1);
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            if (this.field_76645_j[\u2603].isEmpty()) continue;
            for (Entity entity2 : this.field_76645_j[\u2603]) {
                if (!entity2.func_174813_aQ().func_72326_a(axisAlignedBB) || entity2 == entity) continue;
                if (predicate == null || predicate.test(entity2)) {
                    list.add(entity2);
                }
                if (!(entity2 instanceof EnderDragonEntity)) continue;
                for (EnderDragonPartEntity enderDragonPartEntity : ((EnderDragonEntity)entity2).func_213404_dT()) {
                    if (enderDragonPartEntity == entity || !enderDragonPartEntity.func_174813_aQ().func_72326_a(axisAlignedBB) || predicate != null && !predicate.test(enderDragonPartEntity)) continue;
                    list.add(enderDragonPartEntity);
                }
            }
        }
    }

    public <T extends Entity> void func_217313_a(@Nullable EntityType<?> entityType, AxisAlignedBB axisAlignedBB, List<? super T> list, Predicate<? super T> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72338_b - 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72337_e + 2.0) / 16.0);
        n = MathHelper.func_76125_a(n, 0, this.field_76645_j.length - 1);
        \u2603 = MathHelper.func_76125_a(\u2603, 0, this.field_76645_j.length - 1);
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            for (Entity entity : this.field_76645_j[\u2603].func_219790_a(Entity.class)) {
                if (entityType != null && entity.func_200600_R() != entityType) continue;
                \u2603 = entity;
                if (!entity.func_174813_aQ().func_72326_a(axisAlignedBB) || !predicate.test(\u2603)) continue;
                list.add(\u2603);
            }
        }
    }

    public <T extends Entity> void func_177430_a(Class<? extends T> clazz, AxisAlignedBB axisAlignedBB, List<T> list, @Nullable Predicate<? super T> predicate) {
        int n = MathHelper.func_76128_c((axisAlignedBB.field_72338_b - 2.0) / 16.0);
        \u2603 = MathHelper.func_76128_c((axisAlignedBB.field_72337_e + 2.0) / 16.0);
        n = MathHelper.func_76125_a(n, 0, this.field_76645_j.length - 1);
        \u2603 = MathHelper.func_76125_a(\u2603, 0, this.field_76645_j.length - 1);
        for (\u2603 = n; \u2603 <= \u2603; ++\u2603) {
            for (Entity entity : this.field_76645_j[\u2603].func_219790_a(clazz)) {
                if (!entity.func_174813_aQ().func_72326_a(axisAlignedBB) || predicate != null && !predicate.test(entity)) continue;
                list.add(entity);
            }
        }
    }

    public boolean func_76621_g() {
        return false;
    }

    @Override
    public ChunkPos func_76632_l() {
        return this.field_212816_F;
    }

    public void func_227073_a_(@Nullable BiomeContainer biomeContainer2, PacketBuffer packetBuffer, CompoundNBT compoundNBT, int n) {
        BiomeContainer biomeContainer2;
        boolean bl = biomeContainer2 != null;
        Predicate<BlockPos> \u26032 = bl ? blockPos -> true : blockPos -> (n & 1 << (blockPos.func_177956_o() >> 4)) != 0;
        Sets.newHashSet(this.field_150816_i.keySet()).stream().filter(\u26032).forEach(this.field_76637_e::func_175713_t);
        for (int i = 0; i < this.field_76652_q.length; ++i) {
            ChunkSection chunkSection = this.field_76652_q[i];
            if ((n & 1 << i) == 0) {
                if (!bl || chunkSection == field_186036_a) continue;
                this.field_76652_q[i] = field_186036_a;
                continue;
            }
            if (chunkSection == field_186036_a) {
                this.field_76652_q[i] = chunkSection = new ChunkSection(i << 4);
            }
            chunkSection.func_222634_a(packetBuffer);
        }
        if (biomeContainer2 != null) {
            this.field_76651_r = biomeContainer2;
        }
        for (Heightmap.Type type : Heightmap.Type.values()) {
            String string = type.func_203500_b();
            if (!compoundNBT.func_150297_b(string, 12)) continue;
            this.func_201607_a(type, compoundNBT.func_197645_o(string));
        }
        for (TileEntity tileEntity : this.field_150816_i.values()) {
            tileEntity.func_145836_u();
        }
    }

    @Override
    public BiomeContainer func_225549_i_() {
        return this.field_76651_r;
    }

    public void func_177417_c(boolean bl) {
        this.field_76636_d = bl;
    }

    public World func_177412_p() {
        return this.field_76637_e;
    }

    @Override
    public Collection<Map.Entry<Heightmap.Type, Heightmap>> func_217311_f() {
        return Collections.unmodifiableSet(this.field_76634_f.entrySet());
    }

    public Map<BlockPos, TileEntity> func_177434_r() {
        return this.field_150816_i;
    }

    public ClassInheritanceMultiMap<Entity>[] func_177429_s() {
        return this.field_76645_j;
    }

    @Override
    public CompoundNBT func_201579_g(BlockPos blockPos) {
        return this.field_201618_i.get(blockPos);
    }

    @Override
    public Stream<BlockPos> func_217304_m() {
        return StreamSupport.stream(BlockPos.func_191531_b(this.field_212816_F.func_180334_c(), 0, this.field_212816_F.func_180333_d(), this.field_212816_F.func_180332_e(), 255, this.field_212816_F.func_180330_f()).spliterator(), false).filter(blockPos -> this.func_180495_p((BlockPos)blockPos).func_185906_d() != 0);
    }

    @Override
    public ITickList<Block> func_205218_i_() {
        return this.field_201621_s;
    }

    @Override
    public ITickList<Fluid> func_212247_j() {
        return this.field_205325_u;
    }

    @Override
    public void func_177427_f(boolean bl) {
        this.field_76643_l = bl;
    }

    @Override
    public boolean func_201593_f() {
        return this.field_76643_l || this.field_76644_m && this.field_76637_e.func_82737_E() != this.field_76641_n;
    }

    public void func_177409_g(boolean bl) {
        this.field_76644_m = bl;
    }

    @Override
    public void func_177432_b(long l) {
        this.field_76641_n = l;
    }

    @Override
    @Nullable
    public StructureStart func_201585_a(String string) {
        return this.field_201619_q.get(string);
    }

    @Override
    public void func_201584_a(String string, StructureStart structureStart) {
        this.field_201619_q.put(string, structureStart);
    }

    @Override
    public Map<String, StructureStart> func_201609_c() {
        return this.field_201619_q;
    }

    @Override
    public void func_201612_a(Map<String, StructureStart> map) {
        this.field_201619_q.clear();
        this.field_201619_q.putAll(map);
    }

    @Override
    public LongSet func_201578_b(String string2) {
        return this.field_201620_r.computeIfAbsent(string2, string -> new LongOpenHashSet());
    }

    @Override
    public void func_201583_a(String string2, long l) {
        this.field_201620_r.computeIfAbsent(string2, string -> new LongOpenHashSet()).add(l);
    }

    @Override
    public Map<String, LongSet> func_201604_d() {
        return this.field_201620_r;
    }

    @Override
    public void func_201606_b(Map<String, LongSet> map) {
        this.field_201620_r.clear();
        this.field_201620_r.putAll(map);
    }

    @Override
    public long func_177416_w() {
        return this.field_111204_q;
    }

    @Override
    public void func_177415_c(long l) {
        this.field_111204_q = l;
    }

    public void func_201595_A() {
        ChunkPos chunkPos = this.func_76632_l();
        for (int i = 0; i < this.field_201622_t.length; ++i) {
            if (this.field_201622_t[i] == null) continue;
            for (Short s : this.field_201622_t[i]) {
                BlockPos blockPos = ChunkPrimer.func_201635_a(s, i, chunkPos);
                BlockState \u26032 = this.func_180495_p(blockPos);
                BlockState \u26033 = Block.func_199770_b(\u26032, this.field_76637_e, blockPos);
                this.field_76637_e.func_180501_a(blockPos, \u26033, 20);
            }
            this.field_201622_t[i].clear();
        }
        this.func_222879_B();
        for (BlockPos blockPos : Sets.newHashSet(this.field_201618_i.keySet())) {
            this.func_175625_s(blockPos);
        }
        this.field_201618_i.clear();
        this.field_196967_n.func_196990_a(this);
    }

    @Nullable
    private TileEntity func_212815_a(BlockPos blockPos, CompoundNBT compoundNBT2) {
        TileEntity \u26032;
        if ("DUMMY".equals(compoundNBT2.func_74779_i("id"))) {
            Block block = this.func_180495_p(blockPos).func_177230_c();
            if (block instanceof ITileEntityProvider) {
                \u26032 = ((ITileEntityProvider)((Object)block)).func_196283_a_(this.field_76637_e);
            } else {
                \u26032 = null;
                field_150817_t.warn("Tried to load a DUMMY block entity @ {} but found not block entity block {} at location", (Object)blockPos, (Object)this.func_180495_p(blockPos));
            }
        } else {
            CompoundNBT compoundNBT2;
            \u26032 = TileEntity.func_203403_c(compoundNBT2);
        }
        if (\u26032 != null) {
            \u26032.func_226984_a_(this.field_76637_e, blockPos);
            this.func_150813_a(\u26032);
        } else {
            field_150817_t.warn("Tried to load a block entity for block {} but failed at location {}", (Object)this.func_180495_p(blockPos), (Object)blockPos);
        }
        return \u26032;
    }

    @Override
    public UpgradeData func_196966_y() {
        return this.field_196967_n;
    }

    @Override
    public ShortList[] func_201614_D() {
        return this.field_201622_t;
    }

    public void func_222879_B() {
        if (this.field_201621_s instanceof ChunkPrimerTickList) {
            ((ChunkPrimerTickList)this.field_201621_s).func_205381_a(this.field_76637_e.func_205220_G_(), blockPos -> this.func_180495_p((BlockPos)blockPos).func_177230_c());
            this.field_201621_s = EmptyTickList.func_205388_a();
        } else if (this.field_201621_s instanceof SerializableTickList) {
            this.field_76637_e.func_205220_G_().func_219497_a(((SerializableTickList)this.field_201621_s).func_219499_a());
            this.field_201621_s = EmptyTickList.func_205388_a();
        }
        if (this.field_205325_u instanceof ChunkPrimerTickList) {
            ((ChunkPrimerTickList)this.field_205325_u).func_205381_a(this.field_76637_e.func_205219_F_(), blockPos -> this.func_204610_c((BlockPos)blockPos).func_206886_c());
            this.field_205325_u = EmptyTickList.func_205388_a();
        } else if (this.field_205325_u instanceof SerializableTickList) {
            this.field_76637_e.func_205219_F_().func_219497_a(((SerializableTickList)this.field_205325_u).func_219499_a());
            this.field_205325_u = EmptyTickList.func_205388_a();
        }
    }

    public void func_222880_a(ServerWorld serverWorld) {
        if (this.field_201621_s == EmptyTickList.func_205388_a()) {
            this.field_201621_s = new SerializableTickList<Block>(Registry.field_212618_g::func_177774_c, ((ServerTickList)serverWorld.func_205220_G_()).func_223188_a(this.field_212816_F, true, false));
            this.func_177427_f(true);
        }
        if (this.field_205325_u == EmptyTickList.func_205388_a()) {
            this.field_205325_u = new SerializableTickList<Fluid>(Registry.field_212619_h::func_177774_c, ((ServerTickList)serverWorld.func_205219_F_()).func_223188_a(this.field_212816_F, true, false));
            this.func_177427_f(true);
        }
    }

    @Override
    public ChunkStatus func_201589_g() {
        return ChunkStatus.field_222617_m;
    }

    public ChunkHolder.LocationType func_217321_u() {
        if (this.field_217329_u == null) {
            return ChunkHolder.LocationType.BORDER;
        }
        return this.field_217329_u.get();
    }

    public void func_217314_a(Supplier<ChunkHolder.LocationType> supplier) {
        this.field_217329_u = supplier;
    }

    @Override
    public boolean func_217310_r() {
        return this.field_217331_x;
    }

    @Override
    public void func_217305_b(boolean bl) {
        this.field_217331_x = bl;
        this.func_177427_f(true);
    }

    public static enum CreateEntityType {
        IMMEDIATE,
        QUEUED,
        CHECK;

    }
}

