/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.gen.feature.structure;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Dynamic;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeManager;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Structure<C extends IFeatureConfig>
extends Feature<C> {
    private static final Logger field_208204_b = LogManager.getLogger();

    public Structure(Function<Dynamic<?>, ? extends C> function) {
        super(function);
    }

    @Override
    public ConfiguredFeature<C, ? extends Structure<C>> func_225566_b_(C c) {
        return new ConfiguredFeature<C, Structure>(this, c);
    }

    @Override
    public boolean func_212245_a(IWorld iWorld, ChunkGenerator<? extends GenerationSettings> chunkGenerator, Random random, BlockPos blockPos, C c) {
        if (!iWorld.func_72912_H().func_76089_r()) {
            return false;
        }
        int n = blockPos.func_177958_n() >> 4;
        \u2603 = blockPos.func_177952_p() >> 4;
        \u2603 = n << 4;
        \u2603 = \u2603 << 4;
        boolean \u26032 = false;
        for (Long l : iWorld.func_212866_a_(n, \u2603).func_201578_b(this.func_143025_a())) {
            ChunkPos chunkPos = new ChunkPos(l);
            StructureStart \u26033 = iWorld.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b).func_201585_a(this.func_143025_a());
            if (\u26033 == null || \u26033 == StructureStart.field_214630_a) continue;
            \u26033.func_225565_a_(iWorld, chunkGenerator, random, new MutableBoundingBox(\u2603, \u2603, \u2603 + 15, \u2603 + 15), new ChunkPos(n, \u2603));
            \u26032 = true;
        }
        return \u26032;
    }

    protected StructureStart func_202364_a(IWorld iWorld, BlockPos blockPos, boolean bl) {
        List<StructureStart> list = this.func_202371_a(iWorld, blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4);
        for (StructureStart structureStart : list) {
            if (!structureStart.func_75069_d() || !structureStart.func_75071_a().func_175898_b(blockPos)) continue;
            if (!bl) {
                return structureStart;
            }
            for (StructurePiece structurePiece : structureStart.func_186161_c()) {
                if (!structurePiece.func_74874_b().func_175898_b(blockPos)) continue;
                return structureStart;
            }
        }
        return StructureStart.field_214630_a;
    }

    public boolean func_175796_a(IWorld iWorld, BlockPos blockPos) {
        return this.func_202364_a(iWorld, blockPos, false).func_75069_d();
    }

    public boolean func_202366_b(IWorld iWorld, BlockPos blockPos) {
        return this.func_202364_a(iWorld, blockPos, true).func_75069_d();
    }

    @Nullable
    public BlockPos func_211405_a(World world, ChunkGenerator<? extends GenerationSettings> chunkGenerator, BlockPos blockPos, int n, boolean bl) {
        if (!chunkGenerator.func_202090_b().func_205004_a(this)) {
            return null;
        }
        int n2 = blockPos.func_177958_n() >> 4;
        \u2603 = blockPos.func_177952_p() >> 4;
        SharedSeedRandom \u26032 = new SharedSeedRandom();
        block0: for (\u2603 = 0; \u2603 <= n; ++\u2603) {
            for (\u2603 = -\u2603; \u2603 <= \u2603; ++\u2603) {
                boolean bl2 = \u2603 == -\u2603 || \u2603 == \u2603;
                for (int i = -\u2603; i <= \u2603; ++i) {
                    boolean bl3 = \u2603 = i == -\u2603 || i == \u2603;
                    if (!bl2 && !\u2603) continue;
                    ChunkPos chunkPos = this.func_211744_a(chunkGenerator, \u26032, n2, \u2603, \u2603, i);
                    StructureStart \u26033 = world.func_217348_a(chunkPos.field_77276_a, chunkPos.field_77275_b, ChunkStatus.field_222606_b).func_201585_a(this.func_143025_a());
                    if (\u26033 != null && \u26033.func_75069_d()) {
                        if (bl && \u26033.func_212687_g()) {
                            \u26033.func_212685_h();
                            return \u26033.func_204294_a();
                        }
                        if (!bl) {
                            return \u26033.func_204294_a();
                        }
                    }
                    if (\u2603 == 0) break;
                }
                if (\u2603 == 0) continue block0;
            }
        }
        return null;
    }

    private List<StructureStart> func_202371_a(IWorld iWorld, int n, int n2) {
        ArrayList arrayList = Lists.newArrayList();
        IChunk \u26032 = iWorld.func_217348_a(n, n2, ChunkStatus.field_222607_c);
        LongIterator \u26033 = \u26032.func_201578_b(this.func_143025_a()).iterator();
        while (\u26033.hasNext()) {
            long l = \u26033.nextLong();
            IChunk \u26034 = iWorld.func_217348_a(ChunkPos.func_212578_a(l), ChunkPos.func_212579_b(l), ChunkStatus.field_222606_b);
            StructureStart \u26035 = \u26034.func_201585_a(this.func_143025_a());
            if (\u26035 == null) continue;
            arrayList.add(\u26035);
        }
        return arrayList;
    }

    protected ChunkPos func_211744_a(ChunkGenerator<?> chunkGenerator, Random random, int n, int n2, int n3, int n4) {
        return new ChunkPos(n + n3, n2 + n4);
    }

    public abstract boolean func_225558_a_(BiomeManager var1, ChunkGenerator<?> var2, Random var3, int var4, int var5, Biome var6);

    public abstract IStartFactory func_214557_a();

    public abstract String func_143025_a();

    public abstract int func_202367_b();

    public static interface IStartFactory {
        public StructureStart create(Structure<?> var1, int var2, int var3, MutableBoundingBox var4, int var5, long var6);
    }
}

