/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.server;

import com.mojang.datafixers.util.Either;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.network.play.server.SChunkDataPacket;
import net.minecraft.network.play.server.SMultiBlockChangePacket;
import net.minecraft.network.play.server.SUpdateLightPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.ChunkPrimerWrapper;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.lighting.WorldLightManager;
import net.minecraft.world.server.ChunkManager;

public class ChunkHolder {
    public static final Either<IChunk, IChunkLoadingError> field_219306_a = Either.right((Object)IChunkLoadingError.field_219055_b);
    public static final CompletableFuture<Either<IChunk, IChunkLoadingError>> field_219307_b = CompletableFuture.completedFuture(field_219306_a);
    public static final Either<Chunk, IChunkLoadingError> field_219308_c = Either.right((Object)IChunkLoadingError.field_219055_b);
    private static final CompletableFuture<Either<Chunk, IChunkLoadingError>> field_219309_d = CompletableFuture.completedFuture(field_219308_c);
    private static final List<ChunkStatus> field_219310_e = ChunkStatus.func_222582_a();
    private static final LocationType[] field_219311_f = LocationType.values();
    private final AtomicReferenceArray<CompletableFuture<Either<IChunk, IChunkLoadingError>>> field_219312_g = new AtomicReferenceArray(field_219310_e.size());
    private volatile CompletableFuture<Either<Chunk, IChunkLoadingError>> field_222983_h = field_219309_d;
    private volatile CompletableFuture<Either<Chunk, IChunkLoadingError>> field_219313_h = field_219309_d;
    private volatile CompletableFuture<Either<Chunk, IChunkLoadingError>> field_219314_i = field_219309_d;
    private CompletableFuture<IChunk> field_219315_j = CompletableFuture.completedFuture(null);
    private int field_219316_k;
    private int field_219317_l;
    private int field_219318_m;
    private final ChunkPos field_219319_n;
    private final short[] field_219320_o = new short[64];
    private int field_219321_p;
    private int field_219322_q;
    private int field_219323_r;
    private int field_219324_s;
    private int field_219325_t;
    private final WorldLightManager field_219326_u;
    private final IListener field_219327_v;
    private final IPlayerProvider field_219328_w;
    private boolean field_219329_x;

    public ChunkHolder(ChunkPos chunkPos, int n, WorldLightManager worldLightManager, IListener iListener, IPlayerProvider iPlayerProvider) {
        this.field_219319_n = chunkPos;
        this.field_219326_u = worldLightManager;
        this.field_219327_v = iListener;
        this.field_219328_w = iPlayerProvider;
        this.field_219317_l = this.field_219316_k = ChunkManager.field_219249_a + 1;
        this.field_219318_m = this.field_219316_k;
        this.func_219292_a(n);
    }

    public CompletableFuture<Either<IChunk, IChunkLoadingError>> func_219301_a(ChunkStatus chunkStatus) {
        CompletableFuture<Either<IChunk, IChunkLoadingError>> completableFuture = this.field_219312_g.get(chunkStatus.func_222584_c());
        return completableFuture == null ? field_219307_b : completableFuture;
    }

    public CompletableFuture<Either<IChunk, IChunkLoadingError>> func_225410_b(ChunkStatus chunkStatus) {
        if (ChunkHolder.func_219278_b(this.field_219317_l).func_209003_a(chunkStatus)) {
            return this.func_219301_a(chunkStatus);
        }
        return field_219307_b;
    }

    public CompletableFuture<Either<Chunk, IChunkLoadingError>> func_219296_a() {
        return this.field_219313_h;
    }

    public CompletableFuture<Either<Chunk, IChunkLoadingError>> func_219297_b() {
        return this.field_219314_i;
    }

    public CompletableFuture<Either<Chunk, IChunkLoadingError>> func_223492_c() {
        return this.field_222983_h;
    }

    @Nullable
    public Chunk func_219298_c() {
        CompletableFuture<Either<Chunk, IChunkLoadingError>> completableFuture = this.func_219296_a();
        Either \u26032 = completableFuture.getNow(null);
        if (\u26032 == null) {
            return null;
        }
        return \u26032.left().orElse(null);
    }

    @Nullable
    public ChunkStatus func_219285_d() {
        for (int i = field_219310_e.size() - 1; i >= 0; --i) {
            ChunkStatus chunkStatus = field_219310_e.get(i);
            CompletableFuture<Either<IChunk, IChunkLoadingError>> \u26032 = this.func_219301_a(chunkStatus);
            if (!\u26032.getNow(field_219306_a).left().isPresent()) continue;
            return chunkStatus;
        }
        return null;
    }

    @Nullable
    public IChunk func_219287_e() {
        for (int i = field_219310_e.size() - 1; i >= 0; --i) {
            ChunkStatus chunkStatus = field_219310_e.get(i);
            CompletableFuture<Either<IChunk, IChunkLoadingError>> \u26032 = this.func_219301_a(chunkStatus);
            if (\u26032.isCompletedExceptionally() || !(\u2603 = \u26032.getNow(field_219306_a).left()).isPresent()) continue;
            return (IChunk)\u2603.get();
        }
        return null;
    }

    public CompletableFuture<IChunk> func_219302_f() {
        return this.field_219315_j;
    }

    public void func_219279_a(int n, int n2, int n3) {
        Chunk chunk = this.func_219298_c();
        if (chunk == null) {
            return;
        }
        this.field_219322_q |= 1 << (n2 >> 4);
        if (this.field_219321_p < 64) {
            short s = (short)(n << 12 | n3 << 8 | n2);
            for (int i = 0; i < this.field_219321_p; ++i) {
                if (this.field_219320_o[i] != s) continue;
                return;
            }
            this.field_219320_o[this.field_219321_p++] = s;
        }
    }

    public void func_219280_a(LightType lightType, int n) {
        Chunk chunk = this.func_219298_c();
        if (chunk == null) {
            return;
        }
        chunk.func_177427_f(true);
        if (lightType == LightType.SKY) {
            this.field_219325_t |= 1 << n - -1;
        } else {
            this.field_219324_s |= 1 << n - -1;
        }
    }

    public void func_219274_a(Chunk chunk) {
        int n;
        if (this.field_219321_p == 0 && this.field_219325_t == 0 && this.field_219324_s == 0) {
            return;
        }
        World world = chunk.func_177412_p();
        if (this.field_219321_p == 64) {
            this.field_219323_r = -1;
        }
        if (this.field_219325_t != 0 || this.field_219324_s != 0) {
            this.func_219293_a(new SUpdateLightPacket(chunk.func_76632_l(), this.field_219326_u, this.field_219325_t & ~this.field_219323_r, this.field_219324_s & ~this.field_219323_r), true);
            n = this.field_219325_t & this.field_219323_r;
            \u2603 = this.field_219324_s & this.field_219323_r;
            if (n != 0 || \u2603 != 0) {
                this.func_219293_a(new SUpdateLightPacket(chunk.func_76632_l(), this.field_219326_u, n, \u2603), false);
            }
            this.field_219325_t = 0;
            this.field_219324_s = 0;
            this.field_219323_r &= ~(this.field_219325_t & this.field_219324_s);
        }
        if (this.field_219321_p == 1) {
            n = (this.field_219320_o[0] >> 12 & 0xF) + this.field_219319_n.field_77276_a * 16;
            \u2603 = this.field_219320_o[0] & 0xFF;
            \u2603 = (this.field_219320_o[0] >> 8 & 0xF) + this.field_219319_n.field_77275_b * 16;
            BlockPos \u26032 = new BlockPos(n, \u2603, \u2603);
            this.func_219293_a(new SChangeBlockPacket(world, \u26032), false);
            if (world.func_180495_p(\u26032).func_177230_c().func_149716_u()) {
                this.func_219305_a(world, \u26032);
            }
        } else if (this.field_219321_p == 64) {
            this.func_219293_a(new SChunkDataPacket(chunk, this.field_219322_q), false);
        } else if (this.field_219321_p != 0) {
            this.func_219293_a(new SMultiBlockChangePacket(this.field_219321_p, this.field_219320_o, chunk), false);
            for (n = 0; n < this.field_219321_p; ++n) {
                \u2603 = (this.field_219320_o[n] >> 12 & 0xF) + this.field_219319_n.field_77276_a * 16;
                \u2603 = this.field_219320_o[n] & 0xFF;
                \u2603 = (this.field_219320_o[n] >> 8 & 0xF) + this.field_219319_n.field_77275_b * 16;
                BlockPos blockPos = new BlockPos(\u2603, \u2603, \u2603);
                if (!world.func_180495_p(blockPos).func_177230_c().func_149716_u()) continue;
                this.func_219305_a(world, blockPos);
            }
        }
        this.field_219321_p = 0;
        this.field_219322_q = 0;
    }

    private void func_219305_a(World world, BlockPos blockPos) {
        TileEntity tileEntity = world.func_175625_s(blockPos);
        if (tileEntity != null && (\u2603 = tileEntity.func_189518_D_()) != null) {
            this.func_219293_a(\u2603, false);
        }
    }

    private void func_219293_a(IPacket<?> iPacket, boolean bl) {
        this.field_219328_w.func_219097_a(this.field_219319_n, bl).forEach(serverPlayerEntity -> serverPlayerEntity.field_71135_a.func_147359_a(iPacket));
    }

    public CompletableFuture<Either<IChunk, IChunkLoadingError>> func_219276_a(ChunkStatus chunkStatus, ChunkManager chunkManager) {
        int n = chunkStatus.func_222584_c();
        CompletableFuture<Either<IChunk, IChunkLoadingError>> \u26032 = this.field_219312_g.get(n);
        if (\u26032 != null && ((object = (Either)\u26032.getNow(null)) == null || object.left().isPresent())) {
            return \u26032;
        }
        if (ChunkHolder.func_219278_b(this.field_219317_l).func_209003_a(chunkStatus)) {
            Object object = chunkManager.func_219244_a(this, chunkStatus);
            this.func_219284_a((CompletableFuture<? extends Either<? extends IChunk, IChunkLoadingError>>)object);
            this.field_219312_g.set(n, (CompletableFuture<Either<IChunk, IChunkLoadingError>>)object);
            return object;
        }
        return \u26032 == null ? field_219307_b : \u26032;
    }

    private void func_219284_a(CompletableFuture<? extends Either<? extends IChunk, IChunkLoadingError>> completableFuture) {
        this.field_219315_j = this.field_219315_j.thenCombine(completableFuture, (iChunk2, either) -> (IChunk)either.map(iChunk -> iChunk, iChunkLoadingError -> iChunk2));
    }

    public LocationType func_219300_g() {
        return ChunkHolder.func_219286_c(this.field_219317_l);
    }

    public ChunkPos func_219277_h() {
        return this.field_219319_n;
    }

    public int func_219299_i() {
        return this.field_219317_l;
    }

    public int func_219281_j() {
        return this.field_219318_m;
    }

    private void func_219275_d(int n) {
        this.field_219318_m = n;
    }

    public void func_219292_a(int n) {
        this.field_219317_l = n;
    }

    protected void func_219291_a(ChunkManager chunkManager) {
        CompletableFuture<Either<IChunk, IChunkLoadingError>> completableFuture;
        ChunkStatus chunkStatus = ChunkHolder.func_219278_b(this.field_219316_k);
        \u2603 = ChunkHolder.func_219278_b(this.field_219317_l);
        boolean \u26032 = this.field_219316_k <= ChunkManager.field_219249_a;
        boolean \u26033 = this.field_219317_l <= ChunkManager.field_219249_a;
        LocationType \u26034 = ChunkHolder.func_219286_c(this.field_219316_k);
        LocationType \u26035 = ChunkHolder.func_219286_c(this.field_219317_l);
        if (\u26032) {
            Either either2 = Either.right((Object)new IChunkLoadingError(){

                public String toString() {
                    return "Unloaded ticket level " + ChunkHolder.this.field_219319_n.toString();
                }
            });
            int n = \u26036 = \u26033 ? \u2603.func_222584_c() + 1 : 0;
            while (\u26036 <= chunkStatus.func_222584_c()) {
                completableFuture = this.field_219312_g.get(\u26036);
                if (completableFuture != null) {
                    completableFuture.complete((Either<IChunk, IChunkLoadingError>)either2);
                } else {
                    this.field_219312_g.set(\u26036, CompletableFuture.completedFuture(either2));
                }
                ++\u26036;
            }
        }
        boolean bl = \u26034.func_219065_a(LocationType.BORDER);
        int \u26036 = \u26035.func_219065_a(LocationType.BORDER);
        this.field_219329_x |= \u26036;
        if (!bl && \u26036 != 0) {
            this.field_222983_h = chunkManager.func_222961_b(this);
            this.func_219284_a(this.field_222983_h);
        }
        if (bl && \u26036 == 0) {
            completableFuture = this.field_222983_h;
            this.field_222983_h = field_219309_d;
            this.func_219284_a((CompletableFuture<? extends Either<? extends IChunk, IChunkLoadingError>>)completableFuture.thenApply(either -> either.ifLeft(chunkManager::func_222973_a)));
        }
        boolean bl2 = \u26034.func_219065_a(LocationType.TICKING);
        \u2603 = \u26035.func_219065_a(LocationType.TICKING);
        if (!bl2 && \u2603) {
            this.field_219313_h = chunkManager.func_219179_a(this);
            this.func_219284_a(this.field_219313_h);
        }
        if (bl2 && !\u2603) {
            this.field_219313_h.complete(field_219308_c);
            this.field_219313_h = field_219309_d;
        }
        \u2603 = \u26034.func_219065_a(LocationType.ENTITY_TICKING);
        \u2603 = \u26035.func_219065_a(LocationType.ENTITY_TICKING);
        if (!\u2603 && \u2603) {
            if (this.field_219314_i != field_219309_d) {
                throw Util.func_229757_c_(new IllegalStateException());
            }
            this.field_219314_i = chunkManager.func_219188_b(this.field_219319_n);
            this.func_219284_a(this.field_219314_i);
        }
        if (\u2603 && !\u2603) {
            this.field_219314_i.complete(field_219308_c);
            this.field_219314_i = field_219309_d;
        }
        this.field_219327_v.func_219066_a(this.field_219319_n, this::func_219281_j, this.field_219317_l, this::func_219275_d);
        this.field_219316_k = this.field_219317_l;
    }

    public static ChunkStatus func_219278_b(int n) {
        if (n < 33) {
            return ChunkStatus.field_222617_m;
        }
        return ChunkStatus.func_222581_a(n - 33);
    }

    public static LocationType func_219286_c(int n) {
        return field_219311_f[MathHelper.func_76125_a(33 - n + 1, 0, field_219311_f.length - 1)];
    }

    public boolean func_219289_k() {
        return this.field_219329_x;
    }

    public void func_219303_l() {
        this.field_219329_x = ChunkHolder.func_219286_c(this.field_219317_l).func_219065_a(LocationType.BORDER);
    }

    public void func_219294_a(ChunkPrimerWrapper chunkPrimerWrapper2) {
        ChunkPrimerWrapper chunkPrimerWrapper2;
        for (int i = 0; i < this.field_219312_g.length(); ++i) {
            CompletableFuture<Either<IChunk, IChunkLoadingError>> completableFuture = this.field_219312_g.get(i);
            if (completableFuture == null || !(\u2603 = completableFuture.getNow(field_219306_a).left()).isPresent() || !(\u2603.get() instanceof ChunkPrimer)) continue;
            this.field_219312_g.set(i, CompletableFuture.completedFuture(Either.left((Object)chunkPrimerWrapper2)));
        }
        this.func_219284_a(CompletableFuture.completedFuture(Either.left((Object)chunkPrimerWrapper2.func_217336_u())));
    }

    public static interface IPlayerProvider {
        public Stream<ServerPlayerEntity> func_219097_a(ChunkPos var1, boolean var2);
    }

    public static interface IListener {
        public void func_219066_a(ChunkPos var1, IntSupplier var2, int var3, IntConsumer var4);
    }

    public static interface IChunkLoadingError {
        public static final IChunkLoadingError field_219055_b = new IChunkLoadingError(){

            public String toString() {
                return "UNLOADED";
            }
        };
    }

    public static enum LocationType {
        INACCESSIBLE,
        BORDER,
        TICKING,
        ENTITY_TICKING;


        public boolean func_219065_a(LocationType locationType) {
            return this.ordinal() >= locationType.ordinal();
        }
    }
}

