/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.storage;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.Dynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.JsonOps;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.TimerCallbackManager;
import net.minecraft.command.TimerCallbackSerializers;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.nbt.StringNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.SharedConstants;
import net.minecraft.util.Util;
import net.minecraft.util.datafix.DefaultTypeReferences;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.GameRules;
import net.minecraft.world.GameType;
import net.minecraft.world.WorldSettings;
import net.minecraft.world.WorldType;
import net.minecraft.world.dimension.DimensionType;

public class WorldInfo {
    private String field_186349_b;
    private int field_186350_c;
    private boolean field_186351_d;
    public static final Difficulty field_176156_a = Difficulty.NORMAL;
    private long field_76100_a;
    private WorldType field_76098_b = WorldType.field_77137_b;
    private CompoundNBT field_82576_c = new CompoundNBT();
    @Nullable
    private String field_211931_h;
    private int field_76099_c;
    private int field_76096_d;
    private int field_76097_e;
    private long field_82575_g;
    private long field_76094_f;
    private long field_76095_g;
    private long field_76107_h;
    @Nullable
    private final DataFixer field_209226_o;
    private final int field_209227_p;
    private boolean field_209228_q;
    private CompoundNBT field_76108_i;
    private String field_76106_k;
    private int field_76103_l;
    private int field_176157_p;
    private boolean field_76104_m;
    private int field_76101_n;
    private boolean field_76102_o;
    private int field_76114_p;
    private GameType field_76113_q;
    private boolean field_76112_r;
    private boolean field_76111_s;
    private boolean field_76110_t;
    private boolean field_76109_u;
    private Difficulty field_176158_z;
    private boolean field_176150_A;
    private double field_176151_B;
    private double field_176152_C;
    private double field_176146_D = 6.0E7;
    private long field_176147_E;
    private double field_176148_F;
    private double field_176149_G = 5.0;
    private double field_176153_H = 0.2;
    private int field_176154_I = 5;
    private int field_176155_J = 15;
    private final Set<String> field_197721_N = Sets.newHashSet();
    private final Set<String> field_197722_O = Sets.newLinkedHashSet();
    private final Map<DimensionType, CompoundNBT> field_186348_N = Maps.newIdentityHashMap();
    private CompoundNBT field_201358_Q;
    private int field_215766_V;
    private int field_215767_W;
    private UUID field_215768_X;
    private Set<String> field_230141_X_ = Sets.newLinkedHashSet();
    private boolean field_230142_Y_;
    private final GameRules field_82577_x = new GameRules();
    private final TimerCallbackManager<MinecraftServer> field_215769_Z = new TimerCallbackManager<MinecraftServer>(TimerCallbackSerializers.field_216342_a);

    protected WorldInfo() {
        this.field_209226_o = null;
        this.field_209227_p = SharedConstants.func_215069_a().getWorldVersion();
        this.func_212242_b(new CompoundNBT());
    }

    public WorldInfo(CompoundNBT compoundNBT3, DataFixer dataFixer, int n, @Nullable CompoundNBT compoundNBT2) {
        CompoundNBT compoundNBT3;
        this.field_209226_o = dataFixer;
        ListNBT listNBT = compoundNBT3.func_150295_c("ServerBrands", 8);
        for (int i = 0; i < listNBT.size(); ++i) {
            this.field_230141_X_.add(listNBT.func_150307_f(i));
        }
        this.field_230142_Y_ = compoundNBT3.func_74767_n("WasModded");
        if (compoundNBT3.func_150297_b("Version", 10)) {
            \u2603 = compoundNBT3.func_74775_l("Version");
            this.field_186349_b = \u2603.func_74779_i("Name");
            this.field_186350_c = \u2603.func_74762_e("Id");
            this.field_186351_d = \u2603.func_74767_n("Snapshot");
        }
        this.field_76100_a = compoundNBT3.func_74763_f("RandomSeed");
        if (compoundNBT3.func_150297_b("generatorName", 8)) {
            String string = compoundNBT3.func_74779_i("generatorName");
            this.field_76098_b = WorldType.func_77130_a(string);
            if (this.field_76098_b == null) {
                this.field_76098_b = WorldType.field_77137_b;
            } else if (this.field_76098_b == WorldType.field_180271_f) {
                this.field_211931_h = compoundNBT3.func_74779_i("generatorOptions");
            } else if (this.field_76098_b.func_77125_e()) {
                int n2 = 0;
                if (compoundNBT3.func_150297_b("generatorVersion", 99)) {
                    n2 = compoundNBT3.func_74762_e("generatorVersion");
                }
                this.field_76098_b = this.field_76098_b.func_77132_a(n2);
            }
            this.func_212242_b(compoundNBT3.func_74775_l("generatorOptions"));
        }
        this.field_76113_q = GameType.func_77146_a(compoundNBT3.func_74762_e("GameType"));
        if (compoundNBT3.func_150297_b("legacy_custom_options", 8)) {
            this.field_211931_h = compoundNBT3.func_74779_i("legacy_custom_options");
        }
        this.field_76112_r = compoundNBT3.func_150297_b("MapFeatures", 99) ? compoundNBT3.func_74767_n("MapFeatures") : true;
        this.field_76099_c = compoundNBT3.func_74762_e("SpawnX");
        this.field_76096_d = compoundNBT3.func_74762_e("SpawnY");
        this.field_76097_e = compoundNBT3.func_74762_e("SpawnZ");
        this.field_82575_g = compoundNBT3.func_74763_f("Time");
        this.field_76094_f = compoundNBT3.func_150297_b("DayTime", 99) ? compoundNBT3.func_74763_f("DayTime") : this.field_82575_g;
        this.field_76095_g = compoundNBT3.func_74763_f("LastPlayed");
        this.field_76107_h = compoundNBT3.func_74763_f("SizeOnDisk");
        this.field_76106_k = compoundNBT3.func_74779_i("LevelName");
        this.field_76103_l = compoundNBT3.func_74762_e("version");
        this.field_176157_p = compoundNBT3.func_74762_e("clearWeatherTime");
        this.field_76101_n = compoundNBT3.func_74762_e("rainTime");
        this.field_76104_m = compoundNBT3.func_74767_n("raining");
        this.field_76114_p = compoundNBT3.func_74762_e("thunderTime");
        this.field_76102_o = compoundNBT3.func_74767_n("thundering");
        this.field_76111_s = compoundNBT3.func_74767_n("hardcore");
        this.field_76109_u = compoundNBT3.func_150297_b("initialized", 99) ? compoundNBT3.func_74767_n("initialized") : true;
        this.field_76110_t = compoundNBT3.func_150297_b("allowCommands", 99) ? compoundNBT3.func_74767_n("allowCommands") : this.field_76113_q == GameType.CREATIVE;
        this.field_209227_p = n;
        if (compoundNBT2 != null) {
            this.field_76108_i = compoundNBT2;
        }
        if (compoundNBT3.func_150297_b("GameRules", 10)) {
            this.field_82577_x.func_82768_a(compoundNBT3.func_74775_l("GameRules"));
        }
        if (compoundNBT3.func_150297_b("Difficulty", 99)) {
            this.field_176158_z = Difficulty.func_151523_a(compoundNBT3.func_74771_c("Difficulty"));
        }
        if (compoundNBT3.func_150297_b("DifficultyLocked", 1)) {
            this.field_176150_A = compoundNBT3.func_74767_n("DifficultyLocked");
        }
        if (compoundNBT3.func_150297_b("BorderCenterX", 99)) {
            this.field_176151_B = compoundNBT3.func_74769_h("BorderCenterX");
        }
        if (compoundNBT3.func_150297_b("BorderCenterZ", 99)) {
            this.field_176152_C = compoundNBT3.func_74769_h("BorderCenterZ");
        }
        if (compoundNBT3.func_150297_b("BorderSize", 99)) {
            this.field_176146_D = compoundNBT3.func_74769_h("BorderSize");
        }
        if (compoundNBT3.func_150297_b("BorderSizeLerpTime", 99)) {
            this.field_176147_E = compoundNBT3.func_74763_f("BorderSizeLerpTime");
        }
        if (compoundNBT3.func_150297_b("BorderSizeLerpTarget", 99)) {
            this.field_176148_F = compoundNBT3.func_74769_h("BorderSizeLerpTarget");
        }
        if (compoundNBT3.func_150297_b("BorderSafeZone", 99)) {
            this.field_176149_G = compoundNBT3.func_74769_h("BorderSafeZone");
        }
        if (compoundNBT3.func_150297_b("BorderDamagePerBlock", 99)) {
            this.field_176153_H = compoundNBT3.func_74769_h("BorderDamagePerBlock");
        }
        if (compoundNBT3.func_150297_b("BorderWarningBlocks", 99)) {
            this.field_176154_I = compoundNBT3.func_74762_e("BorderWarningBlocks");
        }
        if (compoundNBT3.func_150297_b("BorderWarningTime", 99)) {
            this.field_176155_J = compoundNBT3.func_74762_e("BorderWarningTime");
        }
        if (compoundNBT3.func_150297_b("DimensionData", 10)) {
            \u2603 = compoundNBT3.func_74775_l("DimensionData");
            for (String string : \u2603.func_150296_c()) {
                this.field_186348_N.put(DimensionType.func_186069_a(Integer.parseInt(string)), \u2603.func_74775_l(string));
            }
        }
        if (compoundNBT3.func_150297_b("DataPacks", 10)) {
            CompoundNBT compoundNBT4;
            compoundNBT4 = compoundNBT3.func_74775_l("DataPacks");
            ListNBT listNBT2 = compoundNBT4.func_150295_c("Disabled", 8);
            for (int i = 0; i < listNBT2.size(); ++i) {
                this.field_197721_N.add(listNBT2.func_150307_f(i));
            }
            ListNBT \u26032 = compoundNBT4.func_150295_c("Enabled", 8);
            for (int i = 0; i < \u26032.size(); ++i) {
                this.field_197722_O.add(\u26032.func_150307_f(i));
            }
        }
        if (compoundNBT3.func_150297_b("CustomBossEvents", 10)) {
            this.field_201358_Q = compoundNBT3.func_74775_l("CustomBossEvents");
        }
        if (compoundNBT3.func_150297_b("ScheduledEvents", 9)) {
            this.field_215769_Z.func_216323_a(compoundNBT3.func_150295_c("ScheduledEvents", 10));
        }
        if (compoundNBT3.func_150297_b("WanderingTraderSpawnDelay", 99)) {
            this.field_215766_V = compoundNBT3.func_74762_e("WanderingTraderSpawnDelay");
        }
        if (compoundNBT3.func_150297_b("WanderingTraderSpawnChance", 99)) {
            this.field_215767_W = compoundNBT3.func_74762_e("WanderingTraderSpawnChance");
        }
        if (compoundNBT3.func_150297_b("WanderingTraderId", 8)) {
            this.field_215768_X = UUID.fromString(compoundNBT3.func_74779_i("WanderingTraderId"));
        }
    }

    public WorldInfo(WorldSettings worldSettings, String string) {
        this.field_209226_o = null;
        this.field_209227_p = SharedConstants.func_215069_a().getWorldVersion();
        this.func_176127_a(worldSettings);
        this.field_76106_k = string;
        this.field_176158_z = field_176156_a;
        this.field_76109_u = false;
    }

    public void func_176127_a(WorldSettings worldSettings) {
        this.field_76100_a = worldSettings.func_77160_d();
        this.field_76113_q = worldSettings.func_77162_e();
        this.field_76112_r = worldSettings.func_77164_g();
        this.field_76111_s = worldSettings.func_77158_f();
        this.field_76098_b = worldSettings.func_77165_h();
        this.func_212242_b((CompoundNBT)Dynamic.convert((DynamicOps)JsonOps.INSTANCE, (DynamicOps)NBTDynamicOps.field_210820_a, (Object)worldSettings.func_205391_j()));
        this.field_76110_t = worldSettings.func_77163_i();
    }

    public CompoundNBT func_76082_a(@Nullable CompoundNBT compoundNBT) {
        this.func_209225_Q();
        if (compoundNBT == null) {
            compoundNBT = this.field_76108_i;
        }
        \u2603 = new CompoundNBT();
        this.func_76064_a(\u2603, compoundNBT);
        return \u2603;
    }

    private void func_76064_a(CompoundNBT compoundNBT4, CompoundNBT compoundNBT2) {
        ListNBT listNBT = new ListNBT();
        this.field_230141_X_.stream().map(StringNBT::func_229705_a_).forEach(listNBT::add);
        compoundNBT4.func_218657_a("ServerBrands", listNBT);
        compoundNBT4.func_74757_a("WasModded", this.field_230142_Y_);
        CompoundNBT \u26032 = new CompoundNBT();
        \u26032.func_74778_a("Name", SharedConstants.func_215069_a().getName());
        \u26032.func_74768_a("Id", SharedConstants.func_215069_a().getWorldVersion());
        \u26032.func_74757_a("Snapshot", !SharedConstants.func_215069_a().isStable());
        compoundNBT4.func_218657_a("Version", \u26032);
        compoundNBT4.func_74768_a("DataVersion", SharedConstants.func_215069_a().getWorldVersion());
        compoundNBT4.func_74772_a("RandomSeed", this.field_76100_a);
        compoundNBT4.func_74778_a("generatorName", this.field_76098_b.func_211889_b());
        compoundNBT4.func_74768_a("generatorVersion", this.field_76098_b.func_77131_c());
        if (!this.field_82576_c.isEmpty()) {
            compoundNBT4.func_218657_a("generatorOptions", this.field_82576_c);
        }
        if (this.field_211931_h != null) {
            compoundNBT4.func_74778_a("legacy_custom_options", this.field_211931_h);
        }
        compoundNBT4.func_74768_a("GameType", this.field_76113_q.func_77148_a());
        compoundNBT4.func_74757_a("MapFeatures", this.field_76112_r);
        compoundNBT4.func_74768_a("SpawnX", this.field_76099_c);
        compoundNBT4.func_74768_a("SpawnY", this.field_76096_d);
        compoundNBT4.func_74768_a("SpawnZ", this.field_76097_e);
        compoundNBT4.func_74772_a("Time", this.field_82575_g);
        compoundNBT4.func_74772_a("DayTime", this.field_76094_f);
        compoundNBT4.func_74772_a("SizeOnDisk", this.field_76107_h);
        compoundNBT4.func_74772_a("LastPlayed", Util.func_211179_d());
        compoundNBT4.func_74778_a("LevelName", this.field_76106_k);
        compoundNBT4.func_74768_a("version", this.field_76103_l);
        compoundNBT4.func_74768_a("clearWeatherTime", this.field_176157_p);
        compoundNBT4.func_74768_a("rainTime", this.field_76101_n);
        compoundNBT4.func_74757_a("raining", this.field_76104_m);
        compoundNBT4.func_74768_a("thunderTime", this.field_76114_p);
        compoundNBT4.func_74757_a("thundering", this.field_76102_o);
        compoundNBT4.func_74757_a("hardcore", this.field_76111_s);
        compoundNBT4.func_74757_a("allowCommands", this.field_76110_t);
        compoundNBT4.func_74757_a("initialized", this.field_76109_u);
        compoundNBT4.func_74780_a("BorderCenterX", this.field_176151_B);
        compoundNBT4.func_74780_a("BorderCenterZ", this.field_176152_C);
        compoundNBT4.func_74780_a("BorderSize", this.field_176146_D);
        compoundNBT4.func_74772_a("BorderSizeLerpTime", this.field_176147_E);
        compoundNBT4.func_74780_a("BorderSafeZone", this.field_176149_G);
        compoundNBT4.func_74780_a("BorderDamagePerBlock", this.field_176153_H);
        compoundNBT4.func_74780_a("BorderSizeLerpTarget", this.field_176148_F);
        compoundNBT4.func_74780_a("BorderWarningBlocks", this.field_176154_I);
        compoundNBT4.func_74780_a("BorderWarningTime", this.field_176155_J);
        if (this.field_176158_z != null) {
            compoundNBT4.func_74774_a("Difficulty", (byte)this.field_176158_z.func_151525_a());
        }
        compoundNBT4.func_74757_a("DifficultyLocked", this.field_176150_A);
        compoundNBT4.func_218657_a("GameRules", this.field_82577_x.func_82770_a());
        CompoundNBT \u26033 = new CompoundNBT();
        for (Map.Entry<DimensionType, CompoundNBT> entry : this.field_186348_N.entrySet()) {
            \u26033.func_218657_a(String.valueOf(entry.getKey().func_186068_a()), entry.getValue());
        }
        compoundNBT4.func_218657_a("DimensionData", \u26033);
        if (compoundNBT2 != null) {
            compoundNBT4.func_218657_a("Player", compoundNBT2);
        }
        CompoundNBT compoundNBT3 = new CompoundNBT();
        ListNBT listNBT2 = new ListNBT();
        for (String string : this.field_197722_O) {
            listNBT2.add(StringNBT.func_229705_a_(string));
        }
        compoundNBT3.func_218657_a("Enabled", listNBT2);
        ListNBT \u26035 = new ListNBT();
        for (String string : this.field_197721_N) {
            \u26035.add(StringNBT.func_229705_a_(string));
        }
        compoundNBT3.func_218657_a("Disabled", \u26035);
        compoundNBT4.func_218657_a("DataPacks", compoundNBT3);
        if (this.field_201358_Q != null) {
            compoundNBT4.func_218657_a("CustomBossEvents", this.field_201358_Q);
        }
        compoundNBT4.func_218657_a("ScheduledEvents", this.field_215769_Z.func_216327_b());
        compoundNBT4.func_74768_a("WanderingTraderSpawnDelay", this.field_215766_V);
        compoundNBT4.func_74768_a("WanderingTraderSpawnChance", this.field_215767_W);
        if (this.field_215768_X != null) {
            compoundNBT4.func_74778_a("WanderingTraderId", this.field_215768_X.toString());
        }
    }

    public long func_76063_b() {
        return this.field_76100_a;
    }

    public static long func_227498_c_(long l) {
        return Hashing.sha256().hashLong(l).asLong();
    }

    public int func_76079_c() {
        return this.field_76099_c;
    }

    public int func_76075_d() {
        return this.field_76096_d;
    }

    public int func_76074_e() {
        return this.field_76097_e;
    }

    public long func_82573_f() {
        return this.field_82575_g;
    }

    public long func_76073_f() {
        return this.field_76094_f;
    }

    private void func_209225_Q() {
        if (this.field_209228_q || this.field_76108_i == null) {
            return;
        }
        if (this.field_209227_p < SharedConstants.func_215069_a().getWorldVersion()) {
            if (this.field_209226_o == null) {
                throw Util.func_229757_c_(new NullPointerException("Fixer Upper not set inside LevelData, and the player tag is not upgraded."));
            }
            this.field_76108_i = NBTUtil.func_210822_a(this.field_209226_o, DefaultTypeReferences.PLAYER, this.field_76108_i, this.field_209227_p);
        }
        this.field_209228_q = true;
    }

    public CompoundNBT func_76072_h() {
        this.func_209225_Q();
        return this.field_76108_i;
    }

    public void func_76058_a(int n) {
        this.field_76099_c = n;
    }

    public void func_76056_b(int n) {
        this.field_76096_d = n;
    }

    public void func_76087_c(int n) {
        this.field_76097_e = n;
    }

    public void func_82572_b(long l) {
        this.field_82575_g = l;
    }

    public void func_76068_b(long l) {
        this.field_76094_f = l;
    }

    public void func_176143_a(BlockPos blockPos) {
        this.field_76099_c = blockPos.func_177958_n();
        this.field_76096_d = blockPos.func_177956_o();
        this.field_76097_e = blockPos.func_177952_p();
    }

    public String func_76065_j() {
        return this.field_76106_k;
    }

    public void func_76062_a(String string) {
        this.field_76106_k = string;
    }

    public int func_76088_k() {
        return this.field_76103_l;
    }

    public void func_76078_e(int n) {
        this.field_76103_l = n;
    }

    public long func_76057_l() {
        return this.field_76095_g;
    }

    public int func_176133_A() {
        return this.field_176157_p;
    }

    public void func_176142_i(int n) {
        this.field_176157_p = n;
    }

    public boolean func_76061_m() {
        return this.field_76102_o;
    }

    public void func_76069_a(boolean bl) {
        this.field_76102_o = bl;
    }

    public int func_76071_n() {
        return this.field_76114_p;
    }

    public void func_76090_f(int n) {
        this.field_76114_p = n;
    }

    public boolean func_76059_o() {
        return this.field_76104_m;
    }

    public void func_76084_b(boolean bl) {
        this.field_76104_m = bl;
    }

    public int func_76083_p() {
        return this.field_76101_n;
    }

    public void func_76080_g(int n) {
        this.field_76101_n = n;
    }

    public GameType func_76077_q() {
        return this.field_76113_q;
    }

    public boolean func_76089_r() {
        return this.field_76112_r;
    }

    public void func_176128_f(boolean bl) {
        this.field_76112_r = bl;
    }

    public void func_76060_a(GameType gameType) {
        this.field_76113_q = gameType;
    }

    public boolean func_76093_s() {
        return this.field_76111_s;
    }

    public void func_176119_g(boolean bl) {
        this.field_76111_s = bl;
    }

    public WorldType func_76067_t() {
        return this.field_76098_b;
    }

    public void func_76085_a(WorldType worldType) {
        this.field_76098_b = worldType;
    }

    public CompoundNBT func_211027_A() {
        return this.field_82576_c;
    }

    public void func_212242_b(CompoundNBT compoundNBT) {
        this.field_82576_c = compoundNBT;
    }

    public boolean func_76086_u() {
        return this.field_76110_t;
    }

    public void func_176121_c(boolean bl) {
        this.field_76110_t = bl;
    }

    public boolean func_76070_v() {
        return this.field_76109_u;
    }

    public void func_76091_d(boolean bl) {
        this.field_76109_u = bl;
    }

    public GameRules func_82574_x() {
        return this.field_82577_x;
    }

    public double func_176120_C() {
        return this.field_176151_B;
    }

    public double func_176126_D() {
        return this.field_176152_C;
    }

    public double func_176137_E() {
        return this.field_176146_D;
    }

    public void func_176145_a(double d) {
        this.field_176146_D = d;
    }

    public long func_176134_F() {
        return this.field_176147_E;
    }

    public void func_176135_e(long l) {
        this.field_176147_E = l;
    }

    public double func_176132_G() {
        return this.field_176148_F;
    }

    public void func_176118_b(double d) {
        this.field_176148_F = d;
    }

    public void func_176141_c(double d) {
        this.field_176152_C = d;
    }

    public void func_176124_d(double d) {
        this.field_176151_B = d;
    }

    public double func_176138_H() {
        return this.field_176149_G;
    }

    public void func_176129_e(double d) {
        this.field_176149_G = d;
    }

    public double func_176140_I() {
        return this.field_176153_H;
    }

    public void func_176125_f(double d) {
        this.field_176153_H = d;
    }

    public int func_176131_J() {
        return this.field_176154_I;
    }

    public int func_176139_K() {
        return this.field_176155_J;
    }

    public void func_176122_j(int n) {
        this.field_176154_I = n;
    }

    public void func_176136_k(int n) {
        this.field_176155_J = n;
    }

    public Difficulty func_176130_y() {
        return this.field_176158_z;
    }

    public void func_176144_a(Difficulty difficulty) {
        this.field_176158_z = difficulty;
    }

    public boolean func_176123_z() {
        return this.field_176150_A;
    }

    public void func_180783_e(boolean bl) {
        this.field_176150_A = bl;
    }

    public TimerCallbackManager<MinecraftServer> func_215763_z() {
        return this.field_215769_Z;
    }

    public void func_85118_a(CrashReportCategory crashReportCategory) {
        crashReportCategory.func_189529_a("Level name", () -> this.field_76106_k);
        crashReportCategory.func_189529_a("Level seed", () -> String.valueOf(this.field_76100_a));
        crashReportCategory.func_189529_a("Level generator", () -> String.format("ID %02d - %s, ver %d. Features enabled: %b", this.field_76098_b.func_82747_f(), this.field_76098_b.func_211888_a(), this.field_76098_b.func_77131_c(), this.field_76112_r));
        crashReportCategory.func_189529_a("Level generator options", () -> this.field_82576_c.toString());
        crashReportCategory.func_189529_a("Level spawn location", () -> CrashReportCategory.func_184876_a(this.field_76099_c, this.field_76096_d, this.field_76097_e));
        crashReportCategory.func_189529_a("Level time", () -> String.format("%d game time, %d day time", this.field_82575_g, this.field_76094_f));
        crashReportCategory.func_189529_a("Known server brands", () -> String.join((CharSequence)", ", this.field_230141_X_));
        crashReportCategory.func_189529_a("Level was modded", () -> Boolean.toString(this.field_230142_Y_));
        crashReportCategory.func_189529_a("Level storage version", () -> {
            String string = "Unknown?";
            try {
                switch (this.field_76103_l) {
                    case 19133: {
                        string = "Anvil";
                        break;
                    }
                    case 19132: {
                        string = "McRegion";
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return String.format("0x%05X - %s", this.field_76103_l, string);
        });
        crashReportCategory.func_189529_a("Level weather", () -> String.format("Rain time: %d (now: %b), thunder time: %d (now: %b)", this.field_76101_n, this.field_76104_m, this.field_76114_p, this.field_76102_o));
        crashReportCategory.func_189529_a("Level game mode", () -> String.format("Game mode: %s (ID %d). Hardcore: %b. Cheats: %b", this.field_76113_q.func_77149_b(), this.field_76113_q.func_77148_a(), this.field_76111_s, this.field_76110_t));
    }

    public CompoundNBT func_186347_a(DimensionType dimensionType) {
        CompoundNBT compoundNBT = this.field_186348_N.get(dimensionType);
        if (compoundNBT == null) {
            return new CompoundNBT();
        }
        return compoundNBT;
    }

    public void func_186345_a(DimensionType dimensionType, CompoundNBT compoundNBT) {
        this.field_186348_N.put(dimensionType, compoundNBT);
    }

    public int func_186344_K() {
        return this.field_186350_c;
    }

    public boolean func_186343_L() {
        return this.field_186351_d;
    }

    public String func_186346_M() {
        return this.field_186349_b;
    }

    public Set<String> func_197719_N() {
        return this.field_197721_N;
    }

    public Set<String> func_197720_O() {
        return this.field_197722_O;
    }

    @Nullable
    public CompoundNBT func_201357_P() {
        return this.field_201358_Q;
    }

    public void func_201356_c(@Nullable CompoundNBT compoundNBT) {
        this.field_201358_Q = compoundNBT;
    }

    public int func_215765_R() {
        return this.field_215766_V;
    }

    public void func_215764_j(int n) {
        this.field_215766_V = n;
    }

    public int func_215760_S() {
        return this.field_215767_W;
    }

    public void func_215762_k(int n) {
        this.field_215767_W = n;
    }

    public void func_215761_a(UUID uUID) {
        this.field_215768_X = uUID;
    }

    public void func_230145_a_(String string, boolean bl) {
        this.field_230141_X_.add(string);
        this.field_230142_Y_ |= bl;
    }
}

