/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;

public final class ItemTextureQuadConverter {
    private ItemTextureQuadConverter() {
    }

    public static List<UnpackedBakedQuad> convertTexture(bmu format, TRSRTransformation transform, bmi template, bmi sprite, float z, cq facing, int color) {
        List<UnpackedBakedQuad> horizontal = ItemTextureQuadConverter.convertTextureHorizontal(format, transform, template, sprite, z, facing, color);
        List<UnpackedBakedQuad> vertical = ItemTextureQuadConverter.convertTextureVertical(format, transform, template, sprite, z, facing, color);
        return horizontal.size() >= vertical.size() ? horizontal : vertical;
    }

    public static List<UnpackedBakedQuad> convertTextureHorizontal(bmu format, TRSRTransformation transform, bmi template, bmi sprite, float z, cq facing, int color) {
        int w = template.c();
        int h = template.d();
        int[] data = template.a(0)[0];
        ArrayList quads = Lists.newArrayList();
        int start = -1;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pixel = data[y * w + x];
                if (start < 0 && ItemTextureQuadConverter.isVisible(pixel)) {
                    start = x;
                }
                if (start < 0 || ItemTextureQuadConverter.isVisible(pixel)) continue;
                int endY = y + 1;
                boolean sameRow = true;
                while (sameRow) {
                    for (int i = 0; i < w; ++i) {
                        int px1 = data[y * w + i];
                        int px2 = data[endY * w + i];
                        if (ItemTextureQuadConverter.isVisible(px1) == ItemTextureQuadConverter.isVisible(px2)) continue;
                        sameRow = false;
                        break;
                    }
                    if (!sameRow) continue;
                    ++endY;
                }
                quads.add(ItemTextureQuadConverter.genQuad(format, transform, start, y, x, endY, z, sprite, facing, color));
                if (endY - y > 1) {
                    y = endY - 1;
                }
                start = -1;
            }
        }
        return quads;
    }

    public static List<UnpackedBakedQuad> convertTextureVertical(bmu format, TRSRTransformation transform, bmi template, bmi sprite, float z, cq facing, int color) {
        int w = template.c();
        int h = template.d();
        int[] data = template.a(0)[0];
        ArrayList quads = Lists.newArrayList();
        int start = -1;
        for (int x = 0; x < w; ++x) {
            for (int y = 0; y < h; ++y) {
                int pixel = data[y * w + x];
                if (start < 0 && ItemTextureQuadConverter.isVisible(pixel)) {
                    start = y;
                }
                if (start < 0 || ItemTextureQuadConverter.isVisible(pixel)) continue;
                int endX = x + 1;
                boolean sameColumn = true;
                while (sameColumn) {
                    for (int i = 0; i < h; ++i) {
                        int px1 = data[i * w + x];
                        int px2 = data[i * w + endX];
                        if (ItemTextureQuadConverter.isVisible(px1) == ItemTextureQuadConverter.isVisible(px2)) continue;
                        sameColumn = false;
                        break;
                    }
                    if (!sameColumn) continue;
                    ++endX;
                }
                quads.add(ItemTextureQuadConverter.genQuad(format, transform, x, start, endX, y, z, sprite, facing, color));
                if (endX - x > 1) {
                    x = endX - 1;
                }
                start = -1;
            }
        }
        return quads;
    }

    private static boolean isVisible(int color) {
        return (color >> 24 & 0xFF) > 0;
    }

    public static UnpackedBakedQuad genQuad(bmu format, TRSRTransformation transform, float x1, float y1, float x2, float y2, float z, bmi sprite, cq facing, int color) {
        float u1 = sprite.a((double)x1);
        float v1 = sprite.b((double)y1);
        float u2 = sprite.a((double)x2);
        float v2 = sprite.b((double)y2);
        float tmp = y1 /= 16.0f;
        y1 = 1.0f - (y2 /= 16.0f);
        y2 = 1.0f - tmp;
        return ItemTextureQuadConverter.putQuad(format, transform, facing, color, x1 /= 16.0f, y1, x2 /= 16.0f, y2, z, u1, v1, u2, v2);
    }

    private static UnpackedBakedQuad putQuad(bmu format, TRSRTransformation transform, cq side, int color, float x1, float y1, float x2, float y2, float z, float u1, float v1, float u2, float v2) {
        side = side.d();
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(format);
        builder.setQuadTint(-1);
        builder.setQuadOrientation(side);
        builder.setQuadColored();
        if (side == cq.c) {
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y1, z, u1, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y1, z, u2, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y2, z, u2, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y2, z, u1, v1, color);
        } else {
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y1, z, u1, v2, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x1, y2, z, u1, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y2, z, u2, v1, color);
            ItemTextureQuadConverter.putVertex(builder, format, transform, side, x2, y1, z, u2, v2, color);
        }
        return builder.build();
    }

    private static void putVertex(UnpackedBakedQuad.Builder builder, bmu format, TRSRTransformation transform, cq side, float x, float y, float z, float u, float v, int color) {
        Vector4f vec = new Vector4f();
        block6: for (int e = 0; e < format.i(); ++e) {
            switch (format.c(e).b()) {
                case a: {
                    if (transform == TRSRTransformation.identity()) {
                        builder.put(e, x, y, z, 1.0f);
                        continue block6;
                    }
                    vec.x = x;
                    vec.y = y;
                    vec.z = z;
                    vec.w = 1.0f;
                    transform.getMatrix().transform((Tuple4f)vec);
                    builder.put(e, vec.x, vec.y, vec.z, vec.w);
                    continue block6;
                }
                case c: {
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g2 = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b2 = (float)(color >> 0 & 0xFF) / 255.0f;
                    float a2 = (float)(color >> 24 & 0xFF) / 255.0f;
                    builder.put(e, r, g2, b2, a2);
                    continue block6;
                }
                case d: {
                    if (format.c(e).d() == 0) {
                        builder.put(e, u, v, 0.0f, 1.0f);
                        continue block6;
                    }
                }
                case b: {
                    builder.put(e, side.g(), side.h(), side.i(), 0.0f);
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }
}

