/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Quat4f;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartItemModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.Pair;

public class ModelDynBucket
implements IModel,
IModelCustomData,
IRetexturableModel {
    public static final bov LOCATION = new bov(new jy("forge", "dynbucket"), "inventory");
    private static final float NORTH_Z_BASE = 0.4685f;
    private static final float SOUTH_Z_BASE = 0.5315f;
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final IModel MODEL = new ModelDynBucket();
    protected final jy baseLocation;
    protected final jy liquidLocation;
    protected final jy coverLocation;
    protected final Fluid fluid;
    protected final boolean flipGas;

    public ModelDynBucket() {
        this(null, null, null, FluidRegistry.WATER, false);
    }

    public ModelDynBucket(jy baseLocation, jy liquidLocation, jy coverLocation, Fluid fluid, boolean flipGas) {
        this.baseLocation = baseLocation;
        this.liquidLocation = liquidLocation;
        this.coverLocation = coverLocation;
        this.fluid = fluid;
        this.flipGas = flipGas;
    }

    @Override
    public Collection<jy> getDependencies() {
        return ImmutableList.of();
    }

    @Override
    public Collection<jy> getTextures() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        if (this.baseLocation != null) {
            builder.add((Object)this.baseLocation);
        }
        if (this.liquidLocation != null) {
            builder.add((Object)this.liquidLocation);
        }
        if (this.coverLocation != null) {
            builder.add((Object)this.coverLocation);
        }
        return builder.build();
    }

    @Override
    public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
        ImmutableMap<bgr.b, TRSRTransformation> transformMap = IPerspectiveAwareModel.MapWrapper.getTransforms(state);
        if (this.flipGas && this.fluid.isGaseous()) {
            state = new ModelStateComposition(state, TRSRTransformation.blockCenterToCorner(new TRSRTransformation(null, new Quat4f(0.0f, 0.0f, 1.0f, 0.0f), null, null)));
        }
        TRSRTransformation transform = (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity());
        bmi fluidSprite = (bmi)bakedTextureGetter.apply((Object)this.fluid.getStill());
        ImmutableList.Builder builder = ImmutableList.builder();
        if (this.baseLocation != null) {
            IFlexibleBakedModel model = new ItemLayerModel((ImmutableList<jy>)ImmutableList.of((Object)this.baseLocation)).bake(state, format, bakedTextureGetter);
            builder.addAll((Iterable)model.a());
        }
        if (this.liquidLocation != null) {
            bmi liquid = (bmi)bakedTextureGetter.apply((Object)this.liquidLocation);
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.468625f, cq.c, this.fluid.getColor()));
            builder.addAll(ItemTextureQuadConverter.convertTexture(format, transform, liquid, fluidSprite, 0.531375f, cq.d, this.fluid.getColor()));
        }
        if (this.coverLocation != null) {
            bmi base = (bmi)bakedTextureGetter.apply((Object)this.coverLocation);
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.4685f, base, cq.c, -1));
            builder.add((Object)ItemTextureQuadConverter.genQuad(format, transform, 0.0f, 0.0f, 16.0f, 16.0f, 0.5315f, base, cq.d, -1));
        }
        return new BakedDynBucket(this, (ImmutableList<bgg>)builder.build(), fluidSprite, format, (ImmutableMap<bgr.b, TRSRTransformation>)Maps.immutableEnumMap(transformMap), Maps.newHashMap());
    }

    @Override
    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    @Override
    public IModel process(ImmutableMap<String, String> customData) {
        String fluidName = (String)customData.get((Object)"fluid");
        Fluid fluid = FluidRegistry.getFluid(fluidName);
        if (fluid == null) {
            fluid = this.fluid;
        }
        boolean flip = this.flipGas;
        if (customData.containsKey((Object)"flipGas")) {
            String flipStr = (String)customData.get((Object)"flipGas");
            if (flipStr.equals("true")) {
                flip = true;
            } else if (flipStr.equals("false")) {
                flip = false;
            } else {
                throw new IllegalArgumentException(String.format("DynBucket custom data \"flipGas\" must have value 'true' or 'false' (was '%s')", flipStr));
            }
        }
        return new ModelDynBucket(this.baseLocation, this.liquidLocation, this.coverLocation, fluid, flip);
    }

    @Override
    public IModel retexture(ImmutableMap<String, String> textures) {
        jy base = this.baseLocation;
        jy liquid = this.liquidLocation;
        jy cover = this.coverLocation;
        if (textures.containsKey((Object)"base")) {
            base = new jy((String)textures.get((Object)"base"));
        }
        if (textures.containsKey((Object)"fluid")) {
            liquid = new jy((String)textures.get((Object)"fluid"));
        }
        if (textures.containsKey((Object)"cover")) {
            cover = new jy((String)textures.get((Object)"cover"));
        }
        return new ModelDynBucket(base, liquid, cover, this.fluid, this.flipGas);
    }

    protected static class BakedDynBucket
    extends ItemLayerModel.BakedModel
    implements ISmartItemModel,
    IPerspectiveAwareModel {
        private final ModelDynBucket parent;
        private final Map<String, IFlexibleBakedModel> cache;
        private final ImmutableMap<bgr.b, TRSRTransformation> transforms;

        public BakedDynBucket(ModelDynBucket parent, ImmutableList<bgg> quads, bmi particle, bmu format, ImmutableMap<bgr.b, TRSRTransformation> transforms, Map<String, IFlexibleBakedModel> cache) {
            super(quads, particle, format);
            this.parent = parent;
            this.transforms = transforms;
            this.cache = cache;
        }

        @Override
        public boq handleItemState(zx stack) {
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem(stack);
            if (fluidStack == null && stack.b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)stack.b()).getFluid(stack);
            }
            if (fluidStack == null) {
                return this;
            }
            Fluid fluid = fluidStack.getFluid();
            String name = fluid.getName();
            if (!this.cache.containsKey(name)) {
                IModel model = this.parent.process((ImmutableMap<String, String>)ImmutableMap.of((Object)"fluid", (Object)name));
                Function<jy, bmi> textureGetter = new Function<jy, bmi>(){

                    public bmi apply(jy location) {
                        return ave.A().T().a(location.toString());
                    }
                };
                IFlexibleBakedModel bakedModel = model.bake(new SimpleModelState(this.transforms), this.getFormat(), textureGetter);
                this.cache.put(name, bakedModel);
                return bakedModel;
            }
            return this.cache.get(name);
        }

        @Override
        public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(bgr.b cameraTransformType) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IFlexibleBakedModel)this, this.transforms, cameraTransformType);
        }
    }

    public static enum LoaderDynBucket implements ICustomModelLoader
    {
        instance;


        @Override
        public boolean accepts(jy modelLocation) {
            return modelLocation.b().equals("forge") && modelLocation.a().contains("forgebucket");
        }

        @Override
        public IModel loadModel(jy modelLocation) throws IOException {
            return MODEL;
        }

        public void a(bni resourceManager) {
        }
    }
}

