/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartBlockModel;
import net.minecraftforge.client.model.ISmartVariant;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.MapModelState;
import net.minecraftforge.client.model.ModelDynBucket;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.RegistryDelegate;
import org.apache.commons.lang3.tuple.Pair;

public class ModelLoader
extends bot {
    private final Map<bov, IModel> stateModels = new HashMap<bov, IModel>();
    private final Set<jy> textures = new HashSet<jy>();
    private final Set<jy> loadingModels = new HashSet<jy>();
    private final Set<bov> missingVariants = Sets.newHashSet();
    private IModel missingModel = null;
    private IModel itemModel = new ItemLayerModel(o);
    private boolean isLoading = false;
    private static final Map<RegistryDelegate<afh>, bgy> customStateMappers = Maps.newHashMap();
    private static final Map<RegistryDelegate<zw>, bfp> customMeshDefinitions = Maps.newHashMap();
    private static final Map<Pair<RegistryDelegate<zw>, Integer>, bov> customModels = Maps.newHashMap();

    public boolean isLoading() {
        return this.isLoading;
    }

    public ModelLoader(bni manager, bmh map, bgc shapes) {
        super(manager, map, shapes);
        VanillaLoader.instance.setLoader(this);
        ModelLoaderRegistry.clearModelCache();
    }

    public db<bov, boq> a() {
        this.isLoading = true;
        this.loadBlocks();
        this.loadItems();
        try {
            this.missingModel = this.getModel(new jy(a.b(), a.a()));
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        this.stateModels.put(a, this.missingModel);
        this.textures.remove(bmh.f);
        this.textures.addAll(b);
        this.j.a(this.f, new bmb(){

            public void a(bmh map) {
                for (jy t : ModelLoader.this.textures) {
                    map.a(t);
                }
            }
        });
        Function<jy, bmi> textureGetter = new Function<jy, bmi>(){

            public bmi apply(jy location) {
                return ave.A().T().a(location.toString());
            }
        };
        IFlexibleBakedModel missingBaked = this.missingModel.bake(this.missingModel.getDefaultState(), bms.b, textureGetter);
        for (Map.Entry<bov, IModel> e : this.stateModels.entrySet()) {
            if (e.getValue() == this.getMissingModel()) {
                this.n.a((Object)e.getKey(), (Object)missingBaked);
                continue;
            }
            this.n.a((Object)e.getKey(), (Object)e.getValue().bake(e.getValue().getDefaultState(), bms.b, textureGetter));
        }
        return this.n;
    }

    private void loadBlocks() {
        Map stateMap = this.k.a().a();
        ArrayList variants = Lists.newArrayList(stateMap.values());
        variants.add(new bov("minecraft:item_frame", "normal"));
        variants.add(new bov("minecraft:item_frame", "map"));
        this.a(variants);
    }

    protected void a(bgm definition, bov location) {
        bgm.d variants = null;
        try {
            variants = definition.b(location.c());
        }
        catch (bgm.b e) {
            this.missingVariants.add(location);
        }
        if (variants != null && !variants.b().isEmpty()) {
            try {
                this.stateModels.put(location, new WeightedRandomModel(location, variants));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadItems() {
        this.e();
        for (zw item : GameData.getItemRegistry().typeSafeIterable()) {
            for (String s : this.a(item)) {
                jy file = this.a(s);
                bov memory = ModelLoader.getInventoryVariant(s);
                IModel model = null;
                try {
                    model = this.getModel(file);
                }
                catch (IOException iOException) {}
                continue;
                finally {
                    if (model == null || model == this.getMissingModel()) {
                        FMLLog.fine("Item json isn't found for '" + memory + "', trying to load the variant from the blockstate json", new Object[0]);
                        this.a(this.a((jy)memory), memory);
                        continue;
                    }
                    this.stateModels.put(memory, model);
                }
            }
        }
        if (ForgeModContainer.replaceVanillaBucketModel) {
            IModel model2;
            bov memory;
            if (!this.stateModels.containsKey(ModelDynBucket.LOCATION)) {
                bov memory2 = ModelLoader.getInventoryVariant("forge:dynbucket");
                this.a(this.a((jy)memory2), memory2);
            }
            for (String s : this.a(zy.aw)) {
                memory = ModelLoader.getInventoryVariant(s);
                try {
                    model2 = this.getModel(new jy("forge", "item/bucket"));
                    this.stateModels.put(memory, model2);
                }
                catch (IOException model2) {}
            }
            this.setBucketModel(zy.ax);
            this.setBucketModel(zy.ay);
            if (FluidRegistry.isFluidRegistered("milk")) {
                Fluid milk = FluidRegistry.getFluid("milk");
                FluidStack milkStack = new FluidStack(milk, 1000);
                if (FluidContainerRegistry.getContainerCapacity(milkStack, new zx(zy.aw)) == 1000) {
                    this.setBucketModel(zy.aG);
                }
            } else {
                for (String s : this.a(zy.aG)) {
                    memory = ModelLoader.getInventoryVariant(s);
                    try {
                        model2 = this.getModel(new jy("forge", "item/bucket_milk"));
                        this.stateModels.put(memory, model2);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void setBucketModel(zw item) {
        for (String s : this.a(item)) {
            bov memory = ModelLoader.getInventoryVariant(s);
            IModel model = this.stateModels.get(ModelDynBucket.LOCATION);
            if (model == null) continue;
            this.stateModels.put(memory, model);
        }
    }

    public static bov getInventoryVariant(String s) {
        if (s.contains("#")) {
            return new bov(s);
        }
        return new bov(s, "inventory");
    }

    public IModel getModel(jy location) throws IOException {
        if (!ModelLoaderRegistry.loaded(location)) {
            this.loadAnyModel(location);
        }
        return ModelLoaderRegistry.getModel(location);
    }

    protected jy d(jy model) {
        return new jy(model.b(), model.a() + ".json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAnyModel(jy location) throws IOException {
        if (this.loadingModels.contains(location)) {
            throw new IllegalStateException("circular model dependencies involving model " + location);
        }
        this.loadingModels.add(location);
        try {
            IModel model = ModelLoaderRegistry.getModel(location);
            this.resolveDependencies(model);
        }
        finally {
            this.loadingModels.remove(location);
        }
    }

    private void resolveDependencies(IModel model) throws IOException {
        for (jy dep : model.getDependencies()) {
            if (dep instanceof bov) {
                this.a((Collection)ImmutableList.of((Object)((bov)dep)));
                continue;
            }
            this.getModel(dep);
        }
        this.textures.addAll(model.getTextures());
    }

    private boolean isBuiltinModel(bgl model) {
        return model == o || model == p || model == q || model == r;
    }

    public IModel getMissingModel() {
        if (this.missingModel == null) {
            try {
                this.missingModel = this.getModel(new jy(a.b(), a.a()));
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return this.missingModel;
    }

    public IModel getItemModel() {
        return this.itemModel;
    }

    public void onPostBakeEvent(db<bov, boq> modelRegistry) {
        boq missingModel = (boq)modelRegistry.a((Object)a);
        for (bov missing : this.missingVariants) {
            boq model = (boq)modelRegistry.a((Object)missing);
            if (model != null && model != missingModel) continue;
            FMLLog.severe("Model definition for location %s not found", missing);
        }
        this.isLoading = false;
    }

    public static void setCustomStateMapper(afh block, bgy mapper) {
        customStateMappers.put(block.delegate, mapper);
    }

    public static void onRegisterAllBlocks(bgc shapes) {
        for (Map.Entry<RegistryDelegate<afh>, bgy> e : customStateMappers.entrySet()) {
            shapes.a(e.getKey().get(), e.getValue());
        }
    }

    public static void setCustomModelResourceLocation(zw item, int metadata, bov model) {
        customModels.put((Pair<RegistryDelegate<zw>, Integer>)Pair.of((Object)item.delegate, (Object)metadata), model);
        bot.registerItemVariants((zw)item, (jy[])new bov[]{model});
    }

    public static void setCustomMeshDefinition(zw item, bfp meshDefinition) {
        customMeshDefinitions.put(item.delegate, meshDefinition);
    }

    public static void setBucketModelDefinition(zw item) {
        ModelLoader.setCustomMeshDefinition(item, new bfp(){

            public bov a(zx stack) {
                return ModelDynBucket.LOCATION;
            }
        });
        bot.registerItemVariants((zw)item, (jy[])new bov[]{ModelDynBucket.LOCATION});
    }

    public static void onRegisterItems(bfo mesher) {
        for (Map.Entry<RegistryDelegate<zw>, bfp> entry : customMeshDefinitions.entrySet()) {
            mesher.a(entry.getKey().get(), entry.getValue());
        }
        for (Map.Entry<RegistryDelegate<zw>, bfp> entry : customModels.entrySet()) {
            mesher.a((zw)((RegistryDelegate)((Pair)entry.getKey()).getLeft()).get(), ((Integer)((Pair)entry.getKey()).getRight()).intValue(), (bov)entry.getValue());
        }
    }

    public static class White
    extends bmi {
        public static jy loc = new jy("white");
        public static White instance = new White();

        protected White() {
            super(loc.toString());
        }

        public boolean hasCustomLoader(bni manager, jy location) {
            return true;
        }

        public boolean load(bni manager, jy location) {
            BufferedImage image = new BufferedImage(16, 16, 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setBackground(Color.WHITE);
            graphics.clearRect(0, 0, 16, 16);
            BufferedImage[] images = new BufferedImage[ave.A().t.J + 1];
            images[0] = image;
            try {
                this.a(images, null);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return false;
        }

        public void register(bmh map) {
            map.setTextureEntry(loc.toString(), (bmi)instance);
        }
    }

    static enum VanillaLoader implements ICustomModelLoader
    {
        instance;

        private ModelLoader loader;

        void setLoader(ModelLoader loader) {
            this.loader = loader;
        }

        ModelLoader getLoader() {
            return this.loader;
        }

        public void a(bni resourceManager) {
        }

        @Override
        public boolean accepts(jy modelLocation) {
            return true;
        }

        @Override
        public IModel loadModel(jy modelLocation) throws IOException {
            ModelLoader modelLoader = this.loader;
            ((Object)((Object)modelLoader)).getClass();
            return modelLoader.new VanillaModelWrapper(modelLocation, this.loader.c(modelLocation));
        }
    }

    private static class FlexibleWeightedBakedModel
    extends box
    implements IFlexibleBakedModel {
        private final box parent;
        private final bmu format;

        public FlexibleWeightedBakedModel(box parent, bmu format) {
            super(parent.b);
            this.parent = parent;
            this.format = format;
        }

        @Override
        public bmu getFormat() {
            return this.format;
        }
    }

    private class WeightedRandomModel
    implements IModel {
        private final List<bgm.c> variants;
        private final List<jy> locations = new ArrayList<jy>();
        private final List<IModel> models = new ArrayList<IModel>();
        private final IModelState defaultState;

        @Deprecated
        public WeightedRandomModel(bgm.d variants) {
            this(null, variants);
        }

        public WeightedRandomModel(bov parent, bgm.d variants) {
            this.variants = variants.b();
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (bgm.c v : variants.b()) {
                jy loc = v.a();
                this.locations.add(loc);
                IModel model = null;
                try {
                    model = ModelLoader.this.getModel(loc);
                }
                catch (Exception e) {
                    FMLLog.warning("Unable to load block model: '" + loc + "' for variant: '" + parent + "': " + e.toString(), new Object[0]);
                    model = ModelLoader.this.getMissingModel();
                }
                if (v instanceof ISmartVariant) {
                    model = ((ISmartVariant)v).process(model, ModelLoader.this);
                    try {
                        ModelLoader.this.resolveDependencies(model);
                    }
                    catch (IOException e) {
                        FMLLog.getLogger().error("Exception resolving indirect dependencies for model" + loc, (Throwable)e);
                    }
                    ModelLoader.this.textures.addAll(model.getTextures());
                }
                model = new WeightedPartWrapper(model);
                this.models.add(model);
                builder.put((Object)MapModelState.wrap(model), (Object)v.getState());
            }
            if (this.models.size() == 0) {
                IModel missing = ModelLoader.this.getMissingModel();
                this.models.add(missing);
                builder.put((Object)MapModelState.wrap(missing), (Object)TRSRTransformation.identity());
            }
            this.defaultState = new MapModelState((Map<MapModelState.Wrapper, IModelState>)builder.build());
        }

        @Override
        public Collection<jy> getDependencies() {
            return ImmutableList.copyOf(this.locations);
        }

        @Override
        public Collection<jy> getTextures() {
            return Collections.emptyList();
        }

        private IModelState addUV(boolean uv, IModelState state) {
            if (uv) {
                return new UVLock(state);
            }
            return state;
        }

        private IModelState getState(IModelState state, IModel model) {
            if (state instanceof MapModelState) {
                return ((MapModelState)state).getState(model);
            }
            return state;
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla weighted models to the format that doesn't fit into the default one: " + format);
            }
            if (this.variants.size() == 1) {
                bgm.c v = this.variants.get(0);
                IModel model = this.models.get(0);
                return model.bake(this.addUV(v.c(), this.getState(state, model)), format, bakedTextureGetter);
            }
            box.a builder = new box.a();
            for (int i = 0; i < this.variants.size(); ++i) {
                IModel model = this.models.get(i);
                bgm.c v = this.variants.get(i);
                builder.a((boq)model.bake(this.addUV(v.c(), this.getState(state, model)), format, bakedTextureGetter), this.variants.get(i).d());
            }
            return new FlexibleWeightedBakedModel(builder.a(), Attributes.DEFAULT_BAKED_FORMAT);
        }

        @Override
        public IModelState getDefaultState() {
            return this.defaultState;
        }
    }

    private static class WeightedPartWrapper
    implements IModel {
        private final IModel model;

        public WeightedPartWrapper(IModel model) {
            this.model = model;
        }

        @Override
        public Collection<jy> getDependencies() {
            return this.model.getDependencies();
        }

        @Override
        public Collection<jy> getTextures() {
            return this.model.getTextures();
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
            return this.model.bake(state, format, bakedTextureGetter);
        }

        @Override
        public IModelState getDefaultState() {
            return this.model.getDefaultState();
        }
    }

    public static class UVLock
    implements IModelState {
        private final IModelState parent;

        public UVLock(IModelState parent) {
            this.parent = parent;
        }

        public IModelState getParent() {
            return this.parent;
        }

        @Override
        public Optional<TRSRTransformation> apply(Optional<? extends IModelPart> part) {
            return this.parent.apply(part);
        }
    }

    private class VanillaModelWrapper
    implements IRetexturableModel {
        private final jy location;
        private final bgl model;

        public VanillaModelWrapper(jy location, bgl model) {
            this.location = location;
            this.model = model;
        }

        @Override
        public Collection<jy> getDependencies() {
            if (this.model.e() == null || this.model.e().a().startsWith("builtin/")) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.model.e());
        }

        @Override
        public Collection<jy> getTextures() {
            if (this.model.e() != null) {
                if (this.model.e().a().equals("builtin/generated")) {
                    this.model.d = o;
                } else {
                    try {
                        IModel parent = ModelLoader.this.getModel(this.model.e());
                        if (!(parent instanceof VanillaModelWrapper)) {
                            throw new IllegalStateException("vanilla model '" + this.model + "' can't have non-vanilla parent");
                        }
                        this.model.d = ((VanillaModelWrapper)parent).model;
                    }
                    catch (IOException e) {
                        FMLLog.warning("Could not load vanilla model parent '" + this.model.e() + "' for '" + this.model + "': " + e.toString(), new Object[0]);
                        IModel missing = ModelLoader.this.getMissingModel();
                        if (missing instanceof VanillaModelWrapper) {
                            this.model.d = ((VanillaModelWrapper)missing).model;
                        }
                        throw new IllegalStateException("vanilla model '" + this.model + "' has missing parent, and missing model is not a vanilla model");
                    }
                }
            }
            ImmutableSet.Builder builder = ImmutableSet.builder();
            if (ModelLoader.this.b(this.model)) {
                for (String s : bgp.a) {
                    String r = this.model.c(s);
                    jy loc = new jy(r);
                    if (!r.equals(s)) {
                        builder.add((Object)loc);
                    }
                    if (this.model.f() == p && !loc.equals((Object)bmh.f)) {
                        bmi.b((String)loc.toString());
                        continue;
                    }
                    if (this.model.f() != q || loc.equals((Object)bmh.f)) continue;
                    bmi.a((String)loc.toString());
                }
            }
            for (String s : this.model.c.values()) {
                if (s.startsWith("#")) continue;
                builder.add((Object)new jy(s));
            }
            return builder.build();
        }

        @Override
        public IFlexibleBakedModel bake(IModelState state, bmu format, Function<jy, bmi> bakedTextureGetter) {
            if (!Attributes.moreSpecific(format, Attributes.DEFAULT_BAKED_FORMAT)) {
                throw new IllegalArgumentException("can't bake vanilla models to the format that doesn't fit into the default one: " + format);
            }
            bgl model = this.model;
            if (model == null) {
                return ModelLoader.this.getMissingModel().bake(ModelLoader.this.getMissingModel().getDefaultState(), format, bakedTextureGetter);
            }
            ArrayList newTransforms = Lists.newArrayList();
            for (int i = 0; i < model.a().size(); ++i) {
                newTransforms.add(null);
            }
            bgr transforms = model.g();
            boolean uvlock = false;
            if (state instanceof UVLock) {
                uvlock = true;
                state = ((UVLock)state).getParent();
            }
            HashMap tMap = Maps.newHashMap();
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(transforms));
            tMap.putAll(IPerspectiveAwareModel.MapWrapper.getTransforms(state));
            SimpleModelState perState = new SimpleModelState((ImmutableMap<? extends IModelPart, TRSRTransformation>)ImmutableMap.copyOf((Map)tMap));
            if (ModelLoader.this.b(model)) {
                return new ItemLayerModel(model).bake(perState, format, bakedTextureGetter);
            }
            if (ModelLoader.this.c(model)) {
                return new IFlexibleBakedModel.Wrapper((boq)new bos(transforms), format);
            }
            return this.bakeNormal(model, perState, (TRSRTransformation)state.apply((Optional<? extends IModelPart>)Optional.absent()).or((Object)TRSRTransformation.identity()), newTransforms, format, bakedTextureGetter, uvlock);
        }

        private IFlexibleBakedModel bakeNormal(bgl model, IModelState perState, final TRSRTransformation modelState, List<TRSRTransformation> newTransforms, bmu format, Function<jy, bmi> bakedTextureGetter, boolean uvLocked) {
            bmi particle = (bmi)bakedTextureGetter.apply((Object)new jy(model.c("particle")));
            bow.a builder = new bow.a(model).a(particle);
            for (int i = 0; i < model.a().size(); ++i) {
                bgh part = (bgh)model.a().get(i);
                TRSRTransformation transformation = modelState;
                if (newTransforms.get(i) != null) {
                    transformation = transformation.compose(newTransforms.get(i));
                }
                for (Map.Entry entry : part.c.entrySet()) {
                    bmi textureatlassprite1 = (bmi)bakedTextureGetter.apply((Object)new jy(model.c(((bgi)entry.getValue()).d)));
                    if (((bgi)entry.getValue()).b == null || !TRSRTransformation.isInteger(transformation.getMatrix())) {
                        builder.a(ModelLoader.this.makeBakedQuad(part, (bgi)entry.getValue(), textureatlassprite1, (cq)entry.getKey(), transformation, uvLocked));
                        continue;
                    }
                    builder.a(modelState.rotate(((bgi)entry.getValue()).b), ModelLoader.this.makeBakedQuad(part, (bgi)entry.getValue(), textureatlassprite1, (cq)entry.getKey(), transformation, uvLocked));
                }
            }
            return new ISmartBlockModel.PerspectiveWrapper(new IPerspectiveAwareModel.MapWrapper((IFlexibleBakedModel)new IFlexibleBakedModel.Wrapper(builder.b(), format), perState)){

                @Override
                public boq handleBlockState(alz state) {
                    return VanillaModelWrapper.this.handleBlockState(this.parent, modelState, state);
                }
            };
        }

        private boq handleBlockState(IFlexibleBakedModel model, TRSRTransformation modelState, alz state) {
            return model;
        }

        @Override
        public IModel retexture(ImmutableMap<String, String> textures) {
            if (textures.isEmpty()) {
                return this;
            }
            ArrayList elements = Lists.newArrayList();
            for (bgh part : this.model.a()) {
                elements.add(new bgh(part.a, part.b, (Map)Maps.newHashMap((Map)part.c), part.d, part.e));
            }
            bgl neweModel = new bgl(this.model.e(), (List)elements, (Map)Maps.newHashMap((Map)this.model.c), this.model.b(), this.model.c(), this.model.g());
            neweModel.b = this.model.b;
            neweModel.d = this.model.d;
            HashSet removed = Sets.newHashSet();
            for (Map.Entry e : textures.entrySet()) {
                if ("".equals(e.getValue())) {
                    removed.add(e.getKey());
                    neweModel.c.remove(e.getKey());
                    continue;
                }
                neweModel.c.put(e.getKey(), e.getValue());
            }
            HashMap remapped = Maps.newHashMap();
            for (Map.Entry e : neweModel.c.entrySet()) {
                String key;
                if (!((String)e.getValue()).startsWith("#") || !neweModel.c.containsKey(key = ((String)e.getValue()).substring(1))) continue;
                remapped.put(e.getKey(), (String)neweModel.c.get(key));
            }
            neweModel.c.putAll(remapped);
            for (bgh part : neweModel.a()) {
                Iterator itr = part.c.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    if (!removed.contains(((bgi)entry.getValue()).d)) continue;
                    itr.remove();
                }
            }
            return new VanillaModelWrapper(this.location, neweModel);
        }

        @Override
        public IModelState getDefaultState() {
            return bor.a;
        }
    }
}

