/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model.pipeline;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.IColoredBakedQuad;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.client.model.pipeline.WorldRendererConsumer;

public class LightUtil {
    private static final float s2 = (float)Math.pow(2.0, 0.5);
    private static final LoadingCache<bmu, int[]> formatMaps = CacheBuilder.newBuilder().maximumSize(10L).build((CacheLoader)new CacheLoader<bmu, int[]>(){

        public int[] load(bmu format) {
            return LightUtil.mapFormats(format, bms.b);
        }
    });
    private static IVertexConsumer tessellator = null;
    private static ItemConsumer itemConsumer = null;

    public static float diffuseLight(float x, float y, float z) {
        float y1 = y + 3.0f - 2.0f * s2;
        return x * x * 0.6f + y1 * y1 * (3.0f + 2.0f * s2) / 8.0f + z * z * 0.8f;
    }

    public static float diffuseLight(cq side) {
        switch (side) {
            case a: {
                return 0.5f;
            }
            case b: {
                return 1.0f;
            }
            case c: 
            case d: {
                return 0.8f;
            }
        }
        return 0.6f;
    }

    public static cq toSide(float x, float y, float z) {
        if (Math.abs(x) > Math.abs(y)) {
            if (Math.abs(x) > Math.abs(z)) {
                if (x < 0.0f) {
                    return cq.e;
                }
                return cq.f;
            }
            if (z < 0.0f) {
                return cq.c;
            }
            return cq.d;
        }
        if (Math.abs(y) > Math.abs(z)) {
            if (y < 0.0f) {
                return cq.a;
            }
            return cq.b;
        }
        if (z < 0.0f) {
            return cq.c;
        }
        return cq.d;
    }

    public static void putBakedQuad(IVertexConsumer consumer, bgg quad) {
        consumer.setQuadOrientation(quad.d());
        if (quad.b()) {
            consumer.setQuadTint(quad.c());
        }
        if (quad instanceof IColoredBakedQuad) {
            consumer.setQuadColored();
        }
        float[] data = new float[4];
        int[] eMap = (int[])formatMaps.getUnchecked((Object)consumer.getVertexFormat());
        for (int v = 0; v < 4; ++v) {
            for (int e = 0; e < consumer.getVertexFormat().i(); ++e) {
                if (eMap[e] != bms.b.i()) {
                    LightUtil.unpack(quad.a(), data, bms.b, v, eMap[e]);
                    consumer.put(e, data);
                    continue;
                }
                consumer.put(e, new float[0]);
            }
        }
    }

    public static int[] mapFormats(bmu from, bmu to) {
        int[] eMap = new int[from.i()];
        for (int e = 0; e < from.i(); ++e) {
            int e2;
            bmv expected = from.c(e);
            for (e2 = 0; e2 < to.i(); ++e2) {
                bmv current = to.c(e2);
                if (expected.b() == current.b() && expected.d() == current.d()) break;
            }
            eMap[e] = e2;
        }
        return eMap;
    }

    public static void unpack(int[] from, float[] to, bmu formatFrom, int v, int e) {
        bmv element = formatFrom.c(e);
        int length = 4 < to.length ? 4 : to.length;
        for (int i = 0; i < length; ++i) {
            if (i < element.c()) {
                int pos = v * formatFrom.g() + formatFrom.d(e) + element.a().a() * i;
                int index = pos >> 2;
                int offset = pos & 3;
                int bits = from[index];
                bits >>>= offset * 8;
                if ((pos + element.a().a() - 1) / 4 != index) {
                    bits |= from[index + 1] << (4 - offset) * 8;
                }
                int mask = (256 << 8 * (element.a().a() - 1)) - 1;
                bits &= mask;
                switch (element.a()) {
                    case a: {
                        to[i] = Float.intBitsToFloat(bits);
                        break;
                    }
                    case b: 
                    case d: {
                        to[i] = (float)bits / (float)mask;
                        break;
                    }
                    case f: {
                        to[i] = (float)((double)((long)bits & 0xFFFFFFFFL) / 4.294967295E9);
                        break;
                    }
                    case c: {
                        to[i] = (float)((byte)bits) / (float)mask * 2.0f;
                        break;
                    }
                    case e: {
                        to[i] = (float)((short)bits) / (float)mask * 2.0f;
                        break;
                    }
                    case g: {
                        to[i] = (float)((long)bits & 0xFFFFFFFFL) / 4.2949673E9f * 2.0f;
                    }
                }
                continue;
            }
            to[i] = 0.0f;
        }
    }

    public static void pack(float[] from, int[] to, bmu formatTo, int v, int e) {
        bmv element = formatTo.c(e);
        for (int i = 0; i < 4; ++i) {
            if (i >= element.c()) continue;
            int pos = v * formatTo.g() + formatTo.d(e) + element.a().a() * i;
            int index = pos >> 2;
            int offset = pos & 3;
            int bits = 0;
            int mask = (256 << 8 * (element.a().a() - 1)) - 1;
            float f = i < from.length ? from[i] : 0.0f;
            switch (element.a()) {
                case a: {
                    bits = Float.floatToRawIntBits(f);
                    break;
                }
                case b: 
                case d: 
                case f: {
                    bits = (int)(f * (float)mask);
                    break;
                }
                case c: 
                case e: 
                case g: {
                    bits = (int)(f * (float)mask / 2.0f);
                }
            }
            int n = index;
            to[n] = to[n] & ~(mask << offset * 8);
            int n2 = index;
            to[n2] = to[n2] | (bits & mask) << offset * 8;
        }
    }

    public static IVertexConsumer getTessellator() {
        if (tessellator == null) {
            bfx tes = bfx.a();
            bfd wr = tes.c();
            tessellator = new WorldRendererConsumer(wr);
        }
        return tessellator;
    }

    public static ItemConsumer getItemConsumer() {
        if (itemConsumer == null) {
            itemConsumer = new ItemConsumer(LightUtil.getTessellator());
        }
        return itemConsumer;
    }

    public static void renderQuadColorSlow(bfd wr, bgg quad, int auxColor) {
        ItemConsumer cons = wr == bfx.a().c() ? LightUtil.getItemConsumer() : new ItemConsumer(new WorldRendererConsumer(wr));
        float b2 = (float)(auxColor & 0xFF) / 255.0f;
        float g2 = (float)(auxColor >>> 8 & 0xFF) / 255.0f;
        float r = (float)(auxColor >>> 16 & 0xFF) / 255.0f;
        float a2 = (float)(auxColor >>> 24 & 0xFF) / 255.0f;
        cons.setAuxColor(r, g2, b2, a2);
        quad.pipe((IVertexConsumer)cons);
    }

    public static void renderQuadColor(bfd wr, bgg quad, int auxColor) {
        wr.a(quad.a());
        if (quad instanceof IColoredBakedQuad) {
            ForgeHooksClient.putQuadColor(wr, quad, auxColor);
        } else {
            wr.a(auxColor);
        }
    }

    public static class ItemConsumer
    extends VertexTransformer {
        private boolean colored = false;
        private int vertices = 0;
        private float[] auxColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private float[] buf = new float[4];

        public ItemConsumer(IVertexConsumer parent) {
            super(parent);
        }

        public void setAuxColor(float ... auxColor) {
            System.arraycopy(auxColor, 0, this.auxColor, 0, this.auxColor.length);
        }

        @Override
        public void setQuadColored() {
            this.colored = true;
        }

        @Override
        public void put(int element, float ... data) {
            if (this.getVertexFormat().c(element).b() == bmv.b.c) {
                System.arraycopy(this.auxColor, 0, this.buf, 0, this.buf.length);
                if (this.colored) {
                    for (int i = 0; i < 4; ++i) {
                        int n = i;
                        this.buf[n] = this.buf[n] * data[i];
                    }
                }
                super.put(element, this.buf);
            } else {
                super.put(element, data);
            }
            if (element == this.getVertexFormat().i() - 1) {
                ++this.vertices;
                if (this.vertices == 4) {
                    this.vertices = 0;
                    this.colored = false;
                }
            }
        }
    }
}

