/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class ChestGenHooks {
    public static final String MINESHAFT_CORRIDOR = "mineshaftCorridor";
    public static final String PYRAMID_DESERT_CHEST = "pyramidDesertyChest";
    public static final String PYRAMID_JUNGLE_CHEST = "pyramidJungleChest";
    public static final String PYRAMID_JUNGLE_DISPENSER = "pyramidJungleDispenser";
    public static final String STRONGHOLD_CORRIDOR = "strongholdCorridor";
    public static final String STRONGHOLD_LIBRARY = "strongholdLibrary";
    public static final String STRONGHOLD_CROSSING = "strongholdCrossing";
    public static final String VILLAGE_BLACKSMITH = "villageBlacksmith";
    public static final String BONUS_CHEST = "bonusChest";
    public static final String DUNGEON_CHEST = "dungeonChest";
    public static final String NETHER_FORTRESS = "netherFortress";
    private static final HashMap<String, ChestGenHooks> chestInfo = new HashMap();
    private static boolean hasInit = false;
    private String category;
    private int countMin = 0;
    private int countMax = 0;
    private ArrayList<ob> contents = new ArrayList();

    private static void init() {
        if (hasInit) {
            return;
        }
        hasInit = true;
        new api();
        new aqn.a();
        new aqn.b();
        new aqg();
        new aqk();
        new aqp.a();
        new aqp.e();
        new aqp.j();
        new aqw.j();
        new aqj.h();
        le.fillChestHook();
    }

    public static void init(String category, List<ob> items, int min, int max) {
        chestInfo.put(category, new ChestGenHooks(category, items, min, max));
    }

    static void addDungeonLoot(ChestGenHooks dungeon, zx item, int weight, int min, int max) {
        dungeon.addItem(new ob(item, min, max, weight));
    }

    public static ChestGenHooks getInfo(String category) {
        if (!chestInfo.containsKey(category)) {
            chestInfo.put(category, new ChestGenHooks(category));
        }
        return chestInfo.get(category);
    }

    public static zx[] generateStacks(Random rand, zx source, int min, int max) {
        zx[] ret;
        int count = min + rand.nextInt(max - min + 1);
        if (source.b() == null) {
            ret = new zx[]{};
        } else if (count > source.c()) {
            ret = new zx[count];
            for (int x = 0; x < count; ++x) {
                ret[x] = source.k();
                ret[x].b = 1;
            }
        } else {
            ret = new zx[]{source.k()};
            ret[0].b = count;
        }
        return ret;
    }

    public static List<ob> getItems(String category, Random rnd) {
        return ChestGenHooks.getInfo(category).getItems(rnd);
    }

    public static int getCount(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getCount(rand);
    }

    public static void addItem(String category, ob item) {
        ChestGenHooks.getInfo(category).addItem(item);
    }

    public static void removeItem(String category, zx item) {
        ChestGenHooks.getInfo(category).removeItem(item);
    }

    public static zx getOneItem(String category, Random rand) {
        return ChestGenHooks.getInfo(category).getOneItem(rand);
    }

    public ChestGenHooks(String category) {
        this.category = category;
    }

    public ChestGenHooks(String category, List<ob> items, int min, int max) {
        this(category);
        for (ob item : items) {
            this.contents.add(item);
        }
        this.countMin = min;
        this.countMax = max;
    }

    public void addItem(ob item) {
        this.contents.add(item);
    }

    public void removeItem(zx item) {
        Iterator<ob> itr = this.contents.iterator();
        while (itr.hasNext()) {
            ob cont = itr.next();
            if (!item.a(cont.b) && (item.h() != Short.MAX_VALUE || item.b() != cont.b.b())) continue;
            itr.remove();
        }
    }

    public List<ob> getItems(Random rnd) {
        ArrayList<ob> ret = new ArrayList<ob>();
        for (ob orig : this.contents) {
            ob n;
            zw item = orig.b.b();
            if (item == null || (n = item.getChestGenBase(this, rnd, orig)) == null) continue;
            ret.add(n);
        }
        return ret;
    }

    public int getCount(Random rand) {
        return this.countMin < this.countMax ? this.countMin + rand.nextInt(this.countMax - this.countMin) : this.countMin;
    }

    public zx getOneItem(Random rand) {
        ob item = (ob)oa.a((Random)rand, this.getItems(rand));
        zx[] stacks = ChestGenHooks.generateStacks(rand, item.b, item.c, item.d);
        return stacks.length > 0 ? stacks[0] : null;
    }

    public int getMin() {
        return this.countMin;
    }

    public int getMax() {
        return this.countMax;
    }

    public void setMin(int value) {
        this.countMin = value;
    }

    public void setMax(int value) {
        this.countMax = value;
    }

    static {
        ChestGenHooks.init();
    }
}

