/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.primitives.UnsignedBytes;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.internal.FMLMessage;
import org.apache.logging.log4j.Level;

public class EntityRegistry {
    private static final EntityRegistry INSTANCE = new EntityRegistry();
    private BitSet availableIndicies;
    private ListMultimap<ModContainer, EntityRegistration> entityRegistrations = ArrayListMultimap.create();
    private Map<String, ModContainer> entityNames = Maps.newHashMap();
    private BiMap<Class<? extends pk>, EntityRegistration> entityClassRegistrations = HashBiMap.create();
    private Map<String, pm.a> entityEggs = Maps.newHashMap();
    private Map<String, pm.a> entityEggsUn = Collections.unmodifiableMap(this.entityEggs);

    public static EntityRegistry instance() {
        return INSTANCE;
    }

    private EntityRegistry() {
        this.availableIndicies = new BitSet(256);
        this.availableIndicies.set(1, 255);
        for (Object id : pm.e.keySet()) {
            this.availableIndicies.clear((Integer)id);
        }
    }

    public static void registerModEntity(Class<? extends pk> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
    }

    public static void registerModEntity(Class<? extends pk> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates, int eggPrimary, int eggSecondary) {
        EntityRegistry.instance().doModEntityRegistration(entityClass, entityName, id, mod, trackingRange, updateFrequency, sendsVelocityUpdates);
        EntityRegistry.registerEgg(entityClass, eggPrimary, eggSecondary);
    }

    private void doModEntityRegistration(Class<? extends pk> entityClass, String entityName, int id, Object mod, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(mod);
        EntityRegistration er2 = new EntityRegistration(mc, entityClass, entityName, id, trackingRange, updateFrequency, sendsVelocityUpdates);
        try {
            this.entityClassRegistrations.put(entityClass, (Object)er2);
            this.entityNames.put(entityName, mc);
            if (!pm.d.containsKey(entityClass)) {
                String entityModName = String.format("%s.%s", mc.getModId(), entityName);
                pm.d.put(entityClass, entityModName);
                pm.c.put(entityModName, entityClass);
                FMLLog.finer("Automatically registered mod %s entity %s as %s", mc.getModId(), entityName, entityModName);
            } else {
                FMLLog.fine("Skipping automatic mod %s entity registration for already registered class %s", mc.getModId(), entityClass.getName());
            }
        }
        catch (IllegalArgumentException e2) {
            FMLLog.log(Level.WARN, e2, "The mod %s tried to register the entity (name,class) (%s,%s) one or both of which are already registered", mc.getModId(), entityName, entityClass.getName());
            return;
        }
        this.entityRegistrations.put((Object)mc, (Object)er2);
    }

    public static void registerEgg(Class<? extends pk> entityClass, int primary, int secondary) {
        if (!pm.d.containsKey(entityClass)) {
            throw new IllegalArgumentException("Entity not registered in classToString map: " + entityClass);
        }
        String name = (String)pm.d.get(entityClass);
        EntityRegistry.instance().entityEggs.put(name, new pm.a(name, primary, secondary));
        FMLLog.fine("Registering entity egg '%s' for %s", name, entityClass);
    }

    public static Map<String, pm.a> getEggs() {
        return EntityRegistry.instance().entityEggsUn;
    }

    @Deprecated
    public static void registerGlobalEntityID(Class<? extends pk> entityClass, String entityName, int id) {
        if (pm.d.containsKey(entityClass)) {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            String modId = "unknown";
            if (activeModContainer != null) {
                modId = activeModContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", modId, entityClass);
            return;
        }
        id = EntityRegistry.instance().validateAndClaimId(id);
        pm.a(entityClass, (String)entityName, (int)id);
    }

    @Deprecated
    public static void registerGlobalEntityID(Class<? extends pk> entityClass, String entityName, int id, int backgroundEggColour, int foregroundEggColour) {
        if (pm.d.containsKey(entityClass)) {
            ModContainer activeModContainer = Loader.instance().activeModContainer();
            String modId = "unknown";
            if (activeModContainer != null) {
                modId = activeModContainer.getModId();
            } else {
                FMLLog.severe("There is a rogue mod failing to register entities from outside the context of mod loading. This is incredibly dangerous and should be stopped.", new Object[0]);
            }
            FMLLog.warning("The mod %s tried to register the entity class %s which was already registered - if you wish to override default naming for FML mod entities, register it here first", modId, entityClass);
            return;
        }
        EntityRegistry.instance().validateAndClaimId(id);
        pm.a(entityClass, (String)entityName, (int)id, (int)backgroundEggColour, (int)foregroundEggColour);
    }

    private int validateAndClaimId(int id) {
        int realId = id;
        if (id < -128) {
            FMLLog.warning("Compensating for modloader out of range compensation by mod : entityId %d for mod %s is now %d", id, Loader.instance().activeModContainer().getModId(), realId);
            realId += 3000;
        }
        if (realId < 0) {
            realId += 127;
        }
        try {
            UnsignedBytes.checkedCast((long)realId);
        }
        catch (IllegalArgumentException e2) {
            FMLLog.log(Level.ERROR, "The entity ID %d for mod %s is not an unsigned byte and may not work", id, Loader.instance().activeModContainer().getModId());
        }
        if (!this.availableIndicies.get(realId)) {
            FMLLog.severe("The mod %s has attempted to register an entity ID %d which is already reserved. This could cause severe problems", Loader.instance().activeModContainer().getModId(), id);
        }
        this.availableIndicies.clear(realId);
        return realId;
    }

    public static void addSpawn(Class<? extends ps> entityClass, int weightedProb, int min, int max, pt typeOfCreature, ady ... biomes) {
        for (ady biome : biomes) {
            List spawns = biome.a(typeOfCreature);
            for (ady.c entry : spawns) {
                if (entry.b != entityClass) continue;
                entry.a = weightedProb;
                entry.c = min;
                entry.d = max;
                break;
            }
            spawns.add(new ady.c(entityClass, weightedProb, min, max));
        }
    }

    public static void addSpawn(String entityName, int weightedProb, int min, int max, pt typeOfCreature, ady ... biomes) {
        Class entityClazz = (Class)pm.c.get(entityName);
        if (ps.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.addSpawn(entityClazz, weightedProb, min, max, typeOfCreature, biomes);
        }
    }

    public static void removeSpawn(Class<? extends ps> entityClass, pt typeOfCreature, ady ... biomes) {
        for (ady biome : biomes) {
            Iterator spawns = biome.a(typeOfCreature).iterator();
            while (spawns.hasNext()) {
                ady.c entry = (ady.c)spawns.next();
                if (entry.b != entityClass) continue;
                spawns.remove();
            }
        }
    }

    public static void removeSpawn(String entityName, pt typeOfCreature, ady ... biomes) {
        Class entityClazz = (Class)pm.c.get(entityName);
        if (ps.class.isAssignableFrom(entityClazz)) {
            EntityRegistry.removeSpawn(entityClazz, typeOfCreature, biomes);
        }
    }

    @Deprecated
    public static int findGlobalUniqueEntityId() {
        int res = EntityRegistry.instance().availableIndicies.nextSetBit(0);
        if (res < 0) {
            throw new RuntimeException("No more entity indicies left");
        }
        return res;
    }

    public EntityRegistration lookupModSpawn(Class<? extends pk> clazz, boolean keepLooking) {
        Class<? extends pk> localClazz = clazz;
        do {
            EntityRegistration er2;
            if ((er2 = (EntityRegistration)this.entityClassRegistrations.get(localClazz)) == null) continue;
            return er2;
        } while (keepLooking = !Object.class.equals(localClazz = localClazz.getSuperclass()));
        return null;
    }

    public EntityRegistration lookupModSpawn(ModContainer mc, int modEntityId) {
        for (EntityRegistration er2 : this.entityRegistrations.get((Object)mc)) {
            if (er2.getModEntityId() != modEntityId) continue;
            return er2;
        }
        return null;
    }

    public boolean tryTrackingEntity(la entityTracker, pk entity) {
        EntityRegistration er2 = this.lookupModSpawn(entity.getClass(), true);
        if (er2 != null) {
            entityTracker.a(entity, er2.getTrackingRange(), er2.getUpdateFrequency(), er2.sendsVelocityUpdates());
            return true;
        }
        return false;
    }

    public class EntityRegistration {
        private Class<? extends pk> entityClass;
        private ModContainer container;
        private String entityName;
        private int modId;
        private int trackingRange;
        private int updateFrequency;
        private boolean sendsVelocityUpdates;
        private Function<FMLMessage.EntitySpawnMessage, pk> customSpawnCallback;
        private boolean usesVanillaSpawning;

        public EntityRegistration(ModContainer mc, Class<? extends pk> entityClass, String entityName, int id, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            this.container = mc;
            this.entityClass = entityClass;
            this.entityName = entityName;
            this.modId = id;
            this.trackingRange = trackingRange;
            this.updateFrequency = updateFrequency;
            this.sendsVelocityUpdates = sendsVelocityUpdates;
        }

        public Class<? extends pk> getEntityClass() {
            return this.entityClass;
        }

        public ModContainer getContainer() {
            return this.container;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public int getModEntityId() {
            return this.modId;
        }

        public int getTrackingRange() {
            return this.trackingRange;
        }

        public int getUpdateFrequency() {
            return this.updateFrequency;
        }

        public boolean sendsVelocityUpdates() {
            return this.sendsVelocityUpdates;
        }

        public boolean usesVanillaSpawning() {
            return this.usesVanillaSpawning;
        }

        public boolean hasCustomSpawning() {
            return this.customSpawnCallback != null;
        }

        public pk doCustomSpawning(FMLMessage.EntitySpawnMessage spawnMsg) throws Exception {
            return (pk)this.customSpawnCallback.apply((Object)spawnMsg);
        }

        public void setCustomSpawning(Function<FMLMessage.EntitySpawnMessage, pk> callable, boolean usesVanillaSpawning) {
            this.customSpawnCallback = callable;
            this.usesVanillaSpawning = usesVanillaSpawning;
        }
    }
}

