/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.common.registry;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.registry.GameData;
import org.apache.logging.log4j.Level;

class ObjectHolderRef {
    private Field field;
    private jy injectedObject;
    private boolean isBlock;
    private boolean isItem;
    private static Field modifiersField;
    private static Object reflectionFactory;
    private static Method newFieldAccessor;
    private static Method fieldAccessorSet;

    ObjectHolderRef(Field field, jy injectedObject, boolean extractFromExistingValues) {
        this.field = field;
        this.isBlock = afh.class.isAssignableFrom(field.getType());
        this.isItem = zw.class.isAssignableFrom(field.getType());
        if (extractFromExistingValues) {
            try {
                jy tmp;
                Object existing = field.get(null);
                if (existing == null || existing == GameData.getBlockRegistry().getDefaultValue()) {
                    this.injectedObject = null;
                    this.field = null;
                    this.isBlock = false;
                    this.isItem = false;
                    return;
                }
                this.injectedObject = tmp = this.isBlock ? GameData.getBlockRegistry().getNameForObject((afh)existing) : (this.isItem ? GameData.getItemRegistry().getNameForObject((zw)existing) : null);
            }
            catch (Exception e2) {
                throw Throwables.propagate((Throwable)e2);
            }
        } else {
            this.injectedObject = injectedObject;
        }
        if (this.injectedObject == null || !this.isValid()) {
            throw new IllegalStateException(String.format("The ObjectHolder annotation cannot apply to a field that is not an Item or Block (found : %s at %s.%s)", field.getType().getName(), field.getClass().getName(), field.getName()));
        }
        ObjectHolderRef.makeWritable(field);
    }

    private static void makeWritable(Field f2) {
        try {
            if (modifiersField == null) {
                Method getReflectionFactory = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("getReflectionFactory", new Class[0]);
                reflectionFactory = getReflectionFactory.invoke(null, new Object[0]);
                newFieldAccessor = Class.forName("sun.reflect.ReflectionFactory").getDeclaredMethod("newFieldAccessor", Field.class, Boolean.TYPE);
                fieldAccessorSet = Class.forName("sun.reflect.FieldAccessor").getDeclaredMethod("set", Object.class, Object.class);
                modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
            }
            modifiersField.setInt(f2, f2.getModifiers() & 0xFFFFFFEF);
        }
        catch (Exception e2) {
            throw Throwables.propagate((Throwable)e2);
        }
    }

    public boolean isValid() {
        return this.isBlock || this.isItem;
    }

    public void apply() {
        Object thing;
        if (this.isBlock) {
            thing = GameData.getBlockRegistry().getObject(this.injectedObject);
            if (thing == afi.a) {
                thing = null;
            }
        } else {
            thing = this.isItem ? GameData.getItemRegistry().getObject(this.injectedObject) : null;
        }
        if (thing == null) {
            FMLLog.getLogger().log(Level.DEBUG, "Unable to lookup {} for {}. This means the object wasn't registered. It's likely just mod options.", new Object[]{this.injectedObject, this.field});
            return;
        }
        try {
            Object fieldAccessor = newFieldAccessor.invoke(reflectionFactory, this.field, false);
            fieldAccessorSet.invoke(fieldAccessor, null, thing);
        }
        catch (Exception e2) {
            FMLLog.log(Level.WARN, e2, "Unable to set %s with value %s (%s)", this.field, thing, this.injectedObject);
        }
    }
}

