/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsState;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsGenericErrorScreen;
import com.mojang.realmsclient.util.RealmsUtil;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class RealmsBuyRealmsScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private RealmsScreen lastScreen;
    private static int BUTTON_BACK_ID = 0;
    private volatile RealmsState realmsStatus;
    private boolean onLink = false;

    public RealmsBuyRealmsScreen(RealmsScreen lastScreen) {
        this.lastScreen = lastScreen;
    }

    public void tick() {
        super.tick();
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        int buttonLength = 212;
        this.buttonsAdd(RealmsBuyRealmsScreen.newButton((int)BUTTON_BACK_ID, (int)(this.width() / 2 - buttonLength / 2), (int)RealmsConstants.row(12), (int)buttonLength, (int)20, (String)RealmsBuyRealmsScreen.getLocalizedString((String)"gui.back")));
        this.fetchMessage();
    }

    private void fetchMessage() {
        final RealmsClient client = RealmsClient.createRealmsClient();
        new Thread("Realms-stat-message"){

            @Override
            public void run() {
                try {
                    RealmsBuyRealmsScreen.this.realmsStatus = client.fetchRealmsState();
                }
                catch (RealmsServiceException e) {
                    LOGGER.error("Could not get state");
                    Realms.setScreen((RealmsScreen)new RealmsGenericErrorScreen(e, RealmsBuyRealmsScreen.this.lastScreen));
                }
            }
        }.start();
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == BUTTON_BACK_ID) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
        if (this.onLink) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(new StringSelection(this.realmsStatus.getBuyLink()), null);
            RealmsUtil.browseTo(this.realmsStatus.getBuyLink());
        }
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(RealmsBuyRealmsScreen.getLocalizedString((String)"mco.buy.realms.title"), this.width() / 2, 17, 0xFFFFFF);
        if (this.realmsStatus == null) {
            return;
        }
        String[] lines = this.realmsStatus.getStatusMessage().split("\n");
        int i = 1;
        for (String line : lines) {
            this.drawCenteredString(line, this.width() / 2, RealmsConstants.row(i), 0xA0A0A0);
            i += 2;
        }
        if (this.realmsStatus.getBuyLink() != null) {
            String buyLink = this.realmsStatus.getBuyLink();
            int height = RealmsConstants.row(i + 1);
            int textWidth = this.fontWidth(buyLink);
            int x1 = this.width() / 2 - textWidth / 2 - 1;
            int y1 = height - 1;
            int x2 = x1 + textWidth + 1;
            int y2 = height + 1 + this.fontLineHeight();
            if (x1 <= xm && xm <= x2 && y1 <= ym && ym <= y2) {
                this.onLink = true;
                this.drawString(buyLink, this.width() / 2 - textWidth / 2, height, 7107012);
            } else {
                this.onLink = false;
                this.drawString(buyLink, this.width() / 2 - textWidth / 2, height, 0x3366BB);
            }
        }
        super.render(xm, ym, a);
    }
}

