/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelPart;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ForgeVersion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

public class ForgeHooksClient {
    static int renderPass = -1;
    static final ThreadLocal<adf> renderLayer = new ThreadLocal<adf>(){

        @Override
        protected adf initialValue() {
            return adf.a;
        }
    };
    private static int skyX;
    private static int skyZ;
    private static boolean skyInit;
    private static int skyRGBMultiplier;
    static int worldRenderPass;
    private static final FloatBuffer matrixBuf;
    private static Map<Pair<zw, Integer>, Class<? extends akw>> tileItemMap;

    static bmj engine() {
        return FMLClientHandler.instance().getClient().R;
    }

    public static String getArmorTexture(pk entity, zx armor, String _default, int slot, String type) {
        String result = armor.b().getArmorTexture(armor, entity, slot, type);
        return result != null ? result : _default;
    }

    public static void orientBedCamera(adq world, cj pos, alz state, pk entity) {
        afh block = state.c();
        if (block != null && block.isBed(world, pos, entity)) {
            GL11.glRotatef((float)(block.getBedDirection(world, pos).b() * 90), (float)0.0f, (float)1.0f, (float)0.0f);
        }
    }

    public static boolean onDrawBlockHighlight(bfr context, wn player, auh target, int subID, zx currentItem, float partialTicks) {
        return MinecraftForge.EVENT_BUS.post(new DrawBlockHighlightEvent(context, player, target, subID, currentItem, partialTicks));
    }

    public static void dispatchRenderLast(bfr context, float partialTicks) {
        MinecraftForge.EVENT_BUS.post(new RenderWorldLastEvent(context, partialTicks));
    }

    public static boolean renderFirstPersonHand(bfr context, float partialTicks, int renderPass) {
        return MinecraftForge.EVENT_BUS.post(new RenderHandEvent(context, partialTicks, renderPass));
    }

    public static void onTextureStitchedPre(bmh map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Pre(map));
        ModelLoader.White.instance.register(map);
    }

    public static void onTextureStitchedPost(bmh map) {
        MinecraftForge.EVENT_BUS.post(new TextureStitchEvent.Post(map));
    }

    public static void setRenderPass(int pass) {
        renderPass = pass;
    }

    public static void setRenderLayer(adf layer) {
        renderLayer.set(layer);
    }

    public static bbj getArmorModel(pr entityLiving, zx itemStack, int slotID, bbj _default) {
        bbj model = itemStack.b().getArmorModel(entityLiving, itemStack, slotID);
        return model == null ? _default : model;
    }

    public static String fixDomain(String base, String complex) {
        int idx = complex.indexOf(58);
        if (idx == -1) {
            return base + complex;
        }
        String name = complex.substring(idx + 1, complex.length());
        if (idx > 1) {
            String domain = complex.substring(0, idx);
            return domain + ':' + base + name;
        }
        return base + name;
    }

    public static boolean postMouseEvent() {
        return MinecraftForge.EVENT_BUS.post(new MouseEvent());
    }

    public static float getOffsetFOV(wn entity, float fov) {
        FOVUpdateEvent fovUpdateEvent = new FOVUpdateEvent(entity, fov);
        MinecraftForge.EVENT_BUS.post(fovUpdateEvent);
        return fovUpdateEvent.newfov;
    }

    public static int getSkyBlendColour(adm world, cj center) {
        if (center.n() == skyX && center.p() == skyZ && skyInit) {
            return skyRGBMultiplier;
        }
        skyInit = true;
        avh settings = ave.A().t;
        int[] ranges = ForgeModContainer.blendRanges;
        int distance = 0;
        if (settings.i && settings.c >= 0 && settings.c < ranges.length) {
            distance = ranges[settings.c];
        }
        int r = 0;
        int g2 = 0;
        int b2 = 0;
        int divider = 0;
        for (int x = -distance; x <= distance; ++x) {
            for (int z = -distance; z <= distance; ++z) {
                cj pos = center.a(x, 0, z);
                ady biome = world.b(pos);
                int colour = biome.a(biome.a(pos));
                r += (colour & 0xFF0000) >> 16;
                g2 += (colour & 0xFF00) >> 8;
                b2 += colour & 0xFF;
                ++divider;
            }
        }
        int multiplier = (r / divider & 0xFF) << 16 | (g2 / divider & 0xFF) << 8 | b2 / divider & 0xFF;
        skyX = center.n();
        skyZ = center.o();
        skyRGBMultiplier = multiplier;
        return skyRGBMultiplier;
    }

    public static void renderMainMenu(aya gui, avn font, int width, int height) {
        String line;
        ForgeVersion.Status status = ForgeVersion.getStatus();
        if (status == ForgeVersion.Status.BETA || status == ForgeVersion.Status.BETA_OUTDATED) {
            line = bnq.a((String)"forge.update.beta.1", (Object[])new Object[]{a.m, a.v});
            gui.c(font, line, (width - font.a(line)) / 2, 4 + 0 * (font.a + 1), -1);
            line = bnq.a((String)"forge.update.beta.2", (Object[])new Object[0]);
            gui.c(font, line, (width - font.a(line)) / 2, 4 + 1 * (font.a + 1), -1);
        }
        line = null;
        switch (status) {
            case OUTDATED: 
            case BETA_OUTDATED: {
                line = bnq.a((String)"forge.update.newversion", (Object[])new Object[]{ForgeVersion.getTarget()});
                break;
            }
        }
        if (line != null) {
            gui.c(font, line, width - font.a(line) - 2, height - 2 * (font.a + 1), -1);
        }
    }

    public static bpj playSound(bpx manager, bpj sound) {
        bpy accessor = manager.c.a(sound.a());
        PlaySoundEvent e = new PlaySoundEvent(manager, sound, accessor == null ? null : accessor.d());
        MinecraftForge.EVENT_BUS.post(e);
        return e.result;
    }

    public static int getWorldRenderPass() {
        return worldRenderPass;
    }

    public static void drawScreen(axu screen, int mouseX, int mouseY, float partialTicks) {
        if (!MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Pre(screen, mouseX, mouseY, partialTicks))) {
            screen.a(mouseX, mouseY, partialTicks);
        }
        MinecraftForge.EVENT_BUS.post(new GuiScreenEvent.DrawScreenEvent.Post(screen, mouseX, mouseY, partialTicks));
    }

    public static float getFogDensity(bfk renderer, pk entity, afh block, float partial, float density) {
        EntityViewRenderEvent.FogDensity event = new EntityViewRenderEvent.FogDensity(renderer, entity, block, partial, density);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return event.density;
        }
        return -1.0f;
    }

    public static void onFogRender(bfk renderer, pk entity, afh block, float partial, int mode, float distance) {
        MinecraftForge.EVENT_BUS.post(new EntityViewRenderEvent.RenderFogEvent(renderer, entity, block, partial, mode, distance));
    }

    public static void onModelBake(bou modelManager, db<bov, boq> modelRegistry, bot modelBakery) {
        ModelLoader loader = (ModelLoader)modelBakery;
        MinecraftForge.EVENT_BUS.post(new ModelBakeEvent(modelManager, modelRegistry, loader));
        loader.onPostBakeEvent(modelRegistry);
    }

    public static Matrix4f getMatrix(bgq transform) {
        Matrix4f m2 = new Matrix4f();
        Matrix4f t = new Matrix4f();
        m2.setIdentity();
        m2.setTranslation(TRSRTransformation.toVecmath(transform.c));
        t.setIdentity();
        t.rotY(transform.b.y);
        m2.mul(t);
        t.setIdentity();
        t.rotX(transform.b.x);
        m2.mul(t);
        t.setIdentity();
        t.rotZ(transform.b.z);
        m2.mul(t);
        t.setIdentity();
        t.m00 = transform.d.x;
        t.m11 = transform.d.y;
        t.m22 = transform.d.z;
        m2.mul(t);
        return m2;
    }

    public static boq handleCameraTransforms(boq model, bgr.b cameraTransformType) {
        if (model instanceof IPerspectiveAwareModel) {
            Pair<? extends IFlexibleBakedModel, Matrix4f> pair = ((IPerspectiveAwareModel)model).handlePerspective(cameraTransformType);
            if (pair.getRight() != null) {
                ForgeHooksClient.multiplyCurrentGlMatrix((Matrix4f)pair.getRight());
            }
            return (boq)pair.getLeft();
        }
        model.f().a(cameraTransformType);
        return model;
    }

    public static void multiplyCurrentGlMatrix(Matrix4f matrix) {
        matrixBuf.clear();
        float[] t = new float[4];
        for (int i = 0; i < 4; ++i) {
            matrix.getColumn(i, t);
            matrixBuf.put(t);
        }
        matrixBuf.flip();
        GL11.glMultMatrix((FloatBuffer)matrixBuf);
    }

    public static void preDraw(bmv.b attrType, bmu format, int element, int stride, ByteBuffer buffer) {
        bmv attr = format.c(element);
        int count = attr.c();
        int constant = attr.a().c();
        buffer.position(format.d(element));
        switch (attrType) {
            case a: {
                GL11.glVertexPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32884);
                break;
            }
            case b: {
                if (count != 3) {
                    throw new IllegalArgumentException("Normal attribute should have the size 3: " + attr);
                }
                GL11.glNormalPointer((int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32885);
                break;
            }
            case c: {
                GL11.glColorPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32886);
                break;
            }
            case d: {
                bqs.l((int)(bqs.q + attr.d()));
                GL11.glTexCoordPointer((int)count, (int)constant, (int)stride, (ByteBuffer)buffer);
                GL11.glEnableClientState((int)32888);
                bqs.l((int)bqs.q);
                break;
            }
            case g: {
                break;
            }
            case GENERIC: {
                GL20.glEnableVertexAttribArray((int)attr.d());
                GL20.glVertexAttribPointer((int)attr.d(), (int)count, (int)constant, (boolean)false, (int)stride, (ByteBuffer)buffer);
            }
            default: {
                FMLLog.severe("Unimplemented vanilla attribute upload: %s", attrType.a());
            }
        }
    }

    public static void postDraw(bmv.b attrType, bmu format, int element, int stride, ByteBuffer buffer) {
        bmv attr = format.c(element);
        switch (attrType) {
            case a: {
                GL11.glDisableClientState((int)32884);
                break;
            }
            case b: {
                GL11.glDisableClientState((int)32885);
                break;
            }
            case c: {
                GL11.glDisableClientState((int)32886);
                bfl.G();
                break;
            }
            case d: {
                bqs.l((int)(bqs.q + attr.d()));
                GL11.glDisableClientState((int)32888);
                bqs.l((int)bqs.q);
                break;
            }
            case g: {
                break;
            }
            case GENERIC: {
                GL20.glDisableVertexAttribArray((int)attr.d());
            }
            default: {
                FMLLog.severe("Unimplemented vanilla attribute upload: %s", attrType.a());
            }
        }
    }

    public static void transform(org.lwjgl.util.vector.Vector3f vec, Matrix4f m2) {
        Vector4f tmp = new Vector4f(vec.x, vec.y, vec.z, 1.0f);
        m2.transform((Tuple4f)tmp);
        if ((double)Math.abs(tmp.w - 1.0f) > 1.0E-5) {
            tmp.scale(1.0f / tmp.w);
        }
        vec.set(tmp.x, tmp.y, tmp.z);
    }

    public static Matrix4f getMatrix(bor modelRotation) {
        Matrix4f ret = new Matrix4f(TRSRTransformation.toVecmath(modelRotation.a()));
        Matrix4f tmp = new Matrix4f();
        tmp.setIdentity();
        tmp.m23 = 0.5f;
        tmp.m13 = 0.5f;
        tmp.m03 = 0.5f;
        ret.mul(tmp, ret);
        tmp.invert();
        ret.mul(tmp);
        return ret;
    }

    public static void putQuadColor(bfd renderer, bgg quad, int color) {
        float cr = color & 0xFF;
        float cg = color >>> 8 & 0xFF;
        float cb = color >>> 16 & 0xFF;
        float ca = color >>> 24 & 0xFF;
        for (int i = 0; i < 4; ++i) {
            int vc = quad.a()[3 + 7 * i];
            float vcr = vc & 0xFF;
            float vcg = vc >>> 8 & 0xFF;
            float vcb = vc >>> 16 & 0xFF;
            float vca = vc >>> 24 & 0xFF;
            int ncr = Math.min(255, (int)(cr * vcr / 255.0f));
            int ncg = Math.min(255, (int)(cg * vcg / 255.0f));
            int ncb = Math.min(255, (int)(cb * vcb / 255.0f));
            int nca = Math.min(255, (int)(ca * vca / 255.0f));
            renderer.a(renderer.c(4 - i), ncr, ncg, ncb, nca);
        }
    }

    public static void renderTileItem(zw item, int metadata) {
        bhd r;
        Class<? extends akw> tileClass = tileItemMap.get(Pair.of((Object)item, (Object)metadata));
        if (tileClass != null && (r = bhc.a.a(tileClass)) != null) {
            r.a(null, 0.0, 0.0, 0.0, 0.0f, -1);
        }
    }

    @Deprecated
    public static void registerTESRItemStack(zw item, int metadata, Class<? extends akw> TileClass) {
        tileItemMap.put((Pair<zw, Integer>)Pair.of((Object)item, (Object)metadata), TileClass);
    }

    public static void fillNormal(int[] faceData, cq facing) {
        Vector3f v1 = new Vector3f((float)faceData[21], (float)faceData[22], (float)faceData[23]);
        Vector3f t = new Vector3f((float)faceData[7], (float)faceData[8], (float)faceData[9]);
        Vector3f v2 = new Vector3f((float)faceData[14], (float)faceData[15], (float)faceData[16]);
        v1.sub((Tuple3f)t);
        t.set((float)faceData[0], (float)faceData[1], (float)faceData[2]);
        v2.sub((Tuple3f)t);
        v1.cross(v2, v1);
        v1.normalize();
        int x = (byte)(v1.x * 127.0f) & 0xFF;
        int y = (byte)(v1.y * 127.0f) & 0xFF;
        int z = (byte)(v1.z * 127.0f) & 0xFF;
        for (int i = 0; i < 4; ++i) {
            faceData[i * 7 + 6] = x | y << 8 | z << 16;
        }
    }

    public static Optional<TRSRTransformation> applyTransform(bgq transform, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)new TRSRTransformation(transform));
    }

    public static Optional<TRSRTransformation> applyTransform(Matrix4f matrix, Optional<? extends IModelPart> part) {
        if (part.isPresent()) {
            return Optional.absent();
        }
        return Optional.of((Object)new TRSRTransformation(matrix));
    }

    static {
        matrixBuf = BufferUtils.createFloatBuffer((int)16);
        tileItemMap = Maps.newHashMap();
    }
}

