/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.client.model;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraftforge.client.model.ForgeBlockStateV1;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelCustomData;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ISmartVariant;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.client.model.MultiModel;
import net.minecraftforge.client.model.TRSRTransformation;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public class BlockStateLoader {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapter(ForgeBlockStateV1.class, (Object)ForgeBlockStateV1.Deserializer.INSTANCE).registerTypeAdapter(ForgeBlockStateV1.Variant.class, (Object)ForgeBlockStateV1.Variant.Deserializer.INSTANCE).registerTypeAdapter(TRSRTransformation.class, (Object)ForgeBlockStateV1.TRSRDeserializer.INSTANCE).create();

    public static bgm load(Reader reader, Gson vanillaGSON) {
        try {
            byte[] data = IOUtils.toByteArray((Reader)reader);
            reader = new InputStreamReader((InputStream)new ByteArrayInputStream(data), Charsets.UTF_8);
            Marker marker = (Marker)GSON.fromJson(new String(data), Marker.class);
            switch (marker.forge_marker) {
                case 1: {
                    ForgeBlockStateV1 v1 = (ForgeBlockStateV1)GSON.fromJson(reader, ForgeBlockStateV1.class);
                    ArrayList variants = Lists.newArrayList();
                    for (Map.Entry entry : v1.variants.asMap().entrySet()) {
                        ArrayList mcVars = Lists.newArrayList();
                        for (ForgeBlockStateV1.Variant var : (Collection)entry.getValue()) {
                            boolean uvLock = (Boolean)var.getUvLock().or((Object)false);
                            int weight = (Integer)var.getWeight().or((Object)1);
                            if (var.getModel() != null && var.getSubmodels().size() == 0 && var.getTextures().size() == 0 && var.getCustomData().size() == 0 && var.getState().orNull() instanceof bor) {
                                mcVars.add(new bgm.c(var.getModel(), (bor)var.getState().get(), uvLock, weight));
                                continue;
                            }
                            mcVars.add(new ForgeVariant(var.getModel(), (IModelState)var.getState().or((Object)TRSRTransformation.identity()), uvLock, weight, var.getTextures(), var.getOnlyPartsVariant(), var.getCustomData()));
                        }
                        variants.add(new bgm.d((String)entry.getKey(), (List)mcVars));
                    }
                    return new bgm((Collection)variants);
                }
            }
            return (bgm)vanillaGSON.fromJson(reader, bgm.class);
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
            return null;
        }
    }

    private static class ForgeVariant
    extends bgm.c
    implements ISmartVariant {
        private final ImmutableMap<String, String> textures;
        private final ImmutableMap<String, SubModel> parts;
        private final ImmutableMap<String, String> customData;
        private final IModelState state;

        public ForgeVariant(jy model, IModelState state, boolean uvLock, int weight, ImmutableMap<String, String> textures, ImmutableMap<String, SubModel> parts, ImmutableMap<String, String> customData) {
            super(model == null ? new jy("builtin/missing") : model, state instanceof bor ? (bor)state : bor.a, uvLock, weight);
            this.textures = textures;
            this.parts = parts;
            this.customData = customData;
            this.state = state;
        }

        protected IModel runModelHooks(IModel base, ImmutableMap<String, String> textureMap, ImmutableMap<String, String> customData) {
            if (!customData.isEmpty() && base instanceof IModelCustomData) {
                base = ((IModelCustomData)base).process(customData);
            }
            if (!textureMap.isEmpty() && base instanceof IRetexturableModel) {
                base = ((IRetexturableModel)base).retexture(textureMap);
            }
            return base;
        }

        @Override
        public IModel process(IModel base, ModelLoader loader) {
            boolean hasBase;
            int size = this.parts.size();
            boolean bl = hasBase = base != loader.getMissingModel();
            if (hasBase) {
                base = this.runModelHooks(base, this.textures, this.customData);
                if (size <= 0) {
                    return base;
                }
            }
            IModelState baseTr = this.getState();
            ImmutableMap.Builder models = ImmutableMap.builder();
            for (Map.Entry entry : this.parts.entrySet()) {
                SubModel part = (SubModel)entry.getValue();
                IModel model = null;
                try {
                    model = loader.getModel(part.getModelLocation());
                }
                catch (IOException e) {
                    FMLLog.warning("Unable to load block sub-model: '" + part.getModelLocation() + "': " + e.toString(), new Object[0]);
                    model = loader.getMissingModel();
                }
                IModelState partState = new ModelStateComposition(baseTr, part.getState());
                if (part.isUVLock()) {
                    partState = new ModelLoader.UVLock(partState);
                }
                models.put(entry.getKey(), (Object)Pair.of((Object)this.runModelHooks(model, part.getTextures(), part.getCustomData()), (Object)partState));
            }
            return new MultiModel(this.a(), hasBase ? base : null, baseTr, (ImmutableMap<String, Pair<IModel, IModelState>>)models.build());
        }

        public IModelState getState() {
            return this.state;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("TexturedVariant:");
            for (Map.Entry e : this.textures.entrySet()) {
                buf.append(" ").append((String)e.getKey()).append(" = ").append((String)e.getValue());
            }
            return buf.toString();
        }
    }

    public static class SubModel {
        private final IModelState state;
        private final boolean uvLock;
        private final ImmutableMap<String, String> textures;
        private final jy model;
        private final ImmutableMap<String, String> customData;

        public SubModel(IModelState state, boolean uvLock, ImmutableMap<String, String> textures, jy model, ImmutableMap<String, String> customData) {
            this.state = state;
            this.uvLock = uvLock;
            this.textures = textures;
            this.model = model;
            this.customData = customData;
        }

        public IModelState getState() {
            return this.state;
        }

        public boolean isUVLock() {
            return this.uvLock;
        }

        public ImmutableMap<String, String> getTextures() {
            return this.textures;
        }

        public jy getModelLocation() {
            return this.model;
        }

        public ImmutableMap<String, String> getCustomData() {
            return this.customData;
        }
    }

    public static class Marker {
        public int forge_marker = -1;
    }
}

