/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraftforge.common.ChestGenHooks;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.AnvilUpdateEvent;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.AnvilRepairEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.NoteBlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class ForgeHooks {
    static final List<SeedEntry> seedList = new ArrayList<SeedEntry>();
    private static boolean toolInit = false;
    static final Pattern URL_PATTERN;
    private static ThreadLocal<wn> craftingPlayer;

    public static zx getGrassSeed(Random rand) {
        SeedEntry entry = (SeedEntry)oa.a((Random)rand, seedList);
        if (entry == null || entry.seed == null) {
            return null;
        }
        return entry.seed.k();
    }

    public static boolean canHarvestBlock(afh block, wn player, adq world, cj pos) {
        if (block.t().l()) {
            return true;
        }
        zx stack = player.bi.h();
        alz state = world.p(pos);
        state = state.c().a(state, world, pos);
        String tool = block.getHarvestTool(state);
        if (stack == null || tool == null) {
            return player.b(block);
        }
        int toolLevel = stack.b().getHarvestLevel(stack, tool);
        if (toolLevel < 0) {
            return player.b(block);
        }
        return toolLevel >= block.getHarvestLevel(state);
    }

    public static boolean canToolHarvestBlock(adq world, cj pos, zx stack) {
        alz state = world.p(pos);
        state = state.c().a(state, world, pos);
        String tool = state.c().getHarvestTool(state);
        if (stack == null || tool == null) {
            return false;
        }
        return stack.b().getHarvestLevel(stack, tool) >= state.c().getHarvestLevel(state);
    }

    public static float blockStrength(alz state, wn player, adm world, cj pos) {
        float hardness = state.c().g(world, pos);
        if (hardness < 0.0f) {
            return 0.0f;
        }
        if (!ForgeHooks.canHarvestBlock(state.c(), player, (adq)world, pos)) {
            return player.getBreakSpeed(state, pos) / hardness / 100.0f;
        }
        return player.getBreakSpeed(state, pos) / hardness / 30.0f;
    }

    public static boolean isToolEffective(adq world, cj pos, zx stack) {
        alz state = world.p(pos);
        state = state.c().a(state, world, pos);
        for (String type : stack.b().getToolClasses(stack)) {
            if (!state.c().isToolEffective(type, state)) continue;
            return true;
        }
        return false;
    }

    static void initTools() {
        if (toolInit) {
            return;
        }
        toolInit = true;
        Set blocks = (Set)ReflectionHelper.getPrivateValue(aag.class, null, 0);
        for (afh block : blocks) {
            block.setHarvestLevel("pickaxe", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(aaq.class, null, 0);
        for (afh block : blocks) {
            block.setHarvestLevel("shovel", 0);
        }
        blocks = (Set)ReflectionHelper.getPrivateValue(yl.class, null, 0);
        for (afh block : blocks) {
            block.setHarvestLevel("axe", 0);
        }
        afi.Z.setHarvestLevel("pickaxe", 3);
        for (afh block : new afh[]{afi.bP, afi.bT, afi.ag, afi.ah, afi.o, afi.R, afi.aC, afi.aD}) {
            block.setHarvestLevel("pickaxe", 2);
        }
        afi.p.setHarvestLevel("pickaxe", 1);
        afi.S.setHarvestLevel("pickaxe", 1);
        afi.x.setHarvestLevel("pickaxe", 1);
        afi.y.setHarvestLevel("pickaxe", 1);
        afi.co.setHarvestLevel("pickaxe", 0);
    }

    public static int getTotalArmorValue(wn player) {
        int ret = 0;
        for (int x = 0; x < player.bi.b.length; ++x) {
            zx stack = player.bi.b[x];
            if (stack != null && stack.b() instanceof ISpecialArmor) {
                ret += ((ISpecialArmor)stack.b()).getArmorDisplay(player, stack, x);
                continue;
            }
            if (stack == null || !(stack.b() instanceof yj)) continue;
            ret += ((yj)stack.b()).c;
        }
        return ret;
    }

    public static boolean onPickBlock(auh target, wn player, adm world) {
        zx result = null;
        boolean isCreative = player.bA.d;
        akw te = null;
        if (target.a == auh.a.b) {
            alz state = world.p(target.a());
            if (state.c().isAir((adq)world, target.a())) {
                return false;
            }
            if (isCreative && axu.q()) {
                te = world.s(target.a());
            }
            result = state.c().getPickBlock(target, world, target.a(), player);
        } else {
            if (target.a != auh.a.c || target.d == null || !isCreative) {
                return false;
            }
            result = target.d.getPickedResult(target);
        }
        if (result == null) {
            return false;
        }
        if (te != null) {
            dn nbt = new dn();
            te.b(nbt);
            result.a("BlockEntityTag", (eb)nbt);
            dn display = new dn();
            result.a("display", (eb)display);
            du lore = new du();
            display.a("Lore", (eb)lore);
            lore.a((eb)new ea("(+NBT)"));
        }
        for (int x = 0; x < 9; ++x) {
            zx stack = player.bi.a(x);
            if (stack == null || !stack.a(result) || !zx.a((zx)stack, (zx)result)) continue;
            player.bi.c = x;
            return true;
        }
        if (!isCreative) {
            return false;
        }
        int slot = player.bi.j();
        if (slot < 0 || slot >= 9) {
            slot = player.bi.c;
        }
        player.bi.a(slot, result);
        player.bi.c = slot;
        return true;
    }

    public static void onLivingSetAttackTarget(pr entity, pr target) {
        MinecraftForge.EVENT_BUS.post(new LivingSetAttackTargetEvent(entity, target));
    }

    public static boolean onLivingUpdate(pr entity) {
        return MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingUpdateEvent(entity));
    }

    public static boolean onLivingAttack(pr entity, ow src, float amount) {
        return !MinecraftForge.EVENT_BUS.post(new LivingAttackEvent(entity, src, amount));
    }

    public static float onLivingHurt(pr entity, ow src, float amount) {
        LivingHurtEvent event = new LivingHurtEvent(entity, src, amount);
        return MinecraftForge.EVENT_BUS.post(event) ? 0.0f : event.ammount;
    }

    public static boolean onLivingDeath(pr entity, ow src) {
        return MinecraftForge.EVENT_BUS.post(new LivingDeathEvent(entity, src));
    }

    public static boolean onLivingDrops(pr entity, ow source, ArrayList<uz> drops, int lootingLevel, boolean recentlyHit) {
        return MinecraftForge.EVENT_BUS.post(new LivingDropsEvent(entity, source, drops, lootingLevel, recentlyHit));
    }

    public static float[] onLivingFall(pr entity, float distance, float damageMultiplier) {
        float[] fArray;
        LivingFallEvent event = new LivingFallEvent(entity, distance, damageMultiplier);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            fArray = null;
        } else {
            float[] fArray2 = new float[2];
            fArray2[0] = event.distance;
            fArray = fArray2;
            fArray2[1] = event.damageMultiplier;
        }
        return fArray;
    }

    public static boolean isLivingOnLadder(afh block, adm world, cj pos, pr entity) {
        boolean isSpectator;
        boolean bl = isSpectator = entity instanceof wn && ((wn)entity).v();
        if (isSpectator) {
            return false;
        }
        if (!ForgeModContainer.fullBoundingBoxLadders) {
            return block != null && block.isLadder((adq)world, pos, entity);
        }
        aug bb = entity.aR();
        int mX = ns.c((double)bb.a);
        int mY = ns.c((double)bb.b);
        int mZ = ns.c((double)bb.c);
        int y2 = mY;
        while ((double)y2 < bb.e) {
            int x2 = mX;
            while ((double)x2 < bb.d) {
                int z2 = mZ;
                while ((double)z2 < bb.f) {
                    cj tmp = new cj(x2, y2, z2);
                    if (world.p(tmp).c().isLadder((adq)world, tmp, entity)) {
                        return true;
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public static void onLivingJump(pr entity) {
        MinecraftForge.EVENT_BUS.post(new LivingEvent.LivingJumpEvent(entity));
    }

    public static uz onPlayerTossEvent(wn player, zx item, boolean includeName) {
        player.captureDrops = true;
        uz ret = player.a(item, false, includeName);
        player.capturedDrops.clear();
        player.captureDrops = false;
        if (ret == null) {
            return null;
        }
        ItemTossEvent event = new ItemTossEvent(ret, player);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        player.a(event.entityItem);
        return event.entityItem;
    }

    public static float getEnchantPower(adm world, cj pos) {
        return world.p(pos).c().getEnchantPowerBonus(world, pos);
    }

    public static fb onServerChatEvent(lm net, String raw, fb comp) {
        ServerChatEvent event = new ServerChatEvent(net.b, raw, comp);
        if (MinecraftForge.EVENT_BUS.post(event)) {
            return null;
        }
        return event.component;
    }

    public static eu newChatWithLinks(String string) {
        return ForgeHooks.newChatWithLinks(string, true);
    }

    public static eu newChatWithLinks(String string, boolean allowMissingHeader) {
        fa ichat = null;
        Matcher matcher = URL_PATTERN.matcher(string);
        int lastEnd = 0;
        while (matcher.find()) {
            fa link;
            String url;
            block13: {
                int start = matcher.start();
                int end = matcher.end();
                String part = string.substring(lastEnd, start);
                if (part.length() > 0) {
                    if (ichat == null) {
                        ichat = new fa(part);
                    } else {
                        ichat.a(part);
                    }
                }
                lastEnd = end;
                url = string.substring(start, end);
                link = new fa(url);
                try {
                    if (new URI(url).getScheme() != null) break block13;
                    if (!allowMissingHeader) {
                        if (ichat == null) {
                            ichat = new fa(url);
                            continue;
                        }
                        ichat.a(url);
                        continue;
                    }
                    url = "http://" + url;
                }
                catch (URISyntaxException e2) {
                    if (ichat == null) {
                        ichat = new fa(url);
                        continue;
                    }
                    ichat.a(url);
                    continue;
                }
            }
            et click = new et(et.a.a, url);
            link.b().a(click);
            link.b().d(Boolean.valueOf(true));
            link.b().a(a.j);
            if (ichat == null) {
                ichat = link;
                continue;
            }
            ichat.a((eu)link);
        }
        String end = string.substring(lastEnd);
        if (ichat == null) {
            ichat = new fa(end);
        } else if (end.length() > 0) {
            ichat.a(string.substring(lastEnd));
        }
        return ichat;
    }

    public static boolean canInteractWith(wn player, xi openContainer) {
        PlayerOpenContainerEvent event = new PlayerOpenContainerEvent(player, openContainer);
        MinecraftForge.EVENT_BUS.post(event);
        return event.getResult() == Event.Result.DEFAULT ? event.canInteractWith : event.getResult() == Event.Result.ALLOW;
    }

    public static int onBlockBreakEvent(adm world, adp.a gameType, lf entityPlayer, cj pos) {
        boolean preCancelEvent = false;
        if (gameType.d() && entityPlayer.bA() != null && entityPlayer.bA().b() instanceof aay) {
            preCancelEvent = true;
        }
        if (gameType.c()) {
            zx itemstack;
            if (gameType == adp.a.e) {
                preCancelEvent = true;
            }
            if (!(entityPlayer.cn() || (itemstack = entityPlayer.bZ()) != null && itemstack.c(world.p(pos).c()))) {
                preCancelEvent = true;
            }
        }
        if (world.s(pos) == null) {
            fv packet = new fv(world, pos);
            packet.b = afi.a.Q();
            entityPlayer.a.a((ff)packet);
        }
        alz state = world.p(pos);
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, (wn)entityPlayer);
        event.setCanceled(preCancelEvent);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled()) {
            ff pkt;
            entityPlayer.a.a((ff)new fv(world, pos));
            akw tileentity = world.s(pos);
            if (tileentity != null && (pkt = tileentity.y_()) != null) {
                entityPlayer.a.a(pkt);
            }
        }
        return event.isCanceled() ? -1 : event.getExpToDrop();
    }

    public static boolean onPlaceItemIntoWorld(zx itemstack, wn player, adm world, cj pos, cq side, float hitX, float hitY, float hitZ) {
        int meta = itemstack.h();
        int size = itemstack.b;
        dn nbt = null;
        if (itemstack.o() != null) {
            nbt = (dn)itemstack.o().b();
        }
        if (!(itemstack.b() instanceof yv)) {
            world.captureBlockSnapshots = true;
        }
        boolean flag = itemstack.b().a(itemstack, player, world, pos, side, hitX, hitY, hitZ);
        world.captureBlockSnapshots = false;
        if (flag) {
            int newMeta = itemstack.h();
            int newSize = itemstack.b;
            dn newNBT = null;
            if (itemstack.o() != null) {
                newNBT = (dn)itemstack.o().b();
            }
            BlockEvent.PlaceEvent placeEvent = null;
            List blockSnapshots = (List)world.capturedBlockSnapshots.clone();
            world.capturedBlockSnapshots.clear();
            itemstack.b(meta);
            itemstack.b = size;
            if (nbt != null) {
                itemstack.d(nbt);
            }
            if (blockSnapshots.size() > 1) {
                placeEvent = ForgeEventFactory.onPlayerMultiBlockPlace(player, blockSnapshots, side);
            } else if (blockSnapshots.size() == 1) {
                placeEvent = ForgeEventFactory.onPlayerBlockPlace(player, (BlockSnapshot)blockSnapshots.get(0), side);
            }
            if (placeEvent != null && placeEvent.isCanceled()) {
                flag = false;
                for (BlockSnapshot blocksnapshot : blockSnapshots) {
                    world.restoringBlockSnapshots = true;
                    blocksnapshot.restore(true, false);
                    world.restoringBlockSnapshots = false;
                }
            } else {
                itemstack.b(newMeta);
                itemstack.b = newSize;
                if (nbt != null) {
                    itemstack.d(newNBT);
                }
                for (BlockSnapshot snap : blockSnapshots) {
                    int updateFlag = snap.flag;
                    alz oldBlock = snap.replacedBlock;
                    alz newBlock = world.p(snap.pos);
                    if (newBlock != null && !newBlock.c().hasTileEntity(newBlock)) {
                        newBlock.c().c(world, snap.pos, newBlock);
                    }
                    world.markAndNotifyBlock(snap.pos, null, oldBlock, newBlock, updateFlag);
                }
                player.a(na.ad[zw.b((zw)itemstack.b())], 1);
            }
        }
        world.capturedBlockSnapshots.clear();
        return flag;
    }

    public static boolean onAnvilChange(xk container, zx left, zx right, og outputSlot, String name, int baseCost) {
        AnvilUpdateEvent e2 = new AnvilUpdateEvent(left, right, name, baseCost);
        if (MinecraftForge.EVENT_BUS.post(e2)) {
            return false;
        }
        if (e2.output == null) {
            return true;
        }
        outputSlot.a(0, e2.output);
        container.a = e2.cost;
        container.k = e2.materialCost;
        return false;
    }

    public static float onAnvilRepair(wn player, zx output, zx left, zx right) {
        AnvilRepairEvent e2 = new AnvilRepairEvent(player, left, right, output);
        MinecraftForge.EVENT_BUS.post(e2);
        return e2.breakChance;
    }

    public static boolean onNoteChange(alm te, byte old) {
        NoteBlockEvent.Change e2 = new NoteBlockEvent.Change(te.z(), te.v(), te.z().p(te.v()), old, te.a);
        if (MinecraftForge.EVENT_BUS.post(e2)) {
            te.a = old;
            return false;
        }
        te.a = (byte)e2.getVanillaNoteId();
        return true;
    }

    public static zx[] defaultRecipeGetRemainingItems(xp inv) {
        zx[] ret = new zx[inv.o_()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = ForgeHooks.getContainerItem(inv.a(i));
        }
        return ret;
    }

    public static void setCraftingPlayer(wn player) {
        craftingPlayer.set(player);
    }

    public static wn getCraftingPlayer() {
        return craftingPlayer.get();
    }

    public static zx getContainerItem(zx stack) {
        if (stack == null) {
            return null;
        }
        if (stack.b().hasContainerItem(stack)) {
            if ((stack = stack.b().getContainerItem(stack)) != null && stack.e() && stack.i() > stack.j()) {
                MinecraftForge.EVENT_BUS.post(new PlayerDestroyItemEvent(craftingPlayer.get(), stack));
                return null;
            }
            return stack;
        }
        return null;
    }

    public static aol getBonusChest(Random rand) {
        return new aol(ChestGenHooks.getItems("bonusChest", rand), ChestGenHooks.getCount("bonusChest", rand));
    }

    public static boolean isInsideOfMaterial(arm material, pk entity, cj pos) {
        alz state = entity.o.p(pos);
        afh block = state.c();
        double eyes = entity.t + (double)entity.aS();
        double filled = 1.0;
        if (block instanceof IFluidBlock) {
            filled = ((IFluidBlock)block).getFilledPercentage(entity.o, pos);
        } else if (block instanceof ahv) {
            filled = ahv.b((int)block.c(state));
        }
        if (filled < 0.0) {
            return eyes > (double)(pos.o() + 1) + (1.0 - (filled *= -1.0));
        }
        return eyes < (double)(pos.o() + 1) + filled;
    }

    public static boolean onPlayerAttackTarget(wn player, pk target) {
        if (MinecraftForge.EVENT_BUS.post(new AttackEntityEvent(player, target))) {
            return false;
        }
        zx stack = player.bZ();
        return stack == null || !stack.b().onLeftClickEntity(stack, player, target);
    }

    public static boolean onTravelToDimension(pk entity, int dimension) {
        EntityTravelToDimensionEvent event = new EntityTravelToDimensionEvent(entity, dimension);
        MinecraftForge.EVENT_BUS.post(event);
        if (event.isCanceled() && entity instanceof vd) {
            ((vd)entity).b = true;
        }
        return !event.isCanceled();
    }

    static {
        seedList.add(new SeedEntry(new zx(zy.N), 10));
        ForgeHooks.initTools();
        URL_PATTERN = Pattern.compile("((?:[a-z0-9]{2,}:\\/\\/)?(?:(?:[0-9]{1,3}\\.){3}[0-9]{1,3}|(?:[-\\w_\\.]{1,}\\.[a-z]{2,}?))(?::[0-9]{1,5})?.*?(?=[!\"\u00a7 \n]|$))", 2);
        craftingPlayer = new ThreadLocal();
    }

    static class SeedEntry
    extends oa.a {
        public final zx seed;

        public SeedEntry(zx seed, int weight) {
            super(weight);
            this.seed = seed;
        }
    }
}

