/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.network;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.apache.logging.log4j.Level;

public abstract class ForgeMessage {
    abstract void toBytes(ByteBuf var1);

    abstract void fromBytes(ByteBuf var1);

    public static class FluidIdMapMessage
    extends ForgeMessage {
        BiMap<Fluid, Integer> fluidIds = HashBiMap.create();
        Set<String> defaultFluids = Sets.newHashSet();

        @Override
        void toBytes(ByteBuf bytes) {
            Map<Fluid, Integer> ids = FluidRegistry.getRegisteredFluidIDs();
            bytes.writeInt(ids.size());
            for (Map.Entry<Fluid, Integer> entry : ids.entrySet()) {
                ByteBufUtils.writeUTF8String(bytes, entry.getKey().getName());
                bytes.writeInt(entry.getValue().intValue());
            }
            for (Map.Entry<Fluid, Integer> entry : ids.entrySet()) {
                String defaultName = FluidRegistry.getDefaultFluidName(entry.getKey());
                ByteBufUtils.writeUTF8String(bytes, defaultName);
            }
        }

        @Override
        void fromBytes(ByteBuf bytes) {
            int i2;
            int listSize = bytes.readInt();
            for (i2 = 0; i2 < listSize; ++i2) {
                String fluidName = ByteBufUtils.readUTF8String(bytes);
                int fluidId = bytes.readInt();
                this.fluidIds.put((Object)FluidRegistry.getFluid(fluidName), (Object)fluidId);
            }
            if (bytes.isReadable()) {
                for (i2 = 0; i2 < listSize; ++i2) {
                    this.defaultFluids.add(ByteBufUtils.readUTF8String(bytes));
                }
            } else {
                FMLLog.getLogger().log(Level.INFO, "Legacy server message contains no default fluid list - there may be problems with fluids");
                this.defaultFluids.clear();
            }
        }
    }

    public static class DimensionRegisterMessage
    extends ForgeMessage {
        int dimensionId;
        int providerId;

        public DimensionRegisterMessage() {
        }

        public DimensionRegisterMessage(int dimensionId, int providerId) {
            this.dimensionId = dimensionId;
            this.providerId = providerId;
        }

        @Override
        void toBytes(ByteBuf bytes) {
            bytes.writeInt(this.dimensionId);
            bytes.writeInt(this.providerId);
        }

        @Override
        void fromBytes(ByteBuf bytes) {
            this.dimensionId = bytes.readInt();
            this.providerId = bytes.readInt();
        }
    }
}

