/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.fml.client.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiCheckBox;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.config.GuiMessageDialog;
import net.minecraftforge.fml.client.config.GuiUnicodeGlyphButton;
import net.minecraftforge.fml.client.config.HoverChecker;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.lwjgl.input.Keyboard;

public class GuiConfig
extends axu {
    public final axu parentScreen;
    public String title = "Config GUI";
    public String titleLine2;
    public final List<IConfigElement> configElements;
    public final List<GuiConfigEntries.IConfigEntry> initEntries;
    public GuiConfigEntries entryList;
    protected GuiButtonExt btnDefaultAll;
    protected GuiButtonExt btnUndoAll;
    protected GuiCheckBox chkApplyGlobally;
    public final String modID;
    public final String configID;
    public final boolean isWorldRunning;
    public final boolean allRequireWorldRestart;
    public final boolean allRequireMcRestart;
    public boolean needsRefresh = true;
    protected HoverChecker undoHoverChecker;
    protected HoverChecker resetHoverChecker;
    protected HoverChecker checkBoxHoverChecker;

    public GuiConfig(axu parentScreen, List<IConfigElement> configElements, String modID, String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        this(parentScreen, configElements, modID, configID, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    public GuiConfig(axu parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title) {
        this(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, null);
    }

    public GuiConfig(axu parentScreen, List<IConfigElement> configElements, String modID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2) {
        this(parentScreen, configElements, modID, null, allRequireWorldRestart, allRequireMcRestart, title, titleLine2);
    }

    public GuiConfig(axu parentScreen, List<IConfigElement> configElements, String modID, String configID, boolean allRequireWorldRestart, boolean allRequireMcRestart, String title, String titleLine2) {
        this.j = ave.A();
        this.parentScreen = parentScreen;
        this.configElements = configElements;
        this.entryList = new GuiConfigEntries(this, this.j);
        this.initEntries = new ArrayList<GuiConfigEntries.IConfigEntry>(this.entryList.listEntries);
        this.allRequireWorldRestart = allRequireWorldRestart;
        this.allRequireMcRestart = allRequireMcRestart;
        this.modID = modID;
        this.configID = configID;
        boolean bl = this.isWorldRunning = this.j.f != null;
        if (title != null) {
            this.title = title;
        }
        this.titleLine2 = titleLine2;
        if (this.titleLine2 != null && this.titleLine2.startsWith(" > ")) {
            this.titleLine2 = this.titleLine2.replaceFirst(" > ", "");
        }
    }

    public static String getAbridgedConfigPath(String path) {
        ave mc = ave.A();
        if (mc.v.getAbsolutePath().endsWith(".")) {
            return path.replace("\\", "/").replace(mc.v.getAbsolutePath().replace("\\", "/").substring(0, mc.v.getAbsolutePath().length() - 1), "/.minecraft/");
        }
        return path.replace("\\", "/").replace(mc.v.getAbsolutePath().replace("\\", "/"), "/.minecraft");
    }

    public void b() {
        Keyboard.enableRepeatEvents((boolean)true);
        if (this.entryList == null || this.needsRefresh) {
            this.entryList = new GuiConfigEntries(this, this.j);
            this.needsRefresh = false;
        }
        int undoGlyphWidth = this.j.k.a("\u21b6") * 2;
        int resetGlyphWidth = this.j.k.a("\u2604") * 2;
        int doneWidth = Math.max(this.j.k.a(bnq.a((String)"gui.done", (Object[])new Object[0])) + 20, 100);
        int undoWidth = this.j.k.a(" " + bnq.a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0])) + undoGlyphWidth + 20;
        int resetWidth = this.j.k.a(" " + bnq.a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0])) + resetGlyphWidth + 20;
        int checkWidth = this.j.k.a(bnq.a((String)"fml.configgui.applyGlobally", (Object[])new Object[0])) + 13;
        int buttonWidthHalf = (doneWidth + 5 + undoWidth + 5 + resetWidth + 5 + checkWidth) / 2;
        this.n.add(new GuiButtonExt(2000, this.l / 2 - buttonWidthHalf, this.m - 29, doneWidth, 20, bnq.a((String)"gui.done", (Object[])new Object[0])));
        this.btnDefaultAll = new GuiUnicodeGlyphButton(2001, this.l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5, this.m - 29, resetWidth, 20, " " + bnq.a((String)"fml.configgui.tooltip.resetToDefault", (Object[])new Object[0]), "\u2604", 2.0f);
        this.n.add(this.btnDefaultAll);
        this.btnUndoAll = new GuiUnicodeGlyphButton(2002, this.l / 2 - buttonWidthHalf + doneWidth + 5, this.m - 29, undoWidth, 20, " " + bnq.a((String)"fml.configgui.tooltip.undoChanges", (Object[])new Object[0]), "\u21b6", 2.0f);
        this.n.add(this.btnUndoAll);
        this.chkApplyGlobally = new GuiCheckBox(2003, this.l / 2 - buttonWidthHalf + doneWidth + 5 + undoWidth + 5 + resetWidth + 5, this.m - 24, bnq.a((String)"fml.configgui.applyGlobally", (Object[])new Object[0]), false);
        this.n.add(this.chkApplyGlobally);
        this.undoHoverChecker = new HoverChecker(this.btnUndoAll, 800);
        this.resetHoverChecker = new HoverChecker(this.btnDefaultAll, 800);
        this.checkBoxHoverChecker = new HoverChecker(this.chkApplyGlobally, 800);
        this.entryList.initGui();
    }

    public void m() {
        this.entryList.onGuiClosed();
        if (this.configID != null && this.parentScreen instanceof GuiConfig) {
            GuiConfig parentGuiConfig = (GuiConfig)this.parentScreen;
            parentGuiConfig.needsRefresh = true;
            parentGuiConfig.b();
        }
        if (!(this.parentScreen instanceof GuiConfig)) {
            Keyboard.enableRepeatEvents((boolean)false);
        }
    }

    protected void a(avs button) {
        if (button.k == 2000) {
            boolean flag = true;
            try {
                if ((this.configID != null || this.parentScreen == null || !(this.parentScreen instanceof GuiConfig)) && this.entryList.hasChangedEntry(true)) {
                    boolean requiresMcRestart = this.entryList.saveConfigElements();
                    if (Loader.isModLoaded(this.modID)) {
                        ConfigChangedEvent.OnConfigChangedEvent event = new ConfigChangedEvent.OnConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart);
                        MinecraftForge.EVENT_BUS.post(event);
                        if (!event.getResult().equals((Object)Event.Result.DENY)) {
                            MinecraftForge.EVENT_BUS.post(new ConfigChangedEvent.PostConfigChangedEvent(this.modID, this.configID, this.isWorldRunning, requiresMcRestart));
                        }
                        if (requiresMcRestart) {
                            flag = false;
                            this.j.a((axu)new GuiMessageDialog(this.parentScreen, "fml.configgui.gameRestartTitle", (eu)new fa(bnq.a((String)"fml.configgui.gameRestartRequired", (Object[])new Object[0])), "fml.configgui.confirmRestartMessage"));
                        }
                        if (this.parentScreen instanceof GuiConfig) {
                            ((GuiConfig)this.parentScreen).needsRefresh = true;
                        }
                    }
                }
            }
            catch (Throwable e2) {
                e2.printStackTrace();
            }
            if (flag) {
                this.j.a(this.parentScreen);
            }
        } else if (button.k == 2001) {
            this.entryList.setAllToDefault(this.chkApplyGlobally.isChecked());
        } else if (button.k == 2002) {
            this.entryList.undoAllChanges(this.chkApplyGlobally.isChecked());
        }
    }

    public void k() throws IOException {
        super.k();
        this.entryList.p();
    }

    protected void a(int x, int y, int mouseEvent) throws IOException {
        if (mouseEvent != 0 || !this.entryList.b(x, y, mouseEvent)) {
            this.entryList.mouseClickedPassThru(x, y, mouseEvent);
            super.a(x, y, mouseEvent);
        }
    }

    protected void b(int x, int y, int mouseEvent) {
        if (mouseEvent != 0 || !this.entryList.c(x, y, mouseEvent)) {
            super.b(x, y, mouseEvent);
        }
    }

    protected void a(char eventChar, int eventKey) {
        if (eventKey == 1) {
            this.j.a(this.parentScreen);
        } else {
            this.entryList.keyTyped(eventChar, eventKey);
        }
    }

    public void e() {
        super.e();
        this.entryList.updateScreen();
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.c();
        this.entryList.a(mouseX, mouseY, partialTicks);
        this.a(this.q, this.title, this.l / 2, 8, 0xFFFFFF);
        String title2 = this.titleLine2;
        if (title2 != null) {
            int strWidth = this.j.k.a(title2);
            int elipsisWidth = this.j.k.a("...");
            if (strWidth > this.l - 6 && strWidth > elipsisWidth) {
                title2 = this.j.k.a(title2, this.l - 6 - elipsisWidth).trim() + "...";
            }
            this.a(this.q, title2, this.l / 2, 18, 0xFFFFFF);
        }
        this.btnUndoAll.l = this.entryList.areAnyEntriesEnabled(this.chkApplyGlobally.isChecked()) && this.entryList.hasChangedEntry(this.chkApplyGlobally.isChecked());
        this.btnDefaultAll.l = this.entryList.areAnyEntriesEnabled(this.chkApplyGlobally.isChecked()) && !this.entryList.areAllEntriesDefault(this.chkApplyGlobally.isChecked());
        super.a(mouseX, mouseY, partialTicks);
        this.entryList.drawScreenPost(mouseX, mouseY, partialTicks);
        if (this.undoHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.j.k.c(bnq.a((String)"fml.configgui.tooltip.undoAll", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        if (this.resetHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.j.k.c(bnq.a((String)"fml.configgui.tooltip.resetAll", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
        if (this.checkBoxHoverChecker.checkHover(mouseX, mouseY)) {
            this.drawToolTip(this.j.k.c(bnq.a((String)"fml.configgui.tooltip.applyGlobally", (Object[])new Object[0]), 300), mouseX, mouseY);
        }
    }

    public void drawToolTip(List<String> stringList, int x, int y) {
        this.a(stringList, x, y);
    }
}

