/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.capabilities;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;

public final class CapabilityDispatcher
implements INBTSerializable<dq>,
ICapabilityProvider {
    private ICapabilityProvider[] caps;
    private INBTSerializable<ed>[] writers;
    private String[] names;

    public CapabilityDispatcher(Map<kl, ICapabilityProvider> list) {
        this(list, null);
    }

    public CapabilityDispatcher(Map<kl, ICapabilityProvider> list, ICapabilityProvider parent) {
        ArrayList lstCaps = Lists.newArrayList();
        ArrayList lstWriters = Lists.newArrayList();
        ArrayList lstNames = Lists.newArrayList();
        if (parent != null) {
            lstCaps.add(parent);
            if (parent instanceof INBTSerializable) {
                lstWriters.add((INBTSerializable)((Object)parent));
                lstNames.add("Parent");
            }
        }
        for (Map.Entry<kl, ICapabilityProvider> entry : list.entrySet()) {
            ICapabilityProvider prov = entry.getValue();
            lstCaps.add(prov);
            if (!(prov instanceof INBTSerializable)) continue;
            lstWriters.add((INBTSerializable)((Object)prov));
            lstNames.add(entry.getKey().toString());
        }
        this.caps = lstCaps.toArray(new ICapabilityProvider[lstCaps.size()]);
        this.writers = lstWriters.toArray(new INBTSerializable[lstWriters.size()]);
        this.names = lstNames.toArray(new String[lstNames.size()]);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable cs facing) {
        for (ICapabilityProvider cap : this.caps) {
            if (!cap.hasCapability(capability, facing)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable cs facing) {
        for (ICapabilityProvider cap : this.caps) {
            T ret = cap.getCapability(capability, facing);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public dq serializeNBT() {
        dq nbt = new dq();
        for (int x = 0; x < this.writers.length; ++x) {
            nbt.a(this.names[x], this.writers[x].serializeNBT());
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(dq nbt) {
        for (int x = 0; x < this.writers.length; ++x) {
            if (!nbt.e(this.names[x])) continue;
            this.writers[x].deserializeNBT(nbt.c(this.names[x]));
        }
    }

    public boolean areCompatible(CapabilityDispatcher other) {
        if (other == null) {
            return this.writers.length == 0;
        }
        if (this.writers.length == 0) {
            return other.writers.length == 0;
        }
        return this.serializeNBT().equals((Object)other.serializeNBT());
    }
}

