/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.util;

import java.io.Serializable;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class BlockSnapshot
implements Serializable {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("forge.debugBlockSnapshot", "false"));
    private final cl pos;
    private final int dimId;
    private transient ard replacedBlock;
    private int flag;
    private final dq nbt;
    private transient aht world;
    private final kl registryName;
    private final int meta;

    public BlockSnapshot(aht world, cl pos, ard state) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos;
        this.setReplacedBlock(state);
        this.registryName = state.t().getRegistryName();
        this.meta = state.t().e(state);
        this.setFlag(3);
        apv te = world.r(pos);
        if (te != null) {
            this.nbt = new dq();
            te.b(this.getNbt());
        } else {
            this.nbt = null;
        }
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.T().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(aht world, cl pos, ard state, dq nbt) {
        this.setWorld(world);
        this.dimId = world.s.getDimension();
        this.pos = pos.h();
        this.setReplacedBlock(state);
        this.registryName = state.t().getRegistryName();
        this.meta = state.t().e(state);
        this.setFlag(3);
        this.nbt = nbt;
        if (DEBUG) {
            System.out.printf("Created BlockSnapshot - [World: %s ][Location: %d,%d,%d ][Block: %s ][Meta: %d ]", world.T().j(), pos.p(), pos.q(), pos.r(), this.getRegistryName(), this.getMeta());
        }
    }

    public BlockSnapshot(aht world, cl pos, ard state, int flag) {
        this(world, pos, state);
        this.setFlag(flag);
    }

    public BlockSnapshot(int dimension, cl pos, String modId, String blockName, int meta, int flag, dq nbt) {
        this.dimId = dimension;
        this.pos = pos.h();
        this.setFlag(flag);
        this.registryName = new kl(modId, blockName);
        this.meta = meta;
        this.nbt = nbt;
    }

    public static BlockSnapshot getBlockSnapshot(aht world, cl pos) {
        return new BlockSnapshot(world, pos, world.o(pos));
    }

    public static BlockSnapshot getBlockSnapshot(aht world, cl pos, int flag) {
        return new BlockSnapshot(world, pos, world.o(pos), flag);
    }

    public static BlockSnapshot readFromNBT(dq tag) {
        dq nbt = tag.p("hasTE") ? null : tag.o("tileEntity");
        return new BlockSnapshot(tag.h("dimension"), new cl(tag.h("posX"), tag.h("posY"), tag.h("posZ")), tag.l("blockMod"), tag.l("blockName"), tag.h("metadata"), tag.h("flag"), nbt);
    }

    public ard getCurrentBlock() {
        return this.getWorld().o(this.getPos());
    }

    public aht getWorld() {
        if (this.world == null) {
            this.world = DimensionManager.getWorld(this.getDimId());
        }
        return this.world;
    }

    public ard getReplacedBlock() {
        if (this.replacedBlock == null) {
            this.replacedBlock = GameRegistry.findBlock(this.getRegistryName().b(), this.getRegistryName().a()).a(this.getMeta());
        }
        return this.replacedBlock;
    }

    public apv getTileEntity() {
        if (this.getNbt() != null) {
            return apv.c((dq)this.getNbt());
        }
        return null;
    }

    public boolean restore() {
        return this.restore(false);
    }

    public boolean restore(boolean force) {
        return this.restore(force, true);
    }

    public boolean restore(boolean force, boolean applyPhysics) {
        ard current = this.getCurrentBlock();
        ard replaced = this.getReplacedBlock();
        if (current.t() != replaced.t() || current.t().e(current) != replaced.t().e(replaced)) {
            if (force) {
                this.getWorld().a(this.getPos(), replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        this.getWorld().a(this.getPos(), replaced, applyPhysics ? 3 : 2);
        this.getWorld().a(this.getPos(), current, replaced, applyPhysics ? 3 : 2);
        apv te = null;
        if (this.getNbt() != null && (te = this.getWorld().r(this.getPos())) != null) {
            te.a(this.getNbt());
            te.v_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", this.getWorld().T().j(), this.getPos().p(), this.getPos().q(), this.getPos().r(), replaced.t().e(replaced), replaced.t().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public boolean restoreToLocation(aht world, cl pos, boolean force, boolean applyPhysics) {
        ard current = this.getCurrentBlock();
        ard replaced = this.getReplacedBlock();
        if (current.t() != replaced.t() || current.t().e(current) != replaced.t().e(replaced)) {
            if (force) {
                world.a(pos, replaced, applyPhysics ? 3 : 2);
            } else {
                return false;
            }
        }
        world.a(pos, replaced, applyPhysics ? 3 : 2);
        world.a(pos, current, replaced, applyPhysics ? 3 : 2);
        apv te = null;
        if (this.getNbt() != null && (te = world.r(pos)) != null) {
            te.a(this.getNbt());
            te.v_();
        }
        if (DEBUG) {
            System.out.printf("Restored BlockSnapshot with data [World: %s ][Location: %d,%d,%d ][Meta: %d ][Block: %s ][TileEntity: %s ][force: %s ][applyPhysics: %s]", world.T().j(), pos.p(), pos.q(), pos.r(), replaced.t().e(replaced), replaced.t().delegate.name(), te, force, applyPhysics);
        }
        return true;
    }

    public void writeToNBT(dq compound) {
        compound.a("blockMod", this.getRegistryName().b());
        compound.a("blockName", this.getRegistryName().a());
        compound.a("posX", this.getPos().p());
        compound.a("posY", this.getPos().q());
        compound.a("posZ", this.getPos().r());
        compound.a("flag", this.getFlag());
        compound.a("dimension", this.getDimId());
        compound.a("metadata", this.getMeta());
        compound.a("hasTE", this.getNbt() != null);
        if (this.getNbt() != null) {
            compound.a("tileEntity", (ed)this.getNbt());
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockSnapshot other = (BlockSnapshot)obj;
        if (!this.getPos().equals((Object)other.getPos())) {
            return false;
        }
        if (this.getMeta() != other.getMeta()) {
            return false;
        }
        if (this.getDimId() != other.getDimId()) {
            return false;
        }
        if (!(this.getNbt() == other.getNbt() || this.getNbt() != null && this.getNbt().equals((Object)other.getNbt()))) {
            return false;
        }
        if (!(this.getWorld() == other.getWorld() || this.getWorld() != null && this.getWorld().equals(other.getWorld()))) {
            return false;
        }
        return this.getRegistryName() == other.getRegistryName() || this.getRegistryName() != null && this.getRegistryName().equals((Object)other.getRegistryName());
    }

    public int hashCode() {
        int hash = 7;
        hash = 73 * hash + this.getPos().p();
        hash = 73 * hash + this.getPos().q();
        hash = 73 * hash + this.getPos().r();
        hash = 73 * hash + this.getMeta();
        hash = 73 * hash + this.getDimId();
        hash = 73 * hash + (this.getNbt() != null ? this.getNbt().hashCode() : 0);
        hash = 73 * hash + (this.getWorld() != null ? this.getWorld().hashCode() : 0);
        hash = 73 * hash + (this.getRegistryName() != null ? this.getRegistryName().hashCode() : 0);
        return hash;
    }

    public cl getPos() {
        return this.pos;
    }

    public int getDimId() {
        return this.dimId;
    }

    public void setReplacedBlock(ard replacedBlock) {
        this.replacedBlock = replacedBlock;
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public dq getNbt() {
        return this.nbt;
    }

    public void setWorld(aht world) {
        this.world = world;
    }

    public kl getRegistryName() {
        return this.registryName;
    }

    public int getMeta() {
        return this.meta;
    }
}

